# EQ-5D-5L Levels - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **EQ-5D-5L Levels**

## CodeSystem: EQ-5D-5L Levels 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs | *Version*:0.1.0 |
| Active as of 2025-12-01 | *Computable Name*:EQ5DLevelsCS |

 This Code system is referenced in the content logical definition of the following value sets: 

* [EQ5D-AnxietyDepression-VS](ValueSet-eq5d-anxdep-vs.md)
* [EQ5DLevelsVS](ValueSet-eq5d-levels-vs.md)
* [EQ5D-Mobility-VS](ValueSet-eq5d-mobility-vs.md)
* [EQ5D-PainDiscomfort-VS](ValueSet-eq5d-pain-vs.md)
* [EQ5D-SelfCare-VS](ValueSet-eq5d-selfcare-vs.md)
* [EQ5D-UsualActivities-VS](ValueSet-eq5d-usualactivities-vs.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "eq5d-levels-cs",
  "url" : "http://hl7.eu/fhir/ig/gravitate-health-ips/CodeSystem/eq5d-levels-cs",
  "version" : "0.1.0",
  "name" : "EQ5DLevelsCS",
  "title" : "EQ-5D-5L Levels",
  "status" : "active",
  "date" : "2025-12-01T10:57:47+00:00",
  "contact" : [
    {
      "name" : "Gravitate Health Project",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.gravitatehealth.eu/"
        }
      ]
    }
  ],
  "content" : "complete",
  "count" : 5,
  "concept" : [
    {
      "code" : "1",
      "display" : "No problems"
    },
    {
      "code" : "2",
      "display" : "Slight problems"
    },
    {
      "code" : "3",
      "display" : "Moderate problems"
    },
    {
      "code" : "4",
      "display" : "Severe problems"
    },
    {
      "code" : "5",
      "display" : "Extreme problems / unable to"
    }
  ]
}

```
