# IPS Example JP - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IPS Example JP**

## Example Bundle: IPS Example JP

**id:**gravitate-ips-jp

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**ips-jp

**Name:**IPS-JP Gravitate

**active:**true

**gender:**female

**Birth Date:**1946-05-05

### Sections

#### Problem List

**Condition:**Malignant neoplasm of breast (254837009)

**clinicalStatus:**active

**asserter:**Dr. IPS-JP

**Condition:**Rheumatoid arthritis (69896004)

**clinicalStatus:**active

**asserter:**Dr. IPS-JP

**onsetDateTime:**2015

**Condition:**Hypercholesterolemia (13644009)

**clinicalStatus:**active

**onsetDateTime:**1993

**Condition:**Epilepsy (84757009)

**clinicalStatus:**active

**onsetDateTime:**1993

#### Allergies and Intolerances

**Allergy:**(no-allergy-info)

**clinicalStatus:**active

**verificationStatus:**confirmed

#### Medication Summary

**Medication:**trastuzumab

**status:**active

**Medication Detail:**

*  **System** http://iyaku.info/medicine/ **Code:** 4291447D2024 []

**Dose Form:**Powder and solvent for concentrate for solution for infusion

**Ingredient:**trastuzumab (http://fdasis.nlm.nih.gov#P188ANX8CK)

**Route:**Intravenous use

**Medication:**simvastatin

**status:**active

**Medication Detail:**

*  **System** http://iyaku.info/medicine/ **Code:** 2189011F1262 []

*  **System** https://www.who-umc.org/phpid **Code:** F92168108C432D63DACDD70444176BB3 [Lipcut Simvastatin 5 mg tablet]

**Dose Form:**Tablet

**Ingredient:**SIMVASTATIN (http://fdasis.nlm.nih.gov#AGG2FN16EV)

**Route:**Oral use

**Medication:**enbrel

**status:**active

**Medication Detail:**

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82716 [Enbrel Etanercept 25 mg powder for solution for injection]

**Dose Form:**Powder and solution for solution for injection

**Ingredient:**ETANERCEPT (ENBREL) (http://fdasis.nlm.nih.gov#OP401G7OJC)

**Route:**Subcutaneous use

**Medication:**carbamazepine

**status:**active

**Medication Detail:**

*  **System** http://iyaku.info/medicine/ **Code:** 1139002F1070 []

*  **System** https://www.who-umc.org/phpid **Code:** 5C62673C79E096D37914D32A45AA8F4D [Tegretol Carbamazepine 200 mg tablets]

*  **System** https://www.who-umc.org/phpid **Code:** FB9808F4FED210183F412F9998622287 [Tegretol Carbamazepine 200 mg tablets]

**Dose Form:**Tablet

**Ingredient:**CARBAMAZEPINE (http://fdasis.nlm.nih.gov#33CM23913M)

**Route:**Oral use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-ips-jp",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "ips-jp"
  },
  "type" : "document",
  "timestamp" : "2021-09-03T08:38:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/2fa5b223-ebce-4f39-9c66-5dc014f7359c",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "ips-example-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_ips-example-2\"> </a>\n  \n\n    \n      <b>Id:</b>\n      ips-example-2\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>IPS-JP</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Malignant neoplasm of breast (disorder)\n\n            </li>\n          \n\n            <li>\n\n              Hypercholesterolemia\n\n            </li>\n          \n\n            <li>\n\n              Rheumatoid arthritis\n\n            </li>\n          \n\n            <li>\n\n              Epilepsy (disorder)\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              No infos about Allergies\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Ogivri\ttrastuzumab 150 mg\tpowder for concentrate for solution for infusion\n\n            </li>\n          \n\n            <li>\n\n              Lipcut\tSimvastatin\t20 mg tablet\n\n            </li>\n          \n\n            <li>\n\n              Enbrel Etanercept 25 mg powder for solution for injection\n\n            </li>\n          \n\n            <li>\n\n              Tegretol Carbamazepine\t200 mg\ttablets\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d9c",
            "display" : "Dr. JP"
          }
        ],
        "title" : "Patient Summary (IPSJP)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Malignant neoplasm of breast (disorder)</li></ul><ul><li>Hypercholesterolemia</li></ul><ul><li>Rheumatoid arthritis</li></ul><ul><li>Epilepsy</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "Condition/bcc79261-142c-48ec-b032-f3f9af49ec59c",
                "display" : "Malignant neoplasm of breast (disorder)"
              },
              {
                "reference" : "Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5139c",
                "display" : "Hypercholesterolemia"
              },
              {
                "reference" : "Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6259c",
                "display" : "Rheumatoid arthritis"
              },
              {
                "reference" : "Condition/f06b7cf8-c15c-4288-a0f9-45a1026e6789c",
                "display" : "Epilepsy (disorder)"
              }
            ]
          },
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>No infos about Allergies</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/0dff4474-fa08-4f45-8260-dbb23094bf09c",
                "display" : "No infos about Allergies"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Ogivri\ttrastuzumab 150 mg\tpowder for concentrate for solution for infusion</li></ul><ul><li>Lipcut\tSimvastatin\t20 mg\ttablet</li></ul><ul><li>Enbrel Etanercept 25 mg powder for solution for injection</li></ul><ul><li>Tegretol Carbamazepine\t200 mg\ttablets</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a899c",
                "display" : "Ogivri\ttrastuzumab 150 mg\tpowder for concentrate for solution for infusion"
              },
              {
                "reference" : "MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f9c",
                "display" : "Lipcut\tSimvastatin\t20 mg tablet"
              },
              {
                "reference" : "MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b9c",
                "display" : "Enbrel Etanercept 25 mg powder for solution for injection"
              },
              {
                "reference" : "MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade94g9c",
                "display" : "Tegretol Carbamazepine\t200 mg\ttablets"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient c154158f-6a43-4ab7-8443-e7f4bf915dd9c</b></p><a name=\"c154158f-6a43-4ab7-8443-e7f4bf915dd9c\"> </a><a name=\"hcc154158f-6a43-4ab7-8443-e7f4bf915dd9c\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">IPS-JP Gravitate  Female, DoB: 1946-05-05 ( https://www.gravitatehealth.eu/sid/doc#ips-jp)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr></table></div>"
        },
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "ips-jp"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["IPS-JP"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1946-05-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d9c",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "1ece89c5-fda3-4db9-ace6-decbe6c603d9c",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d9c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 1ece89c5-fda3-4db9-ace6-decbe6c603d9c</b></p><a name=\"1ece89c5-fda3-4db9-ace6-decbe6c603d9c\"> </a><a name=\"hc1ece89c5-fda3-4db9-ace6-decbe6c603d9c\"> </a><p><b>name</b>: IPS JP </p></div>"
        },
        "name" : [
          {
            "family" : "JP",
            "given" : ["IPS"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/0dff4474-fa08-4f45-8260-dbb23094bf09c",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "0dff4474-fa08-4f45-8260-dbb23094bf09c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_0dff4474-fa08-4f45-8260-dbb23094bf09c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 0dff4474-fa08-4f45-8260-dbb23094bf09c</b></p><a name=\"0dff4474-fa08-4f45-8260-dbb23094bf09c\"> </a><a name=\"hc0dff4474-fa08-4f45-8260-dbb23094bf09c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-AllergyIntolerance-uv-ips.html\">AllergyIntolerance (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips no-allergy-info}\">no-allergy-info</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips",
              "code" : "no-allergy-info"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/bcc79261-142c-48ec-b032-f3f9af49ec59c",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "bcc79261-142c-48ec-b032-f3f9af49ec59c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_bcc79261-142c-48ec-b032-f3f9af49ec59c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition bcc79261-142c-48ec-b032-f3f9af49ec59c</b></p><a name=\"bcc79261-142c-48ec-b032-f3f9af49ec59c\"> </a><a name=\"hcbcc79261-142c-48ec-b032-f3f9af49ec59c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 254837009}\">Malignant neoplasm of breast</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>asserter</b>: <a href=\"Bundle-gravitate-ips-jp.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d9c\">Dr. IPS-JP</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "254837009",
              "display" : "Malignant neoplasm of breast (disorder)"
            }
          ],
          "text" : "Malignant neoplasm of breast"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d9c",
          "display" : "Dr. IPS-JP"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6259c",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "a4a9d90a-d1b0-4d60-82f0-c52343dc6259c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_a4a9d90a-d1b0-4d60-82f0-c52343dc6259c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition a4a9d90a-d1b0-4d60-82f0-c52343dc6259c</b></p><a name=\"a4a9d90a-d1b0-4d60-82f0-c52343dc6259c\"> </a><a name=\"hca4a9d90a-d1b0-4d60-82f0-c52343dc6259c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 69896004}\">Rheumatoid arthritis</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>onset</b>: 2015</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-ips-jp.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d9c\">Dr. IPS-JP</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "69896004",
              "display" : "Rheumatoid arthritis (disorder)"
            }
          ],
          "text" : "Rheumatoid arthritis"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d9c",
          "display" : "Dr. IPS-JP"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5139c",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "f06b7cf8-c15c-4288-a0f9-45a1026e5139c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_f06b7cf8-c15c-4288-a0f9-45a1026e5139c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition f06b7cf8-c15c-4288-a0f9-45a1026e5139c</b></p><a name=\"f06b7cf8-c15c-4288-a0f9-45a1026e5139c\"> </a><a name=\"hcf06b7cf8-c15c-4288-a0f9-45a1026e5139c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 13644009}\">Hypercholesterolemia</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "13644009",
              "display" : "Hypercholesterolemia (disorder)"
            }
          ],
          "text" : "Hypercholesterolemia"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/f06b7cf8-c15c-4288-a0f9-45a1026e6789c",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "f06b7cf8-c15c-4288-a0f9-45a1026e6789c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_f06b7cf8-c15c-4288-a0f9-45a1026e6789c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition f06b7cf8-c15c-4288-a0f9-45a1026e6789c</b></p><a name=\"f06b7cf8-c15c-4288-a0f9-45a1026e6789c\"> </a><a name=\"hcf06b7cf8-c15c-4288-a0f9-45a1026e6789c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 84757009}\">Epilepsy</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "84757009",
              "display" : "Epilepsy (disorder)"
            }
          ],
          "text" : "Epilepsy"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a899c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "29074ca4-efcb-4ff4-8446-feed2399a899c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_29074ca4-efcb-4ff4-8446-feed2399a899c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 29074ca4-efcb-4ff4-8446-feed2399a899c</b></p><a name=\"29074ca4-efcb-4ff4-8446-feed2399a899c\"> </a><a name=\"hc29074ca4-efcb-4ff4-8446-feed2399a899c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-jp.html#Medication_b50ae644-e0b7-4007-809f-26f493cbe369c\">trastuzumab</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>effective</b>: 2015</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20045000}\">Intravenous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/b50ae644-e0b7-4007-809f-26f493cbe369c",
          "display" : "trastuzumab"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "effectiveDateTime" : "2015",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20045000",
                  "display" : "Intravenous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f9c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f6cb1218-f81c-4338-80d8-3c10910f78f9c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f6cb1218-f81c-4338-80d8-3c10910f78f9c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f6cb1218-f81c-4338-80d8-3c10910f78f9c</b></p><a name=\"f6cb1218-f81c-4338-80d8-3c10910f78f9c\"> </a><a name=\"hcf6cb1218-f81c-4338-80d8-3c10910f78f9c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-jp.html#Medication_de131e15-ed13-4b31-b38c-3204a84d99c9c\">simvastatin</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>effective</b>: 2020</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/de131e15-ed13-4b31-b38c-3204a84d99c9c",
          "display" : "simvastatin"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "effectiveDateTime" : "2020",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b9c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f26084c9-b1c8-46d9-acb2-1d400ade87b9c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f26084c9-b1c8-46d9-acb2-1d400ade87b9c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f26084c9-b1c8-46d9-acb2-1d400ade87b9c</b></p><a name=\"f26084c9-b1c8-46d9-acb2-1d400ade87b9c\"> </a><a name=\"hcf26084c9-b1c8-46d9-acb2-1d400ade87b9c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-jp.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2ef19c\">enbrel</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>effective</b>: 2023</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20066000}\">Subcutaneous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2ef19c",
          "display" : "enbrel"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "effectiveDateTime" : "2023",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20066000",
                  "display" : "Subcutaneous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade94g9c",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f26084c9-b1c8-46d9-acb2-1d400ade94g9c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f26084c9-b1c8-46d9-acb2-1d400ade94g9c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f26084c9-b1c8-46d9-acb2-1d400ade94g9c</b></p><a name=\"f26084c9-b1c8-46d9-acb2-1d400ade94g9c\"> </a><a name=\"hcf26084c9-b1c8-46d9-acb2-1d400ade94g9c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-jp.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2jk99c\">carbamazepine</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-jp.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd9c\">IPS-JP</a></p><p><b>effective</b>: 2020</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2jk99c",
          "display" : "carbamazepine"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd9c",
          "display" : "IPS-JP"
        },
        "effectiveDateTime" : "2020",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/b50ae644-e0b7-4007-809f-26f493cbe369c",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "b50ae644-e0b7-4007-809f-26f493cbe369c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_b50ae644-e0b7-4007-809f-26f493cbe369c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication b50ae644-e0b7-4007-809f-26f493cbe369c</b></p><a name=\"b50ae644-e0b7-4007-809f-26f493cbe369c\"> </a><a name=\"hcb50ae644-e0b7-4007-809f-26f493cbe369c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{http://iyaku.info/medicine/ 4291447D2024}\">4291447D2024</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 50042000}\">Powder and solvent for concentrate for solution for infusion</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov P188ANX8CK}\">trastuzumab</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://iyaku.info/medicine/",
              "code" : "4291447D2024"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "50042000",
              "display" : "Powder and solvent for concentrate for solution for infusion"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "P188ANX8CK",
                  "display" : "trastuzumab"
                }
              ],
              "text" : "trastuzumab"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/de131e15-ed13-4b31-b38c-3204a84d99c9c",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "de131e15-ed13-4b31-b38c-3204a84d99c9c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_de131e15-ed13-4b31-b38c-3204a84d99c9c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication de131e15-ed13-4b31-b38c-3204a84d99c9c</b></p><a name=\"de131e15-ed13-4b31-b38c-3204a84d99c9c\"> </a><a name=\"hcde131e15-ed13-4b31-b38c-3204a84d99c9c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{http://iyaku.info/medicine/ 2189011F1262}, {https://www.who-umc.org/phpid F92168108C432D63DACDD70444176BB3}\">Lipcut\tSimvastatin\t5 mg\ttablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov AGG2FN16EV}\">SIMVASTATIN</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://iyaku.info/medicine/",
              "code" : "2189011F1262"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "F92168108C432D63DACDD70444176BB3",
              "display" : "Lipcut\tSimvastatin\t5 mg\ttablet"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "AGG2FN16EV",
                  "display" : "SIMVASTATIN"
                }
              ],
              "text" : "SIMVASTATIN"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2ef19c",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2ef19c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2ef19c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2ef19c</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2ef19c\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2ef19c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82716}\">Enbrel Etanercept\t25 mg powder for solution for injection</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 50041500}\">Powder and solution for solution for injection</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov OP401G7OJC}\">Enbrel Etanercept\t25 mg</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82716",
              "display" : "Enbrel Etanercept\t25 mg powder for solution for injection"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "50041500",
              "display" : "Powder and solution for solution for injection"
            }
          ],
          "text" : "Powder and solution for solution for injection"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "OP401G7OJC",
                  "display" : "ETANERCEPT (ENBREL)"
                }
              ],
              "text" : "Enbrel Etanercept\t25 mg"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2jk99c",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2jk99c",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2jk99c\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2jk99c</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2jk99c\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2jk99c\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{http://iyaku.info/medicine/ 1139002F1070}, {https://www.who-umc.org/phpid 5C62673C79E096D37914D32A45AA8F4D}, {https://www.who-umc.org/phpid FB9808F4FED210183F412F9998622287}\">Tegretol\tCarbamazepine\t200 mg\ttablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 33CM23913M}\">CARBAMAZEPINE</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://iyaku.info/medicine/",
              "code" : "1139002F1070"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "5C62673C79E096D37914D32A45AA8F4D",
              "display" : "Tegretol\tCarbamazepine\t200 mg\ttablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "FB9808F4FED210183F412F9998622287",
              "display" : "Tegretol\tCarbamazepine\t200 mg\ttablets"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "33CM23913M",
                  "display" : "CARBAMAZEPINE"
                }
              ],
              "text" : "CARBAMAZEPINE"
            }
          }
        ]
      }
    }
  ]
}

```
