# IPS Example 3 - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IPS Example 3**

## Example Bundle: IPS Example 3

**id:**gravitate-ips-3

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**ips-3

**Name:**IPS 3 example Gravitate

**active:**true

**gender:**female

**Birth Date:**1978-05-05

### Sections

#### Allergies and Intolerances

**Allergy:**Pollen (256259004)

**clinicalStatus:**active

**verificationStatus:**confirmed

**Reaction:**Allergic rhinitis caused by pollen (21719001)

#### Problem List

**Condition:**Psoriasis (9014002)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**Condition:**Congestive heart failure (42343007)

**clinicalStatus:**active

**asserter:**Dr. Anna Karlsson

**onsetDateTime:**2015

**Condition:**Hypertension (38341003)

**clinicalStatus:**active

**onsetDateTime:**1993

#### Medication Summary

**Medication:**Dimethyl fumarate 30 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/17/1201/001 [Skilarence]

*  **System** https://www.who-umc.org/phpid **Code:** 0x9982CA8A825D4561506CE808982E3B9D [dimethyl fumarate, 30 mg/ 1 tablet, Gastro-resistant tablet]

*  **System** http://www.whocc.no/atc **Code:** L04AX07 [dimethyl fumarate]

**Dose Form:**Gastro-resistant tablet

**Ingredient:**dimethyl fumarate (http://fdasis.nlm.nih.gov#FO2303MNI2)

**strength:**30 mg/1 Tablet

**Route:**Oral use

**Medication:**Irbesartan 75 mg Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EMEA/H/C/000142 [Karvea]

*  **System** https://www.who-umc.org/phpid **Code:** 0x8DFB446EDB3B8AE508AE493827A704E4 [Irbesartan, 75 mg/ 1 tablet, Tablet]

*  **System** http://www.whocc.no/atc **Code:** C09DA04 [irbesartan and diuretics]

**Dose Form:**Tablet

**Ingredient:**irbesartan (http://fdasis.nlm.nih.gov#J0E2756Z7N)

**strength:**75 mg/1 Tablet

**Route:**Oral use

**Medication:**Oxymetazoline hydrochloride 0.05 mg / 1 ml Spray

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/man **Code:** 16028/0049 [Boots Decongestant 0.05% w/v Nasal spray]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82716 [Oxymetazoline hydrochloride, 0.5 mg/ 1 ml, Nasal spray, solution]

*  **System** http://www.whocc.no/atc **Code:** R01AA05 [oxymetazoline]

**Dose Form:**

**Ingredient:**oxymetazoline hydrochloride (http://fdasis.nlm.nih.gov#K89MJ0S5VY)

**strength:**0.05 mg/1 ml

**Route:**Nasal use

#### Pregnancy History



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-ips-3",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "ips-3"
  },
  "type" : "document",
  "timestamp" : "2021-09-03T08:38:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/2fa5b223-ebce-4f39-9c66-5dc014f73571",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "ips-example-3",
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_ips-example-3\"> </a>\n  \n\n    \n      <b>Id:</b>\n      ips-example-3\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>Example 1 Gravitate</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Hay fever (pollen)\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Psoriasis\n\n            </li>\n          \n\n            <li>\n\n              Hypertension\n\n            </li>\n          \n\n            <li>\n\n              Congestive heart failure\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Dimethyl fumarate 30 mg Gastro-resistant tablet\n\n            </li>\n          \n\n            <li>\n\n              Irbesartan 75 mg Tablet\n\n            </li>\n          \n\n            <li>\n\n              Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray\n\n            </li>\n          \n\n            <li>\n\n              valproic acid\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Pregnancy History\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Pregrancy Status\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Example 1 Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d1",
            "display" : "Dr. Anna Karlsson"
          }
        ],
        "title" : "Patient Summary (Maria Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf01",
                "display" : "Hay fever (pollen)"
              }
            ]
          },
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/bcc79261-142c-48ec-b032-f3f9af49ec51",
                "display" : "Psoriasis"
              },
              {
                "reference" : "Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5131",
                "display" : "Hypertension"
              },
              {
                "reference" : "Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6251",
                "display" : "Congestive heart failure"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a891",
                "display" : "Dimethyl fumarate 30 mg Gastro-resistant tablet"
              },
              {
                "reference" : "MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f1",
                "display" : "Irbesartan 75 mg Tablet"
              },
              {
                "reference" : "MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b1",
                "display" : "Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray"
              },
              {
                "reference" : "Medication/5d129355-4b20-40d8-841f-7f93acbc3e61",
                "display" : "valproic acid"
              }
            ]
          },
          {
            "title" : "Pregnancy History",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10162-6",
                  "display" : "Pregnancies Hx"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Observation/e06e43a1-38d4-468f-8c35-f7f12da91061",
                "display" : "Pregrancy Status"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "c154158f-6a43-4ab7-8443-e7f4bf915dd1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient c154158f-6a43-4ab7-8443-e7f4bf915dd1</b></p><a name=\"c154158f-6a43-4ab7-8443-e7f4bf915dd1\"> </a><a name=\"hcc154158f-6a43-4ab7-8443-e7f4bf915dd1\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">IPS 3 example Gravitate  Female, DoB: 1978-05-05 ( https://www.gravitatehealth.eu/sid/doc#ips-3)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 NO}\">Norway</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "NO",
                      "display" : "Norway"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "ips-3"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["IPS 3 example"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1978-05-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d1",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "1ece89c5-fda3-4db9-ace6-decbe6c603d1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d1\"> </a>Dr. Anne Karlsson</div>"
        },
        "name" : [
          {
            "family" : "Karlsson",
            "given" : ["Anne"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/1dff4474-fa08-4f45-8260-dbb23094bf01",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "1dff4474-fa08-4f45-8260-dbb23094bf01",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_1dff4474-fa08-4f45-8260-dbb23094bf01\"> </a>Hay fever</div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "256259004",
              "display" : "Pollen"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Maria Gravitate"
        },
        "reaction" : [
          {
            "manifestation" : [
              {
                "coding" : [
                  {
                    "system" : "http://snomed.info/sct",
                    "code" : "21719001",
                    "display" : "Allergic rhinitis caused by pollen"
                  }
                ],
                "text" : "Hay fever"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/bcc79261-142c-48ec-b032-f3f9af49ec51",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "bcc79261-142c-48ec-b032-f3f9af49ec51",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_bcc79261-142c-48ec-b032-f3f9af49ec51\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition bcc79261-142c-48ec-b032-f3f9af49ec51</b></p><a name=\"bcc79261-142c-48ec-b032-f3f9af49ec51\"> </a><a name=\"hcbcc79261-142c-48ec-b032-f3f9af49ec51\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 9014002}\">Psoriasis</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-3.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd1\">Maria Gravitate</a></p><p><b>asserter</b>: <a href=\"Bundle-gravitate-ips-3.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d1\">Dr. Anna Karlsson</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "9014002",
              "display" : "Psoriasis"
            }
          ],
          "text" : "Psoriasis"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Maria Gravitate"
        },
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d1",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6251",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "a4a9d90a-d1b0-4d60-82f0-c52343dc6251",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_a4a9d90a-d1b0-4d60-82f0-c52343dc6251\"> </a>Congestive heart failure (2015)</div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "42343007",
              "display" : "Congestive heart failure"
            }
          ],
          "text" : "Congestive heart failure"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Maria Gravitate"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d1",
          "display" : "Dr. Anna Karlsson"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5131",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "f06b7cf8-c15c-4288-a0f9-45a1026e5131",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_f06b7cf8-c15c-4288-a0f9-45a1026e5131\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition f06b7cf8-c15c-4288-a0f9-45a1026e5131</b></p><a name=\"f06b7cf8-c15c-4288-a0f9-45a1026e5131\"> </a><a name=\"hcf06b7cf8-c15c-4288-a0f9-45a1026e5131\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 38341003}\">Hypertension</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-3.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd1\">Maria Gravitate</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "38341003",
              "display" : "HT - Hypertension"
            }
          ],
          "text" : "Hypertension"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Maria Gravitate"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a891",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "29074ca4-efcb-4ff4-8446-feed2399a891",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_29074ca4-efcb-4ff4-8446-feed2399a891\"> </a><table><thead><tr><th>Brand Name</th><th>MAN</th><th>Active Substance</th><th>Common Name</th><th>ATC</th><th>Strength</th><th>Dose Form</th><th>RoA</th></tr></thead><tbody><tr><td>Skilarence</td><td>EU/1/17/1201/001</td><td>dimethyl fumarate (FO2303MNI2)</td><td>dimethyl fumarate</td><td>L04AX07</td><td>30 mg</td><td>Gastro-resistant tablet</td><td>Oral use</td></tr></tbody></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/b50ae644-e0b7-4007-809f-26f493cbe361",
          "display" : "Dimethyl fumarate 30 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Maria Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f6cb1218-f81c-4338-80d8-3c10910f78f1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f6cb1218-f81c-4338-80d8-3c10910f78f1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f6cb1218-f81c-4338-80d8-3c10910f78f1</b></p><a name=\"f6cb1218-f81c-4338-80d8-3c10910f78f1\"> </a><a name=\"hcf6cb1218-f81c-4338-80d8-3c10910f78f1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-3.html#Medication_de131e15-ed13-4b31-b38c-3204a84d99c1\">Irbesartan 75 mg Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-3.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd1\">Maria Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/de131e15-ed13-4b31-b38c-3204a84d99c1",
          "display" : "Irbesartan 75 mg Tablet"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Maria Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f26084c9-b1c8-46d9-acb2-1d400ade87b1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f26084c9-b1c8-46d9-acb2-1d400ade87b1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f26084c9-b1c8-46d9-acb2-1d400ade87b1</b></p><a name=\"f26084c9-b1c8-46d9-acb2-1d400ade87b1\"> </a><a name=\"hcf26084c9-b1c8-46d9-acb2-1d400ade87b1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-3.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2ef11\">Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-3.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd1\">Maria Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20049000}\">Nasal use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2ef11",
          "display" : "Oxymetazoline hydrochloride  0.05 mg / 1 ml Spray"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1",
          "display" : "Maria Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20049000",
                  "display" : "Nasal use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/b50ae644-e0b7-4007-809f-26f493cbe361",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "b50ae644-e0b7-4007-809f-26f493cbe361",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_b50ae644-e0b7-4007-809f-26f493cbe361\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication b50ae644-e0b7-4007-809f-26f493cbe361</b></p><a name=\"b50ae644-e0b7-4007-809f-26f493cbe361\"> </a><a name=\"hcb50ae644-e0b7-4007-809f-26f493cbe361\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/17/1201/001}, {https://www.who-umc.org/phpid 0x9982CA8A825D4561506CE808982E3B9D}, {http://www.whocc.no/atc L04AX07}\">Skilarence</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10225000}\">Gastro-resistant tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov FO2303MNI2}\">dimethyl fumarate</span></td><td>30 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/17/1201/001",
              "display" : "Skilarence"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x9982CA8A825D4561506CE808982E3B9D",
              "display" : "dimethyl fumarate, 30 mg/ 1 tablet, Gastro-resistant tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L04AX07",
              "display" : "dimethyl fumarate"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10225000",
              "display" : "Gastro-resistant tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "FO2303MNI2",
                  "display" : "dimethyl fumarate"
                }
              ],
              "text" : "dimethyl fumarate"
            },
            "strength" : {
              "numerator" : {
                "value" : 30,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/de131e15-ed13-4b31-b38c-3204a84d99c1",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "de131e15-ed13-4b31-b38c-3204a84d99c1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_de131e15-ed13-4b31-b38c-3204a84d99c1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication de131e15-ed13-4b31-b38c-3204a84d99c1</b></p><a name=\"de131e15-ed13-4b31-b38c-3204a84d99c1\"> </a><a name=\"hcde131e15-ed13-4b31-b38c-3204a84d99c1\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EMEA/H/C/000142}, {https://www.who-umc.org/phpid 0x8DFB446EDB3B8AE508AE493827A704E4}, {http://www.whocc.no/atc C09DA04}\">Karvea</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov J0E2756Z7N}\">irbesartan</span></td><td>75 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EMEA/H/C/000142",
              "display" : "Karvea"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x8DFB446EDB3B8AE508AE493827A704E4",
              "display" : "Irbesartan, 75 mg/ 1 tablet, Tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "C09DA04",
              "display" : "irbesartan and diuretics"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "J0E2756Z7N",
                  "display" : "irbesartan"
                }
              ],
              "text" : "irbesartan"
            },
            "strength" : {
              "numerator" : {
                "value" : 75,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2ef11",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2ef11",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2ef11\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2ef11</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2ef11\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2ef11\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/man 16028/0049}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82716}, {http://www.whocc.no/atc R01AA05}\">Boots Decongestant 0.05% w/v Nasal spray</span></p><p><b>form</b>: <span title=\"Codes:\">Nasal spray, solution</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov K89MJ0S5VY}\">oxymetazoline hydrochloride</span></td><td>0.05 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 ml<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/man",
              "code" : "16028/0049",
              "display" : "Boots Decongestant 0.05% w/v Nasal spray"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82716",
              "display" : "Oxymetazoline hydrochloride, 0.5 mg/ 1 ml, Nasal spray, solution"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "R01AA05",
              "display" : "oxymetazoline"
            }
          ]
        },
        "form" : {
          "text" : "Nasal spray, solution"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "K89MJ0S5VY",
                  "display" : "oxymetazoline hydrochloride"
                }
              ],
              "text" : "oxymetazoline hydrochloride"
            },
            "strength" : {
              "numerator" : {
                "value" : 0.05,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "ml",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/5d129355-4b20-40d8-841f-7f93acbc3e61",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "5d129355-4b20-40d8-841f-7f93acbc3e61",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_5d129355-4b20-40d8-841f-7f93acbc3e61\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 5d129355-4b20-40d8-841f-7f93acbc3e61</b></p><a name=\"5d129355-4b20-40d8-841f-7f93acbc3e61\"> </a><a name=\"hc5d129355-4b20-40d8-841f-7f93acbc3e61\"> </a><p><b>code</b>: <span title=\"Codes:{http://www.whocc.no/atc N03AG01}\">valproic acid</span></p><p><b>form</b>: <span title=\"Codes:\">Nasal spray, solution</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov K89MJ0S5VY}\">oxymetazoline hydrochloride</span></td><td>0.05 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 ml<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N03AG01",
              "display" : "valproic acid"
            }
          ]
        },
        "form" : {
          "text" : "Nasal spray, solution"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "K89MJ0S5VY",
                  "display" : "oxymetazoline hydrochloride"
                }
              ],
              "text" : "oxymetazoline hydrochloride"
            },
            "strength" : {
              "numerator" : {
                "value" : 0.05,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "ml",
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Observation/e06e43a1-38d4-468f-8c35-f7f12da91061",
      "resource" : {
        "resourceType" : "Observation",
        "id" : "e06e43a1-38d4-468f-8c35-f7f12da91061",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Observation_e06e43a1-38d4-468f-8c35-f7f12da91061\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Observation e06e43a1-38d4-468f-8c35-f7f12da91061</b></p><a name=\"e06e43a1-38d4-468f-8c35-f7f12da91061\"> </a><a name=\"hce06e43a1-38d4-468f-8c35-f7f12da91061\"> </a><p><b>status</b>: Final</p><p><b>code</b>: <span title=\"Codes:{http://loinc.org 82810-3}\">Pregnancy status</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-3.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd1\">IPS 3 example Gravitate  Female, DoB: 1978-05-05 ( https://www.gravitatehealth.eu/sid/doc#ips-3)</a></p><p><b>effective</b>: 2020-01-10</p><p><b>value</b>: <span title=\"Codes:{http://loinc.org LA15173-0}\">Pregnant</span></p></div>"
        },
        "status" : "final",
        "code" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "82810-3",
              "display" : "Pregnancy status"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd1"
        },
        "effectiveDateTime" : "2020-01-10",
        "valueCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "LA15173-0",
              "display" : "Pregnant"
            }
          ]
        }
      }
    }
  ]
}

```
