# IPS Example 2 - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **IPS Example 2**

## Example Bundle: IPS Example 2

**id:**gravitate-ips-2

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**ips-2

**Name:**IPS-2 Gravitate

**active:**true

**gender:**female

**Birth Date:**1946-05-05

### Sections

#### Problem List

**Condition:**Malignant neoplasm of breast (254837009)

**clinicalStatus:**active

**asserter:**Dr. IPS2

**Condition:**Rheumatoid arthritis (69896004)

**clinicalStatus:**active

**asserter:**Dr. IPS2

**onsetDateTime:**2015

**Condition:**Hypercholesterolemia (13644009)

**clinicalStatus:**active

**onsetDateTime:**1993

**Condition:**Epilepsy (84757009)

**clinicalStatus:**active

**onsetDateTime:**1993

#### Allergies and Intolerances

**Allergy:**(no-allergy-info)

**clinicalStatus:**active

**verificationStatus:**confirmed

#### Medication Summary

**Medication:**trastuzumab

**status:**active

**Medication Detail:**

*  **System** http://example.org/mpid/no **Code:** 4249 [trastuzumab]

**Dose Form:**Powder and solvent for concentrate for solution for infusion

**Ingredient:**trastuzumab (http://fdasis.nlm.nih.gov#P188ANX8CK)

**Route:**Intravenous use

**Medication:**simvastatin

**status:**active

**Medication Detail:**

*  **System** https://www.who-umc.org/phpid **Code:** F92168108C432D63DACDD70444176BB3 [Lipcut Simvastatin 20 mg tablet]

**Dose Form:**Tablet

**Ingredient:**SIMVASTATIN (http://fdasis.nlm.nih.gov#AGG2FN16EV)

**Route:**Oral use

**Medication:**enbrel

**status:**active

**Medication Detail:**

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82716 [Enbrel Etanercept 25 mg powder for solution for injection]

**Dose Form:**Powder and solution for solution for injection

**Ingredient:**ETANERCEPT (ENBREL) (http://fdasis.nlm.nih.gov#OP401G7OJC)

**Route:**Subcutaneous use

**Medication:**carbamazepine

**status:**active

**Medication Detail:**

*  **System** https://www.who-umc.org/phpid **Code:** 5C62673C79E096D37914D32A45AA8F4D [Tegretol Carbamazepine 200 mg tablets]

*  **System** https://www.who-umc.org/phpid **Code:** FB9808F4FED210183F412F9998622287 [Tegretol Carbamazepine 200 mg tablets]

**Dose Form:**Tablet

**Ingredient:**CARBAMAZEPINE (http://fdasis.nlm.nih.gov#33CM23913M)

**Route:**Oral use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-ips-2",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "ips-2"
  },
  "type" : "document",
  "timestamp" : "2021-09-03T08:38:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/2fa5b223-ebce-4f39-9c66-5dc014f73573",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "ips-example-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips"
          ]
        },
        "text" : {
          "status" : "extensions",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_ips-example-2\"> </a>\n  \n\n    \n      <b>Id:</b>\n      ips-example-2\n    <br/>\n    \n      <b>status:</b>\n      Final\n    <br/>\n    \n      <b>Type:</b>\n      Patient summary Document\n    <br/>\n    \n      <b>Subject:</b>\n      <a>IPS-2</a>\n    \n\n    <br/>\n    <b>Sections:</b>\n    <br/>\n\n    <ul>\n      \n        <li>\n\n          Problem List\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Malignant neoplasm of breast (disorder)\n\n            </li>\n          \n\n            <li>\n\n              Hypercholesterolemia\n\n            </li>\n          \n\n            <li>\n\n              Rheumatoid arthritis\n\n            </li>\n          \n\n            <li>\n\n              Epilepsy (disorder)\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Allergies and Intolerances\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              No infos about Allergies\n\n            </li>\n          \n        </ul>\n\n      \n        <li>\n\n          Medication Summary\n\n        </li>\n        <ul>\n\n          \n\n            <li>\n\n              Ogivri\ttrastuzumab 150 mg\tpowder for concentrate for solution for infusion\n\n            </li>\n          \n\n            <li>\n\n              Lipcut\tSimvastatin\t5 mg tablet\n\n            </li>\n          \n\n            <li>\n\n              Enbrel Etanercept 25 mg powder for solution for injection\n\n            </li>\n          \n\n            <li>\n\n              Tegretol Carbamazepine\t200 mg\ttablets\n\n            </li>\n          \n        </ul>\n\n      \n\n    </ul>\n\n  \n\n</div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d3",
            "display" : "Dr. Number2"
          }
        ],
        "title" : "Patient Summary (IPS2)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Malignant neoplasm of breast (disorder)</li></ul><ul><li>Hypercholesterolemia</li></ul><ul><li>Rheumatoid arthritis</li></ul><ul><li>Epilepsy</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "Condition/bcc79261-142c-48ec-b032-f3f9af49ec53",
                "display" : "Malignant neoplasm of breast (disorder)"
              },
              {
                "reference" : "Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5133",
                "display" : "Hypercholesterolemia"
              },
              {
                "reference" : "Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6253",
                "display" : "Rheumatoid arthritis"
              },
              {
                "reference" : "Condition/f06b7cf8-c15c-4288-a0f9-45a1026e6788",
                "display" : "Epilepsy (disorder)"
              }
            ]
          },
          {
            "title" : "Allergies and Intolerances",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "48765-2",
                  "display" : "Allergies and adverse reactions Document"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>No infos about Allergies</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "AllergyIntolerance/0dff4474-fa08-4f45-8260-dbb23094bf07",
                "display" : "No infos about Allergies"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "generated",
              "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><ul><li>Ogivri\ttrastuzumab 150 mg\tpowder for concentrate for solution for infusion</li></ul><ul><li>Lipcut\tSimvastatin\t5 mg\ttablet</li></ul><ul><li>Enbrel Etanercept 25 mg powder for solution for injection</li></ul><ul><li>Tegretol Carbamazepine\t200 mg\ttablets</li></ul></div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a893",
                "display" : "Ogivri\ttrastuzumab 150 mg\tpowder for concentrate for solution for infusion"
              },
              {
                "reference" : "MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f3",
                "display" : "Lipcut\tSimvastatin\t5 mg tablet"
              },
              {
                "reference" : "MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b3",
                "display" : "Enbrel Etanercept 25 mg powder for solution for injection"
              },
              {
                "reference" : "MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade94gy",
                "display" : "Tegretol Carbamazepine\t200 mg\ttablets"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "c154158f-6a43-4ab7-8443-e7f4bf915dd3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient c154158f-6a43-4ab7-8443-e7f4bf915dd3</b></p><a name=\"c154158f-6a43-4ab7-8443-e7f4bf915dd3\"> </a><a name=\"hcc154158f-6a43-4ab7-8443-e7f4bf915dd3\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">IPS-2 Gravitate  Female, DoB: 1946-05-05 ( https://www.gravitatehealth.eu/sid/doc#ips-2)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Patient Links\">Links:</td><td colspan=\"3\"><ul><li>General Practitioner: <a href=\"Bundle-gravitate-ips-2.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d3\">Practitioner IPS 2 </a></li></ul></td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 NO}\">Norway</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "NO",
                      "display" : "Norway"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "ips-2"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["IPS-2"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1946-05-05",
        "generalPractitioner" : [
          {
            "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d3"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d3",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "1ece89c5-fda3-4db9-ace6-decbe6c603d3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner 1ece89c5-fda3-4db9-ace6-decbe6c603d3</b></p><a name=\"1ece89c5-fda3-4db9-ace6-decbe6c603d3\"> </a><a name=\"hc1ece89c5-fda3-4db9-ace6-decbe6c603d3\"> </a><p><b>name</b>: IPS 2 </p><p><b>telecom</b>: <a href=\"mailto:example@example.org\">example@example.org</a></p></div>"
        },
        "name" : [
          {
            "family" : "2",
            "given" : ["IPS"],
            "prefix" : ["Dr."]
          }
        ],
        "telecom" : [
          {
            "system" : "email",
            "value" : "example@example.org"
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/AllergyIntolerance/0dff4474-fa08-4f45-8260-dbb23094bf07",
      "resource" : {
        "resourceType" : "AllergyIntolerance",
        "id" : "0dff4474-fa08-4f45-8260-dbb23094bf07",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/AllergyIntolerance-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"AllergyIntolerance_0dff4474-fa08-4f45-8260-dbb23094bf07\"> </a><p class=\"res-header-id\"><b>Generated Narrative: AllergyIntolerance 0dff4474-fa08-4f45-8260-dbb23094bf07</b></p><a name=\"0dff4474-fa08-4f45-8260-dbb23094bf07\"> </a><a name=\"hc0dff4474-fa08-4f45-8260-dbb23094bf07\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-AllergyIntolerance-uv-ips.html\">AllergyIntolerance (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/allergyintolerance-verification confirmed}\">Confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips no-allergy-info}\">no-allergy-info</span></p><p><b>patient</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://hl7.org/fhir/uv/ips/CodeSystem/absent-unknown-uv-ips",
              "code" : "no-allergy-info"
            }
          ]
        },
        "patient" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/bcc79261-142c-48ec-b032-f3f9af49ec53",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "bcc79261-142c-48ec-b032-f3f9af49ec53",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_bcc79261-142c-48ec-b032-f3f9af49ec53\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition bcc79261-142c-48ec-b032-f3f9af49ec53</b></p><a name=\"bcc79261-142c-48ec-b032-f3f9af49ec53\"> </a><a name=\"hcbcc79261-142c-48ec-b032-f3f9af49ec53\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 254837009}\">Malignant neoplasm of breast</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>asserter</b>: <a href=\"Bundle-gravitate-ips-2.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d3\">Dr. IPS2</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "254837009",
              "display" : "Malignant neoplasm of breast (disorder)"
            }
          ],
          "text" : "Malignant neoplasm of breast"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d3",
          "display" : "Dr. IPS2"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/a4a9d90a-d1b0-4d60-82f0-c52343dc6253",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "a4a9d90a-d1b0-4d60-82f0-c52343dc6253",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_a4a9d90a-d1b0-4d60-82f0-c52343dc6253\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition a4a9d90a-d1b0-4d60-82f0-c52343dc6253</b></p><a name=\"a4a9d90a-d1b0-4d60-82f0-c52343dc6253\"> </a><a name=\"hca4a9d90a-d1b0-4d60-82f0-c52343dc6253\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 69896004}\">Rheumatoid arthritis</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>onset</b>: 2015</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-ips-2.html#Practitioner_1ece89c5-fda3-4db9-ace6-decbe6c603d3\">Dr. IPS2</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "69896004",
              "display" : "Rheumatoid arthritis (disorder)"
            }
          ],
          "text" : "Rheumatoid arthritis"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/1ece89c5-fda3-4db9-ace6-decbe6c603d3",
          "display" : "Dr. IPS2"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/f06b7cf8-c15c-4288-a0f9-45a1026e5133",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "f06b7cf8-c15c-4288-a0f9-45a1026e5133",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_f06b7cf8-c15c-4288-a0f9-45a1026e5133\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition f06b7cf8-c15c-4288-a0f9-45a1026e5133</b></p><a name=\"f06b7cf8-c15c-4288-a0f9-45a1026e5133\"> </a><a name=\"hcf06b7cf8-c15c-4288-a0f9-45a1026e5133\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 13644009}\">Hypercholesterolemia</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "13644009",
              "display" : "Hypercholesterolemia (disorder)"
            }
          ],
          "text" : "Hypercholesterolemia"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/f06b7cf8-c15c-4288-a0f9-45a1026e6788",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "f06b7cf8-c15c-4288-a0f9-45a1026e6788",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_f06b7cf8-c15c-4288-a0f9-45a1026e6788\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition f06b7cf8-c15c-4288-a0f9-45a1026e6788</b></p><a name=\"f06b7cf8-c15c-4288-a0f9-45a1026e6788\"> </a><a name=\"hcf06b7cf8-c15c-4288-a0f9-45a1026e6788\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 84757009}\">Epilepsy</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>onset</b>: 1993</p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "84757009",
              "display" : "Epilepsy (disorder)"
            }
          ],
          "text" : "Epilepsy"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "onsetDateTime" : "1993"
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/29074ca4-efcb-4ff4-8446-feed2399a893",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "29074ca4-efcb-4ff4-8446-feed2399a893",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_29074ca4-efcb-4ff4-8446-feed2399a893\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement 29074ca4-efcb-4ff4-8446-feed2399a893</b></p><a name=\"29074ca4-efcb-4ff4-8446-feed2399a893\"> </a><a name=\"hc29074ca4-efcb-4ff4-8446-feed2399a893\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-2.html#Medication_b50ae644-e0b7-4007-809f-26f493cbe363\">trastuzumab</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>effective</b>: 2015</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20045000}\">Intravenous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/b50ae644-e0b7-4007-809f-26f493cbe363",
          "display" : "trastuzumab"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "effectiveDateTime" : "2015",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20045000",
                  "display" : "Intravenous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f6cb1218-f81c-4338-80d8-3c10910f78f3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f6cb1218-f81c-4338-80d8-3c10910f78f3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f6cb1218-f81c-4338-80d8-3c10910f78f3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f6cb1218-f81c-4338-80d8-3c10910f78f3</b></p><a name=\"f6cb1218-f81c-4338-80d8-3c10910f78f3\"> </a><a name=\"hcf6cb1218-f81c-4338-80d8-3c10910f78f3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-2.html#Medication_de131e15-ed13-4b31-b38c-3204a84d99c3\">simvastatin</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>effective</b>: 2020</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/de131e15-ed13-4b31-b38c-3204a84d99c3",
          "display" : "simvastatin"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "effectiveDateTime" : "2020",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade87b3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f26084c9-b1c8-46d9-acb2-1d400ade87b3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f26084c9-b1c8-46d9-acb2-1d400ade87b3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f26084c9-b1c8-46d9-acb2-1d400ade87b3</b></p><a name=\"f26084c9-b1c8-46d9-acb2-1d400ade87b3\"> </a><a name=\"hcf26084c9-b1c8-46d9-acb2-1d400ade87b3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-2.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2ef13\">enbrel</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>effective</b>: 2023</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20066000}\">Subcutaneous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2ef13",
          "display" : "enbrel"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "effectiveDateTime" : "2023",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20066000",
                  "display" : "Subcutaneous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/f26084c9-b1c8-46d9-acb2-1d400ade94gy",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "f26084c9-b1c8-46d9-acb2-1d400ade94gy",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/MedicationStatement-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_f26084c9-b1c8-46d9-acb2-1d400ade94gy\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement f26084c9-b1c8-46d9-acb2-1d400ade94gy</b></p><a name=\"f26084c9-b1c8-46d9-acb2-1d400ade94gy\"> </a><a name=\"hcf26084c9-b1c8-46d9-acb2-1d400ade94gy\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-MedicationStatement-uv-ips.html\">MedicationStatement (IPS)</a></p></div><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-ips-2.html#Medication_9ac3356c-4ea4-4814-84c3-235484f2jk90\">carbamazepine</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-ips-2.html#Patient_c154158f-6a43-4ab7-8443-e7f4bf915dd3\">IPS-2</a></p><p><b>effective</b>: 2020</p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9ac3356c-4ea4-4814-84c3-235484f2jk90",
          "display" : "carbamazepine"
        },
        "subject" : {
          "reference" : "Patient/c154158f-6a43-4ab7-8443-e7f4bf915dd3",
          "display" : "IPS-2"
        },
        "effectiveDateTime" : "2020",
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/b50ae644-e0b7-4007-809f-26f493cbe363",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "b50ae644-e0b7-4007-809f-26f493cbe363",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_b50ae644-e0b7-4007-809f-26f493cbe363\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication b50ae644-e0b7-4007-809f-26f493cbe363</b></p><a name=\"b50ae644-e0b7-4007-809f-26f493cbe363\"> </a><a name=\"hcb50ae644-e0b7-4007-809f-26f493cbe363\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{http://example.org/mpid/no 4249}\">trastuzumab</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 50042000}\">Powder and solvent for concentrate for solution for infusion</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov P188ANX8CK}\">trastuzumab</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://example.org/mpid/no",
              "code" : "4249",
              "display" : "trastuzumab"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "50042000",
              "display" : "Powder and solvent for concentrate for solution for infusion"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "P188ANX8CK",
                  "display" : "trastuzumab"
                }
              ],
              "text" : "trastuzumab"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/de131e15-ed13-4b31-b38c-3204a84d99c3",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "de131e15-ed13-4b31-b38c-3204a84d99c3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_de131e15-ed13-4b31-b38c-3204a84d99c3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication de131e15-ed13-4b31-b38c-3204a84d99c3</b></p><a name=\"de131e15-ed13-4b31-b38c-3204a84d99c3\"> </a><a name=\"hcde131e15-ed13-4b31-b38c-3204a84d99c3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{https://www.who-umc.org/phpid F92168108C432D63DACDD70444176BB3}\">Lipcut\tSimvastatin\t20 mg\ttablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov AGG2FN16EV}\">SIMVASTATIN</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "F92168108C432D63DACDD70444176BB3",
              "display" : "Lipcut\tSimvastatin\t20 mg\ttablet"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "AGG2FN16EV",
                  "display" : "SIMVASTATIN"
                }
              ],
              "text" : "SIMVASTATIN"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2ef13",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2ef13",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2ef13\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2ef13</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2ef13\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2ef13\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82716}\">Enbrel Etanercept\t25 mg powder for solution for injection</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 50041500}\">Powder and solution for solution for injection</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov OP401G7OJC}\">Enbrel Etanercept\t25 mg</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82716",
              "display" : "Enbrel Etanercept\t25 mg powder for solution for injection"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "50041500",
              "display" : "Powder and solution for solution for injection"
            }
          ],
          "text" : "Powder and solution for solution for injection"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "OP401G7OJC",
                  "display" : "ETANERCEPT (ENBREL)"
                }
              ],
              "text" : "Enbrel Etanercept\t25 mg"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9ac3356c-4ea4-4814-84c3-235484f2jk90",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9ac3356c-4ea4-4814-84c3-235484f2jk90",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Medication-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9ac3356c-4ea4-4814-84c3-235484f2jk90\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9ac3356c-4ea4-4814-84c3-235484f2jk90</b></p><a name=\"9ac3356c-4ea4-4814-84c3-235484f2jk90\"> </a><a name=\"hc9ac3356c-4ea4-4814-84c3-235484f2jk90\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Medication-uv-ips.html\">Medication (IPS)</a></p></div><p><b>code</b>: <span title=\"Codes:{https://www.who-umc.org/phpid 5C62673C79E096D37914D32A45AA8F4D}, {https://www.who-umc.org/phpid FB9808F4FED210183F412F9998622287}\">Tegretol Carbamazepine 200 mg tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 33CM23913M}\">CARBAMAZEPINE</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "5C62673C79E096D37914D32A45AA8F4D",
              "display" : "Tegretol Carbamazepine 200 mg tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "FB9808F4FED210183F412F9998622287",
              "display" : "Tegretol Carbamazepine 200 mg tablets"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "33CM23913M",
                  "display" : "CARBAMAZEPINE"
                }
              ],
              "text" : "CARBAMAZEPINE"
            }
          }
        ]
      }
    }
  ]
}

```
