# Alex Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Alex Gravitate's IPS**

## Example Bundle: Alex Gravitate's IPS

**id:**gravitate-alex-himss

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**Alex-1

**Name:**Alex Gravitate

**active:**true

**gender:**male

**Birth Date:**1975-10-05

### Sections

#### Problem List

**Condition:**Metabolic syndrome X (237602007)

**clinicalStatus:**active

**Condition:**Primary carcinoma of prostate (1259388006)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

**Condition:**Diabetes mellitus type 2 (disorder) (44054006)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

**Condition:**Overweight (238131007)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

#### Medication Summary

**Medication:**Metformin 500 mg PO with the two largest meals → slowly titrate to 1 g BID

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-metformin [Metformin 500 mg tablets]

*  **System** https://spor.ema.europa.eu/pmswi **Code:** himss-6 [Metformin 500 mg]

**Dose Form:**Tablet

**Ingredient:**metformin (http://fdasis.nlm.nih.gov#9100L32L2N)

**strength:**500 mg/1 Tablet

**Route:**Oral use

**Medication:**Atorvastatin 40 mg PO nightly

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-Atorvastatin [Atorvastatin 40 mg]

*  **System** https://spor.ema.europa.eu/pmswi **Code:** himss-7 [Atorvastatin 40 mg]

**Dose Form:**Coated tablet

**Ingredient:**FOLIC ACID (http://fdasis.nlm.nih.gov#935E97BOY8)

**strength:**40 mg/1 Tablet

**Route:**Oral use

**Medication:**Semaglutide 2.4 mg SC once weekly

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-semaglutide [Semaglutide 2.4 mg]

*  **System** https://spor.ema.europa.eu/pmswi **Code:** himss-9 [Semaglutide 2.4 mg ]

**Dose Form:**Effervescent tablet

**Ingredient:**Calcium carbonate (http://fdasis.nlm.nih.gov#H0G9379FGK)

**strength:**2.4 mg/1 Dose

**Route:**Oral use

**Medication:**Finasteride 5 mg PO daily

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-finasteride [Finasteride 5 mg]

*  **System** https://spor.ema.europa.eu/pmswi **Code:** himss-10 [Finasteride 5 mg]

**Dose Form:**Effervescent tablet

**Ingredient:**Calcium carbonate (http://fdasis.nlm.nih.gov#H0G9379FGK)

**strength:**5 mg/1 Tablet

**Route:**Oral use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-alex-himss",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "Alex-ips-1"
  },
  "type" : "document",
  "timestamp" : "2025-06-04T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/Alex-comp",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-Alex",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-Alex\"> </a><b>Id:</b> gravitate-Alex<br/><b>status:</b> final<br/><b>Type:</b> Patient summary Document<br/><b>Subject:</b> Alex Gravitate<br/><b>Sections:</b><br/><ul><li><b>Title:</b> Problem List<br/><b>Code:</b> Problem list Reported (11450-4)</li><br/><ul><li><b>Entry:</b> <a href=\"Condition-Alex-cond-1.html\">HIV</a></li><br/><li><b>Entry:</b> <a href=\"Condition-Alex-cond-2.html\">Trigeminal neuralgia</a></li><br/><li><b>Entry:</b> <a href=\"Condition-Alex-cond-3.html\">Depression</a></li><br/><li><b>Entry:</b> <a href=\"Condition-Alex-cond-4.html\">Overweight</a></li></ul><li><b>Title:</b> Medication Summary<br/><b>Code:</b> Hx of Medication use (10160-0)</li><br/><ul><li><b>Entry:</b> <a href=\"MedicationStatement-Alex-med-stat-1.html\">BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Alex-med-stat-2.html\">Calcium/Vit D</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Alex-med-stat-3.html\">Folic Acid + Cyanocobalamin + Iodur 1 t QD</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Alex-med-stat-4.html\">Carbamazepine 1 t TID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Alex-med-stat-5.html\">Orlistat 1 cp TID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Alex-med-stat-6.html\">St. John’s Wort 2 cp BID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Alex-med-stat-7.html\">Collagen and magnesium supplements</a></li><br/></ul></ul></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/Alex-pract",
            "display" : "Dr. Walter Waltz"
          }
        ],
        "title" : "Patient Summary (Alex Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/Alex-cond-1",
                "display" : "Metabolic Syndrome"
              },
              {
                "reference" : "Condition/Alex-cond-2",
                "display" : "Prostate Cancer"
              },
              {
                "reference" : "Condition/Alex-cond-3",
                "display" : "DT2M"
              },
              {
                "reference" : "Condition/Alex-cond-4",
                "display" : "Overweigth"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Medication list Reported</div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/Alex-med-stat-1",
                "display" : "Metformin 500 mg PO with the two largest meals → slowly titrate to 1 g BID"
              },
              {
                "reference" : "MedicationStatement/Alex-med-stat-2",
                "display" : "Atorvastatin 40 mg PO nightly"
              },
              {
                "reference" : "MedicationStatement/Alex-med-stat-4",
                "display" : "Semaglutide 2.4 mg SC once weekly"
              },
              {
                "reference" : "MedicationStatement/Alex-med-stat-5",
                "display" : "Finasteride 5 mg PO daily"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/Alex-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "Alex-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_Alex-patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient Alex-patient</b></p><a name=\"Alex-patient\"> </a><a name=\"hcAlex-patient\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Alex Gravitate  Male, DoB: 1975-10-05 ( https://www.gravitatehealth.eu/sid/doc#Alex-1)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>keycloak-id</code>/66dfc284-c19e-427b-914e-b3156bdc86d6</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 FR}\">France</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "FR",
                      "display" : "France"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "Alex-1"
          },
          {
            "system" : "keycloak-id",
            "value" : "66dfc284-c19e-427b-914e-b3156bdc86d6"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Alex"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1975-10-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/Alex-pract",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Alex-pract",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Alex-pract\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Alex-pract</b></p><a name=\"Alex-pract\"> </a><a name=\"hcAlex-pract\"> </a><p><b>name</b>: Walter Waltz </p></div>"
        },
        "name" : [
          {
            "family" : "Waltz",
            "given" : ["Walter"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Alex-cond-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Alex-cond-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Alex-cond-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Alex-cond-1</b></p><a name=\"Alex-cond-1\"> </a><a name=\"hcAlex-cond-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 237602007}\">Metabolic syndrome X</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "237602007",
              "display" : "Metabolic syndrome X"
            }
          ],
          "text" : "Metabolic syndrome X"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Alex-cond-2",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Alex-cond-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Alex-cond-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Alex-cond-2</b></p><a name=\"Alex-cond-2\"> </a><a name=\"hcAlex-cond-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 1259388006}\">Primary carcinoma of prostate</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-alex-himss.html#Practitioner_Alex-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "1259388006",
              "display" : "Primary carcinoma of prostate"
            }
          ],
          "text" : "Primary carcinoma of prostate"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/Alex-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Alex-cond-3",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Alex-cond-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Alex-cond-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Alex-cond-3</b></p><a name=\"Alex-cond-3\"> </a><a name=\"hcAlex-cond-3\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 44054006}\">Diabetes mellitus type 2 (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-alex-himss.html#Practitioner_Alex-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "44054006",
              "display" : "Diabetes mellitus type 2"
            }
          ],
          "text" : "Diabetes mellitus type 2 (disorder)"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "identifier" : {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "Alex-1"
          },
          "display" : "Alex Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/Alex-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Alex-cond-4",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Alex-cond-4",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Alex-cond-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Alex-cond-4</b></p><a name=\"Alex-cond-4\"> </a><a name=\"hcAlex-cond-4\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 238131007}\">Overweight</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-alex-himss.html#Practitioner_Alex-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "238131007",
              "display" : "Overweight"
            }
          ],
          "text" : "Overweight"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/Alex-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Alex-med-stat-1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Alex-med-stat-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Alex-med-stat-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Alex-med-stat-1</b></p><a name=\"Alex-med-stat-1\"> </a><a name=\"hcAlex-med-stat-1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-alex-himss.html#Medication_alex-med-1\">Metformin 500 mg PO with the two largest meals → slowly titrate to 1 g BID</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/alex-med-1",
          "display" : "Metformin 500 mg PO with the two largest meals → slowly titrate to 1 g BID"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Alex-med-stat-2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Alex-med-stat-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Alex-med-stat-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Alex-med-stat-2</b></p><a name=\"Alex-med-stat-2\"> </a><a name=\"hcAlex-med-stat-2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-alex-himss.html#Medication_alex-med-2\">Atorvastatin 40 mg PO nightly</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/alex-med-2",
          "display" : "Atorvastatin 40 mg PO nightly"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Alex-med-stat-4",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Alex-med-stat-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Alex-med-stat-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Alex-med-stat-4</b></p><a name=\"Alex-med-stat-4\"> </a><a name=\"hcAlex-med-stat-4\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-alex-himss.html#Medication_alex-med-4\">Semaglutide 2.4 mg SC once weekly</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/alex-med-4",
          "display" : "Semaglutide 2.4 mg SC once weekly"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Alex-med-stat-5",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Alex-med-stat-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Alex-med-stat-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Alex-med-stat-5</b></p><a name=\"Alex-med-stat-5\"> </a><a name=\"hcAlex-med-stat-5\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-alex-himss.html#Medication_alex-med-5\">Finasteride 5 mg PO daily</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-alex-himss.html#Patient_Alex-patient\">Alex Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/alex-med-5",
          "display" : "Finasteride 5 mg PO daily"
        },
        "subject" : {
          "reference" : "Patient/Alex-patient",
          "display" : "Alex Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/alex-med-1",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "alex-med-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_alex-med-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication alex-med-1</b></p><a name=\"alex-med-1\"> </a><a name=\"hcalex-med-1\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-metformin}, {https://spor.ema.europa.eu/pmswi himss-6}\">Metformin 500 mg tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 9100L32L2N}\">metformin</span></td><td>500 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{tablet} = '{tablet}')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-metformin",
              "display" : "Metformin 500 mg tablets"
            },
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "himss-6",
              "display" : "Metformin 500 mg"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "9100L32L2N",
                  "display" : "metformin"
                }
              ],
              "text" : "metformin"
            },
            "strength" : {
              "numerator" : {
                "value" : 500,
                "unit" : "mg",
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://unitsofmeasure.org",
                "code" : "{tablet}"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/alex-med-2",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "alex-med-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_alex-med-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication alex-med-2</b></p><a name=\"alex-med-2\"> </a><a name=\"hcalex-med-2\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-Atorvastatin}, {https://spor.ema.europa.eu/pmswi himss-7}\">Atorvastatin 40 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10220000}\">Coated tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 935E97BOY8}\">FOLIC ACID</span></td><td>40 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-Atorvastatin",
              "display" : "Atorvastatin 40 mg"
            },
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "himss-7",
              "display" : "Atorvastatin 40 mg"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10220000",
              "display" : "Coated tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "935E97BOY8",
                  "display" : "FOLIC ACID"
                }
              ],
              "text" : "FOLIC ACID"
            },
            "strength" : {
              "numerator" : {
                "value" : 40,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/alex-med-4",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "alex-med-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_alex-med-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication alex-med-4</b></p><a name=\"alex-med-4\"> </a><a name=\"hcalex-med-4\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-semaglutide}, {https://spor.ema.europa.eu/pmswi himss-9}\">Semaglutide 2.4 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10222000}\">Effervescent tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov H0G9379FGK}\">calcium carbonate</span></td><td>2.4 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Dose<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-semaglutide",
              "display" : "Semaglutide 2.4 mg"
            },
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "himss-9",
              "display" : "Semaglutide 2.4 mg "
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10222000",
              "display" : "Effervescent tablet"
            }
          ],
          "text" : "Effervescent tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "H0G9379FGK",
                  "display" : "Calcium carbonate"
                }
              ],
              "text" : "calcium carbonate"
            },
            "strength" : {
              "numerator" : {
                "value" : 2.4,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Dose",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/alex-med-5",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "alex-med-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_alex-med-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication alex-med-5</b></p><a name=\"alex-med-5\"> </a><a name=\"hcalex-med-5\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-finasteride}, {https://spor.ema.europa.eu/pmswi himss-10}\">Finasteride 5 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10222000}\">Effervescent tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov H0G9379FGK}\">calcium carbonate</span></td><td>5 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-finasteride",
              "display" : "Finasteride 5 mg"
            },
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "himss-10",
              "display" : "Finasteride 5 mg"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10222000",
              "display" : "Effervescent tablet"
            }
          ],
          "text" : "Effervescent tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "H0G9379FGK",
                  "display" : "Calcium carbonate"
                }
              ],
              "text" : "calcium carbonate"
            },
            "strength" : {
              "numerator" : {
                "value" : 5,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    }
  ]
}

```
