# Renee Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Renee Gravitate's IPS**

## Example Bundle: Renee Gravitate's IPS

**id:**gravitate-Renee

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**Renee-1

**Name:**Renee Gravitate

**active:**true

**gender:**female

**Birth Date:**1950-10-05

### Sections

#### Problem List

**Condition:**Aortic valve stenosis (60573004)

**clinicalStatus:**active

**Condition:**Heart failure (84114007)

**clinicalStatus:**active

**asserter:**Dr. Walter Waltz

**onsetDateTime:**2018

#### Medication Summary

**Medication:**aspirin 75 mg

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-Aspirin [Aspirin 75 mg]

**Dose Form:**Tablet

**Ingredient:**HYPERICUM PERFORATUM WHOLE (http://fdasis.nlm.nih.gov#XK4IUX8MNB)

**strength:**75 mg/1 Tablet

**Route:**Oral use

**Medication:**Atorvastatin 40 mg PO nightly

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-Atorvastatin [Atorvastatin 40 mg]

**Dose Form:**Tablet

**Ingredient:**Calcium carbonate (http://fdasis.nlm.nih.gov#H0G9379FGK)

**strength:**40 mg/1 Tablet

**Route:**Oral use

**Medication:**Furosemide 20 mg PO AM (↑ PRN)

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-Furosemide [Furosemide 20 mg]

*  **System** https://spor.ema.europa.eu/pmswi **Code:** himss-3 [Furosemide 20 mg PO AM (↑ PRN)]

**Dose Form:**Tablet

**Ingredient:**HYPERICUM PERFORATUM WHOLE (http://fdasis.nlm.nih.gov#XK4IUX8MNB)

**strength:**20 mg/1 Tablet

**Route:**Oral use

**Medication:**Ramipril 1.25 mg PO nightly (titrate q1-2 wk)

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-ramipril [Ramipril 1.25 mg]

**Dose Form:**Tablet

**Ingredient:**INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE (http://fdasis.nlm.nih.gov#TU2UN5CG9C)

**strength:**1.25 mg/1 Tablet

**Route:**Oral use

**Medication:**Loratadine

**status:**active

**Medication Detail:**

*  **System** https://www.gravitatehealth.eu/sid/doc **Code:** himss-loratadine [Loratadine 10 mg]

**Dose Form:**Tablet

**Ingredient:**INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE (http://fdasis.nlm.nih.gov#TU2UN5CG9C)

**strength:**10 mg/1 Tablet

**Route:**Oral use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-Renee",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "Renee-ips-1"
  },
  "type" : "document",
  "timestamp" : "2025-06-04T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/Renee-comp",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-Renee",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-Renee\"> </a><b>Id:</b> gravitate-Renee<br/><b>status:</b> final<br/><b>Type:</b> Patient summary Document<br/><b>Subject:</b> Renee Gravitate<br/><b>Sections:</b><br/><ul><li><b>Title:</b> Problem List<br/><b>Code:</b> Problem list Reported (11450-4)</li><br/><ul><li><b>Entry:</b> <a href=\"Condition-Renee-cond-1.html\">HIV</a></li><br/><li><b>Entry:</b> <a href=\"Condition-Renee-cond-2.html\">Trigeminal neuralgia</a></li><br/><li><b>Entry:</b> <a href=\"Condition-Renee-cond-3.html\">Depression</a></li><br/><li><b>Entry:</b> <a href=\"Condition-Renee-cond-4.html\">Overweight</a></li></ul><li><b>Title:</b> Medication Summary<br/><b>Code:</b> Hx of Medication use (10160-0)</li><br/><ul><li><b>Entry:</b> <a href=\"MedicationStatement-Renee-med-stat-1.html\">BIKTARVY Bictegravir/Emtricitabine/Tenofovir Alafenamide 1 t QD</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Renee-med-stat-2.html\">Calcium/Vit D</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Renee-med-stat-3.html\">Folic Acid + Cyanocobalamin + Iodur 1 t QD</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Renee-med-stat-4.html\">Carbamazepine 1 t TID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Renee-med-stat-5.html\">Orlistat 1 cp TID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Renee-med-stat-6.html\">St. John’s Wort 2 cp BID</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-Renee-med-stat-7.html\">Collagen and magnesium supplements</a></li><br/></ul></ul></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/Renee-pract",
            "display" : "Dr. Walter Waltz"
          }
        ],
        "title" : "Patient Summary (Renee Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/Renee-cond-1",
                "display" : "Depression"
              },
              {
                "reference" : "Condition/Renee-cond-2",
                "display" : "HIV"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "text" : {
              "status" : "additional",
              "div" : "<div>Medication list Reported</div>"
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/Renee-med-stat-1",
                "display" : "aspirin 75 mg PO OD"
              },
              {
                "reference" : "MedicationStatement/Renee-med-stat-2",
                "display" : "Atorvastatin 40 mg PO nightly"
              },
              {
                "reference" : "MedicationStatement/Renee-med-stat-3",
                "display" : "Furosemide 20 mg PO AM (↑ PRN)"
              },
              {
                "reference" : "MedicationStatement/Renee-med-stat-4",
                "display" : "Ramipril 1.25 mg PO nightly (titrate q1-2 wk)"
              },
              {
                "reference" : "MedicationStatement/Renee-med-stat-5",
                "display" : "Loratadine"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/Renee-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "Renee-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_Renee-patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient Renee-patient</b></p><a name=\"Renee-patient\"> </a><a name=\"hcRenee-patient\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Renee Gravitate  Female, DoB: 1950-10-05 ( https://www.gravitatehealth.eu/sid/doc#Renee-1)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"Other Id (see the one above)\">Other Id:</td><td colspan=\"3\"><code>keycloak-id</code>/c693b6c7-8a8f-471d-a57d-69b59c797771</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 FR}\">France</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "FR",
                      "display" : "France"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "Renee-1"
          },
          {
            "system" : "keycloak-id",
            "value" : "c693b6c7-8a8f-471d-a57d-69b59c797771"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Renee"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1950-10-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/Renee-pract",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "Renee-pract",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_Renee-pract\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner Renee-pract</b></p><a name=\"Renee-pract\"> </a><a name=\"hcRenee-pract\"> </a><p><b>name</b>: Walter Waltz </p></div>"
        },
        "name" : [
          {
            "family" : "Waltz",
            "given" : ["Walter"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Renee-cond-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Renee-cond-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Renee-cond-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Renee-cond-1</b></p><a name=\"Renee-cond-1\"> </a><a name=\"hcRenee-cond-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 60573004}\">Aortic valve stenosis</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Renee.html#Patient_Renee-patient\">Renee Gravitate</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "60573004",
              "display" : "Aortic valve stenosis"
            }
          ],
          "text" : "Aortic valve stenosis"
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/Renee-cond-2",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "Renee-cond-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_Renee-cond-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition Renee-cond-2</b></p><a name=\"Renee-cond-2\"> </a><a name=\"hcRenee-cond-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 84114007}\">Heart failure</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Renee.html#Patient_Renee-patient\">Renee Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Renee.html#Practitioner_Renee-pract\">Dr. Walter Waltz</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "84114007",
              "display" : "Heart failure"
            }
          ],
          "text" : "Heart failure"
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/Renee-pract",
          "display" : "Dr. Walter Waltz"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Renee-med-stat-1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Renee-med-stat-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Renee-med-stat-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Renee-med-stat-1</b></p><a name=\"Renee-med-stat-1\"> </a><a name=\"hcRenee-med-stat-1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Renee.html#Medication_renee-med-1\">aspirin 75 mg</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Renee.html#Patient_Renee-patient\">Renee Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/renee-med-1",
          "display" : "aspirin 75 mg"
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Renee-med-stat-2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Renee-med-stat-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Renee-med-stat-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Renee-med-stat-2</b></p><a name=\"Renee-med-stat-2\"> </a><a name=\"hcRenee-med-stat-2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Renee.html#Medication_renee-med-2\">Atorvastatin 40 mg PO nightly</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Renee.html#Patient_Renee-patient\">Renee Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/renee-med-2",
          "display" : "Atorvastatin 40 mg PO nightly"
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Renee-med-stat-3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Renee-med-stat-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Renee-med-stat-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Renee-med-stat-3</b></p><a name=\"Renee-med-stat-3\"> </a><a name=\"hcRenee-med-stat-3\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Renee.html#Medication_renee-med-3\">Furosemide 20 mg PO AM (↑ PRN)</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Renee.html#Patient_Renee-patient\">Renee Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/renee-med-3",
          "display" : "Furosemide 20 mg PO AM (↑ PRN)"
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Renee-med-stat-4",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Renee-med-stat-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Renee-med-stat-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Renee-med-stat-4</b></p><a name=\"Renee-med-stat-4\"> </a><a name=\"hcRenee-med-stat-4\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Renee.html#Medication_renee-med-4\">Ramipril 1.25 mg PO nightly (titrate q1-2 wk)</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Renee.html#Patient_Renee-patient\">Renee Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/renee-med-4",
          "display" : "Ramipril 1.25 mg PO nightly (titrate q1-2 wk)"
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/Renee-med-stat-5",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "Renee-med-stat-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_Renee-med-stat-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement Renee-med-stat-5</b></p><a name=\"Renee-med-stat-5\"> </a><a name=\"hcRenee-med-stat-5\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Renee.html#Medication_renee-med-5\">Loratadine</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Renee.html#Patient_Renee-patient\">Renee Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/renee-med-5",
          "display" : "Loratadine"
        },
        "subject" : {
          "reference" : "Patient/Renee-patient",
          "display" : "Renee Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/renee-med-1",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "renee-med-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_renee-med-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication renee-med-1</b></p><a name=\"renee-med-1\"> </a><a name=\"hcrenee-med-1\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-Aspirin}\">Aspirin 75 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov XK4IUX8MNB}\">HYPERICUM PERFORATUM WHOLE</span></td><td>75 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-Aspirin",
              "display" : "Aspirin 75 mg"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "XK4IUX8MNB",
                  "display" : "HYPERICUM PERFORATUM WHOLE"
                }
              ],
              "text" : "HYPERICUM PERFORATUM WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 75,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/renee-med-2",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "renee-med-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_renee-med-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication renee-med-2</b></p><a name=\"renee-med-2\"> </a><a name=\"hcrenee-med-2\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-Atorvastatin}\">Atorvastatin 40 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov H0G9379FGK}\">calcium carbonate</span></td><td>40 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-Atorvastatin",
              "display" : "Atorvastatin 40 mg"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "H0G9379FGK",
                  "display" : "Calcium carbonate"
                }
              ],
              "text" : "calcium carbonate"
            },
            "strength" : {
              "numerator" : {
                "value" : 40,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/renee-med-3",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "renee-med-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_renee-med-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication renee-med-3</b></p><a name=\"renee-med-3\"> </a><a name=\"hcrenee-med-3\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-Furosemide}, {https://spor.ema.europa.eu/pmswi himss-3}\">Furosemide 20 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov XK4IUX8MNB}\">HYPERICUM PERFORATUM WHOLE</span></td><td>20 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-Furosemide",
              "display" : "Furosemide 20 mg"
            },
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "himss-3",
              "display" : "Furosemide 20 mg PO AM (↑ PRN)"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "XK4IUX8MNB",
                  "display" : "HYPERICUM PERFORATUM WHOLE"
                }
              ],
              "text" : "HYPERICUM PERFORATUM WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 20,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/renee-med-4",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "renee-med-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_renee-med-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication renee-med-4</b></p><a name=\"renee-med-4\"> </a><a name=\"hcrenee-med-4\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-ramipril}\">Ramipril 1.25 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov TU2UN5CG9C}\">INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE</span></td><td>1.25 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-ramipril",
              "display" : "Ramipril 1.25 mg"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "TU2UN5CG9C",
                  "display" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
                }
              ],
              "text" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 1.25,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/renee-med-5",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "renee-med-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_renee-med-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication renee-med-5</b></p><a name=\"renee-med-5\"> </a><a name=\"hcrenee-med-5\"> </a><p><b>code</b>: <span title=\"Codes:{https://www.gravitatehealth.eu/sid/doc himss-loratadine}\">Loratadine 10 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov TU2UN5CG9C}\">INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE</span></td><td>10 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://www.gravitatehealth.eu/sid/doc",
              "code" : "himss-loratadine",
              "display" : "Loratadine 10 mg"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "TU2UN5CG9C",
                  "display" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
                }
              ],
              "text" : "INFLUENZA A VIRUS A/WISCONSIN/588/2019 (H1N1) WHOLE"
            },
            "strength" : {
              "numerator" : {
                "value" : 10,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    }
  ]
}

```
