# Pedro Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Pedro Gravitate's IPS**

## Example Bundle: Pedro Gravitate's IPS

**id:**gravitate-Pedro

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**Pedro-1

**Name:**Pedro Gravitate

**active:**true

**gender:**male

**Birth Date:**1980-10-05

### Sections

#### Problem List

**Condition:**Depressive disorder (disorder) (35489007)

**clinicalStatus:**active

**Condition:**Human immunodeficiency virus infection (86406008)

**clinicalStatus:**active

**asserter:**Dr. Xavier García

**onsetDateTime:**2018

**Condition:**Irritable bowel syndrome (10743008)

**clinicalStatus:**active

#### Medication Summary

**Medication:**Dovato 50 mg/300 mg (Dolutegravir/ Lamivudine) tablets

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/19/1370/001 [Dovato 50 mg/300 mg 30 tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0x073AF2E5B92AE19E8B67635AFFB3D6CA [lamivudine and dolutegravir, 300 mg/50 mg, tablets]

*  **System** http://snomed.info/sct **Code:** 787165000 [Dolutegravir- and lamivudine-containing product in oral dose form]

*  **System** http://www.whocc.no/atc **Code:** J05AR25 [lamivudine and dolutegravir]

**Dose Form:**Coated tablet

**Ingredient:**lamivudine (http://fdasis.nlm.nih.gov#2T8Q726O95)

**strength:**300 mg/1 Tablet

**Ingredient:**dolutegravir (http://fdasis.nlm.nih.gov#DKO1W9H7M1)

**strength:**50 mg/1 Tablet

**Route:**Oral use

**Medication:**Mirtazapine 30 mg Coated Tablet

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 67.068 [MIRTAZAPINA CINFA 30 mg Coated Tablet]

*  **System** https://www.who-umc.org/phpid **Code:** 0x6c47381b040e5b588db23b2272f28eec [mirtazapine 30 mg, tablets]

*  **System** http://www.whocc.no/atc **Code:** N06AX11 [mirtazapine]

**Dose Form:**Coated tablet

**Ingredient:**Mirtazapine (http://fdasis.nlm.nih.gov#A051Q2099Q)

**strength:**30 g/1 Tablet

**Route:**Oral use

**Medication:**CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 68290 [CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E82716 [Calcium Vitamin D]

**Dose Form:**Effervescent tablet

**Ingredient:**Calcium carbonate (http://fdasis.nlm.nih.gov#H0G9379FGK)

**strength:**1000 mg/1 Tablet

**Ingredient:**cholecalciferol (http://fdasis.nlm.nih.gov#1C6V77QF41)

**strength:**880 {UI}/1 Tablet

**Route:**Oral use

**Medication:**cinitrapide 1 mg

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 59.032 [BLASTON 1 mg tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0xbb82cd10ab2add752b2b9224931077b2 [cinitrapide 1 mg tablet]

*  **System** http://www.whocc.no/atc **Code:** A03FA08 [Cinitapride]

**Dose Form:**Tablet

**Ingredient:**CINITAPRIDE (http://fdasis.nlm.nih.gov#R8I97I2L24)

**strength:**1 mg/1 Tablet

**Route:**Oral use

**Medication:**Collagen and magnesium supplements

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 0xb9846396e9e1eedc4a344e7b64d57107 [AQUILEA ARTICULACIONES COLAGENO Y MAGNESIO 375GR]

**Dose Form:**Oral powder

**Ingredient:**MAGNESIUM (http://fdasis.nlm.nih.gov#I38ZP9992A)

**Ingredient:**HYALURONIC ACID (http://fdasis.nlm.nih.gov#S270N0TRQY)

**Ingredient:**HUMAN TYPE I COLLAGEN (http://fdasis.nlm.nih.gov#PT3TGI7OIP)

**Route:**Oral use

**Medication:**Vitaminc C supplement

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 0x173fdc0ef097ed4dbe3915fba2e90586 [SORIA NATURAL VITAMINA C 36 COMPRIMIDOS]

*  **System** http://www.whocc.no/atc **Code:** A11GA01 [ascorbic acid (vit C)]

**Dose Form:**Modified-release tablet

**Ingredient:**ASCORBIC ACID (http://fdasis.nlm.nih.gov#PQ6CK8PD0R)

**Route:**Oral use

**Medication:**Protein supplements

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 0x81bb4f17d1ea7aabcd39383d33a4f2d6 [NATURES PLUS SPIRU-TEIN BATIDO PROTEINA SABOR COOKIES 525GR]

**Dose Form:**Oral powder

**Ingredient:**SOY PROTEIN (http://fdasis.nlm.nih.gov#R44IWB3RN5)

**Route:**Oral use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-Pedro",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "Pedro-ips-1"
  },
  "type" : "document",
  "timestamp" : "2021-04-18T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/5702fd1d-dd26-402e-a7c0-7629a5d9bba1",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-Pedro",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-Pedro\"> </a><b>Id:</b> gravitate-Pedro<br/><b>status:</b> final<br/><b>Type:</b> Patient summary Document<br/><b>Subject:</b> Pedro Gravitate<br/><b>Sections:</b><br/><ul><li><b>Title:</b> Problem List<br/><b>Code:</b> Problem list Reported (11450-4)</li><br/><ul><li><b>Entry:</b> <a href=\"Condition-pedro-cond-1.html\">HIV</a></li><br/><li><b>Entry:</b> <a href=\"Condition-pedro-cond-2.html\">Depression</a></li><br/><li><b>Entry:</b> <a href=\"Condition-pedro-cond-3.html\">IBS</a></li><br/></ul><li><b>Title:</b> Medication Summary<br/><b>Code:</b> Hx of Medication use (10160-0)</li><br/><ul><li><b>Entry:</b> <a href=\"MedicationStatement-pedro-med-stat-1.html\">Dovato lamivudine and dolutegravir, 300 mg/50 mg</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-pedro-med-stat-2.html\">Mirtazapine 15 mg</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-pedro-med-stat-3.html\">Calcium carbonate 500 mg</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-pedro-med-stat-4.html\">Cinitrapide 1 mg</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-pedro-med-stat-5.html\">Collagen and magnesium supplements</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-pedro-med-stat-6.html\">Vitamin C supplements</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-pedro-med-stat-7.html\">Protein supplements</a></li><br/></ul></ul></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/pedro-pract",
            "display" : "Dr. Anna Karlsson"
          }
        ],
        "title" : "Patient Summary (Pedro Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/pedro-cond-1",
                "display" : "Depression"
              },
              {
                "reference" : "Condition/pedro-cond-2",
                "display" : "HIV"
              },
              {
                "reference" : "Condition/pedro-cond-3",
                "display" : "IBS"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/pedro-med-stat-1",
                "display" : "Dovato lamivudine and dolutegravir, 300 mg/50 mg"
              },
              {
                "reference" : "MedicationStatement/pedro-med-stat-2",
                "display" : "Mirtazapine 15 mg"
              },
              {
                "reference" : "MedicationStatement/pedro-med-stat-3",
                "display" : "Calcium carbonate 500 mg"
              },
              {
                "reference" : "MedicationStatement/pedro-med-stat-4",
                "display" : "Cinitrapide 1 mg"
              },
              {
                "reference" : "MedicationStatement/pedro-med-stat-5",
                "display" : "Collagen and magnesium supplements"
              },
              {
                "reference" : "MedicationStatement/pedro-med-stat-6",
                "display" : "Vitamin C supplements"
              },
              {
                "reference" : "MedicationStatement/pedro-med-stat-7",
                "display" : "Protein supplements"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/pedro-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "pedro-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_pedro-patient\"> </a>Age: 42 years. I live alone, single. Electronics store salesperson Smoker since the age of 20 Interests: cultural events and concerts. I enjoy mountain activities, skiing in winter and hiking the rest of the year. Health Conditions HIV (diagnosed with 38 years) Depression</div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "ES",
                      "display" : "Spain"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "Pedro-1"
          },
          {
            "system" : "keycloak-id",
            "value" : "b17f0a96-cb4a-45cd-be09-cbadbe428948"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Pedro"]
          }
        ],
        "gender" : "male",
        "birthDate" : "1980-10-05"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/pedro-pract",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "pedro-pract",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_pedro-pract\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner pedro-pract</b></p><a name=\"pedro-pract\"> </a><a name=\"hcpedro-pract\"> </a><p><b>name</b>: Xavier García </p></div>"
        },
        "name" : [
          {
            "family" : "García",
            "given" : ["Xavier"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/pedro-cond-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "pedro-cond-1",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_pedro-cond-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition pedro-cond-1</b></p><a name=\"pedro-cond-1\"> </a><a name=\"hcpedro-cond-1\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:\">confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 35489007}\">Depressive disorder (disorder)</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "35489007",
              "display" : "Depressive disorder (disorder)"
            }
          ],
          "text" : "Depressive disorder (disorder)"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/pedro-cond-2",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "pedro-cond-2",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_pedro-cond-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition pedro-cond-2</b></p><a name=\"pedro-cond-2\"> </a><a name=\"hcpedro-cond-2\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:\">confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 86406008}\">Human immunodeficiency virus infection</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><p><b>onset</b>: 2018</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Pedro.html#Practitioner_pedro-pract\">Dr. Xavier García</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "86406008",
              "display" : "Human immunodeficiency virus infection"
            }
          ],
          "text" : "Human immunodeficiency virus infection"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "onsetDateTime" : "2018",
        "asserter" : {
          "reference" : "Practitioner/pedro-pract",
          "display" : "Dr. Xavier García"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/pedro-cond-3",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "pedro-cond-3",
        "meta" : {
          "profile" : [
            "http://hl7.org/fhir/uv/ips/StructureDefinition/Condition-uv-ips"
          ]
        },
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_pedro-cond-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition pedro-cond-3</b></p><a name=\"pedro-cond-3\"> </a><a name=\"hcpedro-cond-3\"> </a><div style=\"display: inline-block; background-color: #d9e0e7; padding: 6px; margin: 4px; border: 1px solid #8da1b4; border-radius: 5px; line-height: 60%\"><p style=\"margin-bottom: 0px\"/><p style=\"margin-bottom: 0px\">Profile: <a href=\"https://build.fhir.org/ig/HL7/fhir-ips/StructureDefinition-Condition-uv-ips.html\">Condition (IPS)</a></p></div><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>verificationStatus</b>: <span title=\"Codes:\">confirmed</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 10743008}\">Irritable bowel syndrome</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "verificationStatus" : {
          "coding" : [
            {
              "code" : "confirmed"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "10743008",
              "display" : "Irritable bowel syndrome"
            }
          ],
          "text" : "Irritable bowel syndrome"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/pedro-med-stat-1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "pedro-med-stat-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_pedro-med-stat-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement pedro-med-stat-1</b></p><a name=\"pedro-med-stat-1\"> </a><a name=\"hcpedro-med-stat-1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_9d7be868-8264-4d94-ad04-ef04ecc92e52\">Dovato 50 mg/300 mg (Dolutegravir/ Lamivudine) tablets</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9d7be868-8264-4d94-ad04-ef04ecc92e52",
          "display" : "Dovato 50 mg/300 mg (Dolutegravir/ Lamivudine) tablets"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/pedro-med-stat-2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "pedro-med-stat-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_pedro-med-stat-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement pedro-med-stat-2</b></p><a name=\"pedro-med-stat-2\"> </a><a name=\"hcpedro-med-stat-2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4\">Mirtazapine 30 mg Coated Tablet</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4",
          "display" : "Mirtazapine 30 mg Coated Tablet"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/pedro-med-stat-3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "pedro-med-stat-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_pedro-med-stat-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement pedro-med-stat-3</b></p><a name=\"pedro-med-stat-3\"> </a><a name=\"hcpedro-med-stat-3\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda7785g\">CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda7785g",
          "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/pedro-med-stat-4",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "pedro-med-stat-4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_pedro-med-stat-4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement pedro-med-stat-4</b></p><a name=\"pedro-med-stat-4\"> </a><a name=\"hcpedro-med-stat-4\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77854\">cinitrapide 1 mg</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77854",
          "display" : "cinitrapide 1 mg"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/pedro-med-stat-5",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "pedro-med-stat-5",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_pedro-med-stat-5\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement pedro-med-stat-5</b></p><a name=\"pedro-med-stat-5\"> </a><a name=\"hcpedro-med-stat-5\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77855\">Collagen and magnesium supplements</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77855",
          "display" : "Collagen and magnesium supplements"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/pedro-med-stat-6",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "pedro-med-stat-6",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_pedro-med-stat-6\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement pedro-med-stat-6</b></p><a name=\"pedro-med-stat-6\"> </a><a name=\"hcpedro-med-stat-6\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77856\">Vitaminc C supplement</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77856",
          "display" : "Vitaminc C supplement"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/pedro-med-stat-7",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "pedro-med-stat-7",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_pedro-med-stat-7\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement pedro-med-stat-7</b></p><a name=\"pedro-med-stat-7\"> </a><a name=\"hcpedro-med-stat-7\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Pedro.html#Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77857\">Protein supplements</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Pedro.html#Patient_pedro-patient\">Pedro Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77857",
          "display" : "Protein supplements"
        },
        "subject" : {
          "reference" : "Patient/pedro-patient",
          "display" : "Pedro Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9d7be868-8264-4d94-ad04-ef04ecc92e52",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9d7be868-8264-4d94-ad04-ef04ecc92e52",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9d7be868-8264-4d94-ad04-ef04ecc92e52\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9d7be868-8264-4d94-ad04-ef04ecc92e52</b></p><a name=\"9d7be868-8264-4d94-ad04-ef04ecc92e52\"> </a><a name=\"hc9d7be868-8264-4d94-ad04-ef04ecc92e52\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/19/1370/001}, {https://www.who-umc.org/phpid 0x073AF2E5B92AE19E8B67635AFFB3D6CA}, {http://snomed.info/sct 787165000}, {http://www.whocc.no/atc J05AR25}\">Dovato 50 mg/300 mg 30 tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10220000}\">Coated tablet</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov 2T8Q726O95}\">lamivudine</span></p><p><b>strength</b>: 300 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov DKO1W9H7M1}\">dolutegravir</span></p><p><b>strength</b>: 50 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/19/1370/001",
              "display" : "Dovato 50 mg/300 mg 30 tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x073AF2E5B92AE19E8B67635AFFB3D6CA",
              "display" : "lamivudine and dolutegravir, 300 mg/50 mg, tablets"
            },
            {
              "system" : "http://snomed.info/sct",
              "code" : "787165000",
              "display" : "Dolutegravir- and lamivudine-containing product in oral dose form"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "J05AR25",
              "display" : "lamivudine and dolutegravir"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10220000",
              "display" : "Coated tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "2T8Q726O95",
                  "display" : "lamivudine"
                }
              ],
              "text" : "lamivudine"
            },
            "strength" : {
              "numerator" : {
                "value" : 300,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "DKO1W9H7M1",
                  "display" : "dolutegravir"
                }
              ],
              "text" : "dolutegravir"
            },
            "strength" : {
              "numerator" : {
                "value" : 50,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4</b></p><a name=\"fdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4\"> </a><a name=\"hcfdb5c97f-0a46-41ba-bc34-2efd2ef2f7e4\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 67.068}, {https://www.who-umc.org/phpid 0x6c47381b040e5b588db23b2272f28eec}, {http://www.whocc.no/atc N06AX11}\">MIRTAZAPINA CINFA 30 mg Coated Tablet</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10220000}\">Coated tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov A051Q2099Q}\">Mirtazapine</span></td><td>30 g<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeg = 'g')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "67.068",
              "display" : "MIRTAZAPINA CINFA 30 mg Coated Tablet"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0x6c47381b040e5b588db23b2272f28eec",
              "display" : "mirtazapine 30 mg, tablets"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N06AX11",
              "display" : "mirtazapine"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10220000",
              "display" : "Coated tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "A051Q2099Q",
                  "display" : "Mirtazapine"
                }
              ],
              "text" : "Mirtazapine"
            },
            "strength" : {
              "numerator" : {
                "value" : 30,
                "system" : "http://unitsofmeasure.org",
                "code" : "g"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda7785g",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda7785g",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda7785g\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda7785g</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda7785g\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda7785g\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 68290}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E82716}\">CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10222000}\">Effervescent tablet</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov H0G9379FGK}\">calcium carbonate</span></p><p><b>strength</b>: 1000 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov 1C6V77QF41}\">cholecalciferol</span></p><p><b>strength</b>: 880 {UI}<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  code{UI} = '{UI}')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "68290",
              "display" : "CALCIO/VITAMINA D3 ROVI 1000 mg/880 UI COMPRIMIDOS EFERVESCENTES"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E82716",
              "display" : "Calcium Vitamin D"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10222000",
              "display" : "Effervescent tablet"
            }
          ],
          "text" : "Effervescent tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "H0G9379FGK",
                  "display" : "Calcium carbonate"
                }
              ],
              "text" : "calcium carbonate"
            },
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "1C6V77QF41",
                  "display" : "cholecalciferol"
                }
              ],
              "text" : "cholecalciferol"
            },
            "strength" : {
              "numerator" : {
                "value" : 880,
                "system" : "http://unitsofmeasure.org",
                "code" : "{UI}"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77854",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda77854",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77854\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda77854</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda77854\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda77854\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 59.032}, {https://www.who-umc.org/phpid 0xbb82cd10ab2add752b2b9224931077b2}, {http://www.whocc.no/atc A03FA08}\">BLASTON 1 mg tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov R8I97I2L24}\">CINITAPRIDE</span></td><td>1 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "59.032",
              "display" : "BLASTON 1 mg tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xbb82cd10ab2add752b2b9224931077b2",
              "display" : "cinitrapide 1 mg tablet"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A03FA08",
              "display" : "Cinitapride"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "R8I97I2L24",
                  "display" : "CINITAPRIDE"
                }
              ],
              "text" : "CINITAPRIDE"
            },
            "strength" : {
              "numerator" : {
                "value" : 1,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77855",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda77855",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77855\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda77855</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda77855\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda77855\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 0xb9846396e9e1eedc4a344e7b64d57107}\">AQUILEA ARTICULACIONES COLAGENO Y MAGNESIO 375GR</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10201000}\">Oral powder</span></p><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov I38ZP9992A}\">MAGNESIUM</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov S270N0TRQY}\">HYALURONIC ACID</span></p></blockquote><blockquote><p><b>ingredient</b></p><p><b>item</b>: <span title=\"Codes:{http://fdasis.nlm.nih.gov PT3TGI7OIP}\">HUMAN TYPE I COLLAGEN</span></p></blockquote></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "0xb9846396e9e1eedc4a344e7b64d57107",
              "display" : "AQUILEA ARTICULACIONES COLAGENO Y MAGNESIO 375GR"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10201000",
              "display" : "Oral powder"
            }
          ],
          "text" : "Oral powder"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "I38ZP9992A",
                  "display" : "MAGNESIUM"
                }
              ],
              "text" : "MAGNESIUM"
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "S270N0TRQY",
                  "display" : "HYALURONIC ACID"
                }
              ],
              "text" : "HYALURONIC ACID"
            }
          },
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "PT3TGI7OIP",
                  "display" : "HUMAN TYPE I COLLAGEN"
                }
              ],
              "text" : "HUMAN TYPE I COLLAGEN"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77856",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda77856",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77856\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda77856</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda77856\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda77856\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 0x173fdc0ef097ed4dbe3915fba2e90586}, {http://www.whocc.no/atc A11GA01}\">SORIA NATURAL VITAMINA C 36 COMPRIMIDOS</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10227000}\">Modified-release tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov PQ6CK8PD0R}\">Vitamin C</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "0x173fdc0ef097ed4dbe3915fba2e90586",
              "display" : "SORIA NATURAL VITAMINA C 36 COMPRIMIDOS"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A11GA01",
              "display" : "ascorbic acid (vit C)"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10227000",
              "display" : "Modified-release tablet"
            }
          ],
          "text" : "Modified-release tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "PQ6CK8PD0R",
                  "display" : "ASCORBIC ACID"
                }
              ],
              "text" : "Vitamin C"
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/6f4151e9-91f6-4f1e-adc3-fb94dda77857",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "6f4151e9-91f6-4f1e-adc3-fb94dda77857",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_6f4151e9-91f6-4f1e-adc3-fb94dda77857\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 6f4151e9-91f6-4f1e-adc3-fb94dda77857</b></p><a name=\"6f4151e9-91f6-4f1e-adc3-fb94dda77857\"> </a><a name=\"hc6f4151e9-91f6-4f1e-adc3-fb94dda77857\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 0x81bb4f17d1ea7aabcd39383d33a4f2d6}\">NATURES PLUS SPIRU-TEIN BATIDO PROTEINA SABOR COOKIES 525GR</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10201000}\">Oral powder</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov R44IWB3RN5}\">SOY PROTEIN</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "0x81bb4f17d1ea7aabcd39383d33a4f2d6",
              "display" : "NATURES PLUS SPIRU-TEIN BATIDO PROTEINA SABOR COOKIES 525GR"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10201000",
              "display" : "Oral powder"
            }
          ],
          "text" : "Oral powder"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "R44IWB3RN5",
                  "display" : "SOY PROTEIN"
                }
              ],
              "text" : "SOY PROTEIN"
            }
          }
        ]
      }
    }
  ]
}

```
