# Matilda Gravitate's IPS - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Matilda Gravitate's IPS**

## Example Bundle: Matilda Gravitate's IPS

**id:**gravitate-Matilda

**Composition status:**final

**Composition Type:**Patient summary Document

**Subject:**

**identifier:**Matilda-1

**Name:**Matilda Gravitate

**active:**true

**gender:**female

**Birth Date:**1950-09-01

### Sections

#### Problem List

**Condition:**Crohn's disease (34000006)

**clinicalStatus:**active

**asserter:**Dr. Ana Lopez

**onsetDateTime:**2015

#### Medication Summary

**Medication:**Humira 40 mg

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** EU/1/03/256/022 [Humira 40 mg]

*  **System** https://www.who-umc.org/phpid **Code:** 0xe72f98caa2b13cb3ccb489a1a7945c91 [Humira 40 mg solution for injection in pre-filled syringe 2 pre-filled syringes + 2 alcohol pads]

*  **System** http://www.whocc.no/atc **Code:** L04AB04 [adalimumab]

**Dose Form:**Solution for injection

**Ingredient:**adalimumab (http://fdasis.nlm.nih.gov#FYS6T7F842)

**strength:**40 mg/1

**Route:**Subcutaneous use

**Medication:**PARACETAMOL 1000 MG

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 72.741 [DOLOCATIL 1 g tablets]

*  **System** https://www.who-umc.org/phpid **Code:** 0xE857DA811B4A6F3BD57810C45D2EA1ED [Paracetamol 1g tablets]

*  **System** http://www.whocc.no/atc **Code:** N02BE01 [paracetamol]

**Dose Form:**Coated tablet

**Ingredient:**ACETAMINOPHEN (http://fdasis.nlm.nih.gov#362O9ITL9D)

**strength:**1000 mg/1 Tablet

**Route:**Oral use

**Medication:**Pentasa 1g mesalazine

**status:**active

**Medication Detail:**

*  **System** https://spor.ema.europa.eu/pmswi **Code:** 77022 [Pentasa Slow Release Tablets 1g]

*  **System** https://www.who-umc.org/phpid **Code:** 0xF79CABF272B6A7EEF104DDDA44E827xx [Mesalazine, 1g, Tablets]

*  **System** http://www.whocc.no/atc **Code:** A07EC02 [mesalazine]

**Dose Form:**Tablet

**Ingredient:**MESALAMINE (http://fdasis.nlm.nih.gov#4Q81I59GXC)

**strength:**1000 mg/1 Tablet

**Route:**Oral use



## Resource Content

```json
{
  "resourceType" : "Bundle",
  "id" : "gravitate-Matilda",
  "meta" : {
    "profile" : [
      "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    ]
  },
  "identifier" : {
    "system" : "https://www.gravitatehealth.eu/sid/doc",
    "value" : "Matilda-ips-1"
  },
  "type" : "document",
  "timestamp" : "2021-04-18T09:22:00+02:00",
  "entry" : [
    {
      "fullUrl" : "https://myserver.org/Composition/matilda-comp",
      "resource" : {
        "resourceType" : "Composition",
        "id" : "gravitate-Matilda",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Composition_gravitate-Matilda\"> </a><b>Id:</b> gravitate-Matilda<br/><b>status:</b> final<br/><b>Type:</b> Patient summary Document<br/><b>Subject:</b> Matilda Gravitate<br/><b>Sections:</b><br/><ul><li><b>Title:</b> Problem List<br/><b>Code:</b> Problem list Reported (11450-4)</li><br/><ul><li><b>Entry:</b> <a href=\"Condition-matilda-cond-1.html\">Crohn's disease</a></li><br/></ul><li><b>Title:</b> Medication Summary<br/><b>Code:</b> Hx of Medication use (10160-0)</li><br/><ul><li><b>Entry:</b> <a href=\"MedicationStatement-matilda-med-stat-1.html\">Humira 40 mg</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-matilda-med-stat-2.html\">Paracetamol 500 mg</a></li><br/><li><b>Entry:</b> <a href=\"MedicationStatement-matilda-med-stat-3.html\">Pentasa 1g mesalazine</a></li><br/></ul></ul></div>"
        },
        "status" : "final",
        "type" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "60591-5",
              "display" : "Patient summary Document"
            }
          ]
        },
        "subject" : {
          "reference" : "Patient/matilda-patient",
          "display" : "Matilda Gravitate"
        },
        "date" : "2018-07-10T15:22:00+02:00",
        "author" : [
          {
            "reference" : "Practitioner/matilda-pract",
            "display" : "Dr. Ana Lopez"
          }
        ],
        "title" : "Patient Summary (Matilda Gravitate)",
        "confidentiality" : "N",
        "section" : [
          {
            "title" : "Problem List",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "11450-4",
                  "display" : "Problem list Reported"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "Condition/matilda-cond-1",
                "display" : "Crohn's disease"
              }
            ]
          },
          {
            "title" : "Medication Summary",
            "code" : {
              "coding" : [
                {
                  "system" : "http://loinc.org",
                  "code" : "10160-0",
                  "display" : "Hx of Medication use"
                }
              ]
            },
            "entry" : [
              {
                "reference" : "MedicationStatement/matilda-med-stat-1",
                "display" : "Humira 40 mg"
              },
              {
                "reference" : "MedicationStatement/matilda-med-stat-2",
                "display" : "Paracetamol 500 mg"
              },
              {
                "reference" : "MedicationStatement/matilda-med-stat-3",
                "display" : "Pentasa 1g mesalazine"
              }
            ]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Patient/matilda-patient",
      "resource" : {
        "resourceType" : "Patient",
        "id" : "matilda-patient",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Patient_matilda-patient\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Patient matilda-patient</b></p><a name=\"matilda-patient\"> </a><a name=\"hcmatilda-patient\"> </a><p style=\"border: 1px #661aff solid; background-color: #e6e6ff; padding: 10px;\">Matilda Gravitate  Female, DoB: 1950-09-01 ( https://www.gravitatehealth.eu/sid/doc#Matilda-1)</p><hr/><table class=\"grid\"><tr><td style=\"background-color: #f3f5da\" title=\"Record is active\">Active:</td><td colspan=\"3\">true</td></tr><tr><td style=\"background-color: #f3f5da\" title=\"The patient's legal status as citizen of a country.\">Patient Citizenship:</td><td colspan=\"3\"><ul><li>code: <span title=\"Codes:{urn:iso:std:iso:3166 ES}\">Spain</span></li></ul></td></tr></table></div>"
        },
        "extension" : [
          {
            "extension" : [
              {
                "url" : "code",
                "valueCodeableConcept" : {
                  "coding" : [
                    {
                      "system" : "urn:iso:std:iso:3166",
                      "code" : "ES",
                      "display" : "Spain"
                    }
                  ]
                }
              }
            ],
            "url" : "http://hl7.org/fhir/StructureDefinition/patient-citizenship"
          }
        ],
        "identifier" : [
          {
            "system" : "https://www.gravitatehealth.eu/sid/doc",
            "value" : "Matilda-1"
          }
        ],
        "active" : true,
        "name" : [
          {
            "family" : "Gravitate",
            "given" : ["Matilda"]
          }
        ],
        "gender" : "female",
        "birthDate" : "1950-09-01"
      }
    },
    {
      "fullUrl" : "https://myserver.org/Practitioner/matilda-pract",
      "resource" : {
        "resourceType" : "Practitioner",
        "id" : "matilda-pract",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Practitioner_matilda-pract\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Practitioner matilda-pract</b></p><a name=\"matilda-pract\"> </a><a name=\"hcmatilda-pract\"> </a><p><b>name</b>: Ana Lopez </p></div>"
        },
        "name" : [
          {
            "family" : "Lopez",
            "given" : ["Ana"],
            "prefix" : ["Dr."]
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Condition/matilda-cond-1",
      "resource" : {
        "resourceType" : "Condition",
        "id" : "matilda-cond-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Condition_matilda-cond-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Condition matilda-cond-1</b></p><a name=\"matilda-cond-1\"> </a><a name=\"hcmatilda-cond-1\"> </a><p><b>clinicalStatus</b>: <span title=\"Codes:{http://terminology.hl7.org/CodeSystem/condition-clinical active}\">Active</span></p><p><b>code</b>: <span title=\"Codes:{http://snomed.info/sct 34000006}\">Crohn's disease</span></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Matilda.html#Patient_matilda-patient\">Matilda Gravitate</a></p><p><b>onset</b>: 2015</p><p><b>asserter</b>: <a href=\"Bundle-gravitate-Matilda.html#Practitioner_matilda-pract\">Dr. Ana Lopez</a></p></div>"
        },
        "clinicalStatus" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
              "code" : "active"
            }
          ]
        },
        "code" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "34000006",
              "display" : "Crohn's disease"
            }
          ],
          "text" : "Crohn's disease"
        },
        "subject" : {
          "reference" : "Patient/matilda-patient",
          "display" : "Matilda Gravitate"
        },
        "onsetDateTime" : "2015",
        "asserter" : {
          "reference" : "Practitioner/matilda-pract",
          "display" : "Dr. Ana Lopez"
        }
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/matilda-med-stat-1",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "matilda-med-stat-1",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_matilda-med-stat-1\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement matilda-med-stat-1</b></p><a name=\"matilda-med-stat-1\"> </a><a name=\"hcmatilda-med-stat-1\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Matilda.html#Medication_9d7be868-8264-4d94-ad04-ef04ecc92e51\">Humira 40 mg</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Matilda.html#Patient_matilda-patient\">Matilda Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20066000}\">Subcutaneous use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/9d7be868-8264-4d94-ad04-ef04ecc92e51",
          "display" : "Humira 40 mg"
        },
        "subject" : {
          "reference" : "Patient/matilda-patient",
          "display" : "Matilda Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20066000",
                  "display" : "Subcutaneous use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/matilda-med-stat-2",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "matilda-med-stat-2",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_matilda-med-stat-2\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement matilda-med-stat-2</b></p><a name=\"matilda-med-stat-2\"> </a><a name=\"hcmatilda-med-stat-2\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Matilda.html#Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7et\">PARACETAMOL 1000 MG</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Matilda.html#Patient_matilda-patient\">Matilda Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7et",
          "display" : "PARACETAMOL 1000 MG"
        },
        "subject" : {
          "reference" : "Patient/matilda-patient",
          "display" : "Matilda Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/MedicationStatement/matilda-med-stat-3",
      "resource" : {
        "resourceType" : "MedicationStatement",
        "id" : "matilda-med-stat-3",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"MedicationStatement_matilda-med-stat-3\"> </a><p class=\"res-header-id\"><b>Generated Narrative: MedicationStatement matilda-med-stat-3</b></p><a name=\"matilda-med-stat-3\"> </a><a name=\"hcmatilda-med-stat-3\"> </a><p><b>status</b>: Active</p><p><b>medication</b>: <a href=\"Bundle-gravitate-Matilda.html#Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu\">Pentasa 1g mesalazine</a></p><p><b>subject</b>: <a href=\"Bundle-gravitate-Matilda.html#Patient_matilda-patient\">Matilda Gravitate</a></p><h3>Dosages</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Route</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://standardterms.edqm.eu 20053000}\">Oral use</span></td></tr></table></div>"
        },
        "status" : "active",
        "medicationReference" : {
          "reference" : "Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu",
          "display" : "Pentasa 1g mesalazine"
        },
        "subject" : {
          "reference" : "Patient/matilda-patient",
          "display" : "Matilda Gravitate"
        },
        "dosage" : [
          {
            "route" : {
              "coding" : [
                {
                  "system" : "http://standardterms.edqm.eu",
                  "code" : "20053000",
                  "display" : "Oral use"
                }
              ]
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/9d7be868-8264-4d94-ad04-ef04ecc92e51",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "9d7be868-8264-4d94-ad04-ef04ecc92e51",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_9d7be868-8264-4d94-ad04-ef04ecc92e51\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication 9d7be868-8264-4d94-ad04-ef04ecc92e51</b></p><a name=\"9d7be868-8264-4d94-ad04-ef04ecc92e51\"> </a><a name=\"hc9d7be868-8264-4d94-ad04-ef04ecc92e51\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi EU/1/03/256/022}, {https://www.who-umc.org/phpid 0xe72f98caa2b13cb3ccb489a1a7945c91}, {http://www.whocc.no/atc L04AB04}\">Humira 40 mg</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 11201000}\">Solution for injection</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov FYS6T7F842}\">adalimumab</span></td><td>40 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 ml<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codeml = 'ml')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "EU/1/03/256/022",
              "display" : "Humira 40 mg"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xe72f98caa2b13cb3ccb489a1a7945c91",
              "display" : "Humira 40 mg solution for injection in pre-filled syringe 2 pre-filled syringes + 2 alcohol pads"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "L04AB04",
              "display" : "adalimumab"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "11201000",
              "display" : "Solution for injection"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "FYS6T7F842",
                  "display" : "adalimumab"
                }
              ],
              "text" : "adalimumab"
            },
            "strength" : {
              "numerator" : {
                "value" : 40,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "system" : "http://unitsofmeasure.org",
                "code" : "ml"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7et",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "fdb5c97f-0a46-41ba-bc34-2efd2ef2f7et",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7et\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication fdb5c97f-0a46-41ba-bc34-2efd2ef2f7et</b></p><a name=\"fdb5c97f-0a46-41ba-bc34-2efd2ef2f7et\"> </a><a name=\"hcfdb5c97f-0a46-41ba-bc34-2efd2ef2f7et\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 72.741}, {https://www.who-umc.org/phpid 0xE857DA811B4A6F3BD57810C45D2EA1ED}, {http://www.whocc.no/atc N02BE01}\">DOLOCATIL 1 g tablets</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10220000}\">Coated tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 362O9ITL9D}\">ACETAMINOPHEN</span></td><td>1000 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "72.741",
              "display" : "DOLOCATIL 1 g tablets"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xE857DA811B4A6F3BD57810C45D2EA1ED",
              "display" : "Paracetamol 1g tablets"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "N02BE01",
              "display" : "paracetamol"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10220000",
              "display" : "Coated tablet"
            }
          ]
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "362O9ITL9D",
                  "display" : "ACETAMINOPHEN"
                }
              ],
              "text" : "ACETAMINOPHEN"
            },
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    },
    {
      "fullUrl" : "https://myserver.org/Medication/fdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu",
      "resource" : {
        "resourceType" : "Medication",
        "id" : "fdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu",
        "text" : {
          "status" : "generated",
          "div" : "<div xmlns=\"http://www.w3.org/1999/xhtml\"><a name=\"Medication_fdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu\"> </a><p class=\"res-header-id\"><b>Generated Narrative: Medication fdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu</b></p><a name=\"fdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu\"> </a><a name=\"hcfdb5c97f-0a46-41ba-bc34-2efd2ef2f7eu\"> </a><p><b>code</b>: <span title=\"Codes:{https://spor.ema.europa.eu/pmswi 77022}, {https://www.who-umc.org/phpid 0xF79CABF272B6A7EEF104DDDA44E827xx}, {http://www.whocc.no/atc A07EC02}\">Pentasa Slow Release Tablets 1g</span></p><p><b>form</b>: <span title=\"Codes:{http://standardterms.edqm.eu 10219000}\">Tablet</span></p><h3>Ingredients</h3><table class=\"grid\"><tr><td style=\"display: none\">-</td><td><b>Item[x]</b></td><td><b>Strength</b></td></tr><tr><td style=\"display: none\">*</td><td><span title=\"Codes:{http://fdasis.nlm.nih.gov 4Q81I59GXC}\">MESALAMINE</span></td><td>1000 mg<span style=\"background: LightGoldenRodYellow\"> (Details: UCUM  codemg = 'mg')</span>/1 Tablet<span style=\"background: LightGoldenRodYellow\"> (Details: EDQM Standard Terms  code15054000 = 'Tablet')</span></td></tr></table></div>"
        },
        "code" : {
          "coding" : [
            {
              "system" : "https://spor.ema.europa.eu/pmswi",
              "code" : "77022",
              "display" : "Pentasa Slow Release Tablets 1g"
            },
            {
              "system" : "https://www.who-umc.org/phpid",
              "code" : "0xF79CABF272B6A7EEF104DDDA44E827xx",
              "display" : "Mesalazine, 1g, Tablets"
            },
            {
              "system" : "http://www.whocc.no/atc",
              "code" : "A07EC02",
              "display" : "mesalazine"
            }
          ]
        },
        "form" : {
          "coding" : [
            {
              "system" : "http://standardterms.edqm.eu",
              "code" : "10219000",
              "display" : "Tablet"
            }
          ],
          "text" : "Tablet"
        },
        "ingredient" : [
          {
            "itemCodeableConcept" : {
              "coding" : [
                {
                  "system" : "http://fdasis.nlm.nih.gov",
                  "code" : "4Q81I59GXC",
                  "display" : "MESALAMINE"
                }
              ],
              "text" : "MESALAMINE"
            },
            "strength" : {
              "numerator" : {
                "value" : 1000,
                "system" : "http://unitsofmeasure.org",
                "code" : "mg"
              },
              "denominator" : {
                "value" : 1,
                "unit" : "Tablet",
                "system" : "http://standardterms.edqm.eu",
                "code" : "15054000"
              }
            }
          }
        ]
      }
    }
  ]
}

```
