# Ovl-Alicia-medication-allergy - Gravitate Health FHIR Implementation Guide (FHIR R4) v0.1.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Ovl-Alicia-medication-allergy**

## Example AllergyIntolerance: Ovl-Alicia-medication-allergy

**clinicalStatus**: Active

**verificationStatus**: Unconfirmed

**category**: Medication

**criticality**: High Risk

**code**: Penicillin G

**patient**: [Alicia Gravitate Female, DoB: 1998-10-05 ( https://www.gravitatehealth.eu/sid/doc#alicia-1-local)](Bundle-Ovl-gravitate-Alicia.md#Patient_Ovl-alicia-patient)

**recordedDate**: 2025-03-01

**recorder**: [Dr. Walter Waltz](Bundle-Ovl-gravitate-Alicia.md#Practitioner_Ovl-alicia-pract)

### Reactions

| | |
| :--- | :--- |
| - | **Manifestation** |
| * | Hives |



## Resource Content

```json
{
  "resourceType" : "AllergyIntolerance",
  "id" : "Ovl-Alicia-medication-allergy",
  "clinicalStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-clinical",
        "code" : "active",
        "display" : "Active"
      }
    ]
  },
  "verificationStatus" : {
    "coding" : [
      {
        "system" : "http://terminology.hl7.org/CodeSystem/allergyintolerance-verification",
        "code" : "unconfirmed",
        "display" : "Unconfirmed"
      }
    ]
  },
  "category" : ["medication"],
  "criticality" : "high",
  "code" : {
    "coding" : [
      {
        "system" : "http://www.nlm.nih.gov/research/umls/rxnorm",
        "code" : "7980",
        "display" : "Penicillin G"
      }
    ]
  },
  "patient" : {
    "reference" : "Patient/Ovl-alicia-patient"
  },
  "recordedDate" : "2025-03-01",
  "recorder" : {
    "reference" : "Practitioner/Ovl-alicia-pract",
    "display" : "Dr. Walter Waltz"
  },
  "reaction" : [
    {
      "manifestation" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "code" : "247472004",
              "display" : "Hives"
            }
          ]
        }
      ]
    }
  ]
}

```
