# Supporting Information - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Supporting Information**

## Extension: Supporting Information 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/supportingInformation | *Version*:1.0.0-ci-build |
| Draft as of 2025-12-26 | *Computable Name*:SupportingInformation |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | |

This extension refers other resources from the patient record that may be relevant to the event. The information from these resources was either used to create the instance or is provided to help with its interpretation. This extension should not be used if more specific inline elements or extensions are available.

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/supportingInformation)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-supportingInformation.csv), [Excel](StructureDefinition-supportingInformation.xlsx), [Schematron](StructureDefinition-supportingInformation.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "supportingInformation",
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/supportingInformation",
  "version" : "1.0.0-ci-build",
  "name" : "SupportingInformation",
  "title" : "Supporting Information",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This extension refers other resources from the patient record that may be relevant to the event. The information from these resources was either used to create the instance or is provided to help with its interpretation. This extension should not be used if more specific inline elements or extensions are available.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Condition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Supporting Information",
        "definition" : "This extension refers other resources from the patient record that may be relevant to the event. The information from these resources was either used to create the instance or is provided to help with its interpretation. This extension should not be used if more specific inline elements or extensions are available."
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/eps/StructureDefinition/supportingInformation"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DocumentReference"]
          }
        ]
      }
    ]
  }
}

```
