# Patient (EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Patient (EPS)**

## Resource Profile: Patient (EPS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:PatientEuEps |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | | |

 
This profile defines how to represent a human Patient in HL7 FHIR for the purpose of this guide. 

**Usages:**

* Use this Profile: [Bundle (EPS)](StructureDefinition-bundle-eu-eps.md)
* Refer to this Profile: [Composition (EPS)](StructureDefinition-composition-eu-eps.md), [DeviceUseStatement (EPS)](StructureDefinition-deviceUseStatement-eu-eps.md), [MedicationDispense (EPS)](StructureDefinition-medicationDispense-eu-eps.md), [MedicationRequest (EPS)](StructureDefinition-medicationRequest-eu-eps.md) and [Observation: country visited (EPS)](StructureDefinition-observation-travel-eu-eps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/patient-eu-eps)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-patient-eu-eps.csv), [Excel](StructureDefinition-patient-eu-eps.xlsx), [Schematron](StructureDefinition-patient-eu-eps.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "patient-eu-eps",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Patient-uv-ips"
    }
  ],
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps",
  "version" : "1.0.0-ci-build",
  "name" : "PatientEuEps",
  "title" : "Patient (EPS)",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile defines how to represent a human Patient in HL7 FHIR for the purpose of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "loinc",
      "uri" : "http://loinc.org",
      "name" : "LOINC code for the element"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Patient",
  "baseDefinition" : "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Patient.name",
        "path" : "Patient.name",
        "constraint" : [
          {
            "key" : "ips-pat-1",
            "severity" : "error",
            "human" : "Patient.name.given, Patient.name.family or Patient.name.text SHALL be present",
            "expression" : "family.exists() or given.exists() or text.exists()",
            "xpath" : "f:given or f:family or f:text",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps"
          }
        ]
      },
      {
        "id" : "Patient.generalPractitioner",
        "path" : "Patient.generalPractitioner",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core"
            ]
          }
        ]
      }
    ]
  }
}

```
