# Consent (Advance Directives EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Consent (Advance Directives EPS)**

## Resource Profile: Consent (Advance Directives EPS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/consent-eu-eps | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:ConsentEuEps |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | | |

 
This profile constrains the Consent resource for the purpose representing Advance Directives for the scope of this guide. 

**Usages:**

* Refer to this Profile: [Composition (EPS)](StructureDefinition-composition-eu-eps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/consent-eu-eps)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-consent-eu-eps.csv), [Excel](StructureDefinition-consent-eu-eps.xlsx), [Schematron](StructureDefinition-consent-eu-eps.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "consent-eu-eps",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/consent-eu-eps",
  "version" : "1.0.0-ci-build",
  "name" : "ConsentEuEps",
  "title" : "Consent (Advance Directives EPS)",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile constrains the Consent resource for the purpose representing Advance Directives for the scope of this guide.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Consent",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Consent",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Consent",
        "path" : "Consent"
      },
      {
        "id" : "Consent.extension",
        "path" : "Consent.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Consent.extension:note",
        "path" : "Consent.extension",
        "sliceName" : "note",
        "short" : "Comment",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Consent.extension:relatedCondition",
        "path" : "Consent.extension",
        "sliceName" : "relatedCondition",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.eu/fhir/StructureDefinition/consent-relatedCondition"
            ]
          }
        ]
      },
      {
        "id" : "Consent.extension:relatedCondition.value[x]",
        "path" : "Consent.extension.value[x]",
        "short" : "Related conditions"
      },
      {
        "id" : "Consent.scope",
        "path" : "Consent.scope",
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/consentscope",
              "code" : "adr"
            }
          ]
        }
      },
      {
        "id" : "Consent.category",
        "path" : "Consent.category",
        "short" : "Living will type"
      },
      {
        "id" : "Consent.dateTime",
        "path" : "Consent.dateTime",
        "short" : "Living will date and time"
      },
      {
        "id" : "Consent.source[x]",
        "path" : "Consent.source[x]",
        "short" : "Living will document"
      }
    ]
  }
}

```
