# IPS to EPS Problem Comparison - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **IPS to EPS Problem Comparison**

## IPS to EPS Problem Comparison

# ISO 27269 — EU Patient Summary — Problems Mapping

### ISO 27269 → EU Patient Summary — Problems

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Element | Conf. | Relation | Element | Notes |
| **Problems content status** | C | Equivalent | **section.emptyReason** | Same purpose; EU PS uses the IPS FHIR representation with`emptyReason`. |
| **Problems** | C | Equivalent | **EHDSCondition (list)** | Represents the list of problem/condition entries. |
| **Problem** | M | Equivalent | **EHDSCondition** | Core entry element; identical clinical concept. |
| Problem type | RK | source-is-narrower-than-target | category |  |
| Problem description | R | Not represented | ----- | No dedicated free-text description in EHDSCondition; but realized in the EU Core Condition profile. |
| Diagnosis | RK | equivalent | problem | Covered by Problem type (problem). |
| Severity | O | Equivalent | severity | Severity of the problem. |
| Onset date | RK | Equivalent | onsetDate | When the problem started. |
| Problem status | O | Equivalent | problemStatus | Active/resolved, etc. |
| Specialist contact | O | Equivalent | specialistContact | Health Professional related to the problem as preferred contact. |

### EU Patient Summary (EHDS Model) → ISO 27269 — Problems

| | | | |
| :--- | :--- | :--- | :--- |
| Element | Relation | Element | Notes |
| **EHDSCondition** | Equivalent | **Problem** | Core entry alignment. |
| **header** | Partial | — | Administrative header (subject, authoring, status, etc.) not part of ISO 27269 clinical section content. |
| header.subject | Not represented | — | Patient identification handled elsewhere in ISO 27269 Document Header. |
| header.identifier | Not represented | — |  |
| header.authorship / author[x] / datetime | Not represented | — | Authorship metadata; ISO 27269 section does not define this. |
| header.lastUpdate | Not represented | — | Technical metadata. |
| header.status / statusReason | Not represented | — |  |
| header.language | Not represented | — | Resource-level attributes not defined in ISO section. |
| **problem** | Equivalent | **Problem code** | Coded problem. |
| **onsetDate** | Equivalent | **Onset date** | Start of the problem. |
| **endDate** | Equivalent | **Abatement date** | Resolution time. |
| **category** | Equivalent | **Clinical status** | Active/resolved, etc. |
| **problemStatus** | Equivalent | **Clinical status** | Active/resolved, etc. |
| **resolutionCircumstances** | Not represented | — | Reason for resolution not modeled in ISO Problems. |
| **severity** | Equivalent | **Severity** | Severity coding. |
| **anatomicLocation** | Equivalent | **Body site** | Anatomical focus. |
| **stage** | Not represented | — | Staging/grading not captured in ISO Problems. |
| **diagnosisAssertionStatus** | Not represented | — | Verification/assertion status not present in ISO Problems. |
| **asserter** | Not represented | — | Asserter not listed in ISO Problems. |
| **assertedDate** | Not represented | — | Diagnosis assertion date not present in ISO Problems. |
| **specialistContact** | Equivalent | **Specialist contact** | Health Professional related to the problem. |
| **externalResource** | Not represented | — | External links not present in ISO Problems. |

