# IPS to EPS Medication Comparison - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **IPS to EPS Medication Comparison**

## IPS to EPS Medication Comparison

# ISO 27269 — EU Patient Summary — Medications Mapping

### ISO 27269 → EU Patient Summary — Medications

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Element | Conf. | Relation | Element | Notes |
| **Medication Summary content status** | C | Equivalent | **section.emptyReason** | Same purpose; EU PS follows the IPS FHIR representation with`emptyReason`. |
| **Medication Summary** | C | Equivalent | **medications (list)** | Represents the list of medication statements. In the Patient Summary model is the list of`medicationTreatment`in the`medicationSummary`section |
| **Medication/Statement** | M | Equivalent | **medicationTreatment** | It is represented by the EHDSMedicationStatement model. |
| Medication code or reference | R | source-is-broader-than-target | medication | The model makes explicit only the reference to the EHDSMedicationStatement. |
| Status | R | Equivalent | status | EHDSMedicationStatement model |
| Effective period/date | O | Equivalent | periodOfUse | Period when patient took, is taking or is expected to take the medication |
| Reason | O | Equivalent | medicationReason / medicationReasonText | Reason for the use of the medication |
| Dosage instructions | O | Equivalent | dosageInstructions | Details of how medication is/was taken or should be taken |

### EU Patient Summary (EHDS Model) → ISO 27269 — Medications

| | | | |
| :--- | :--- | :--- | :--- |
| Element | Relation | Element | Notes |
| **section.emptyReason** | Equivalent | **Medication Summary content status** | Indicates why no medications are present. |
| **MedicationStatement** | Equivalent | **Medication/Statement** | Core entry alignment. |
| **medication[x]** | Equivalent | **Medication code or reference** | Code or Medication reference. |
| **status** | Equivalent | **Status** | Medication status. |
| **effective[x]** | Equivalent | **Effective period/date** | When taken. |
| **reasonCode / reasonReference** | Equivalent | **Reason** | Clinical justification. |
| **dosage** | Equivalent | **Dosage instructions** | Dosage details. |

