# IPS to EPS Medical Devices Comparison - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **IPS to EPS Medical Devices Comparison**

## IPS to EPS Medical Devices Comparison

# ISO 27269 — EU Patient Summary — Medical Devices and Implants Mapping

### ISO 27269 → EU Patient Summary — Medical Devices and Implants

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Element | Conf. | Relation | Element | Notes |
| **Medical Devices content status** | C | Equivalent | **section.emptyReason** | Same purpose; EU PS follows the IPS FHIR representation with`emptyReason`. |
| **Medical devices and implants** | C | Equivalent | **devices (list)** | Represents devices relevant to the patient story (primarily implants). |
| **Device** | M | Equivalent | **Device** | Core entry element for the implantable or other relevant device. |
| Identifier / UDI | RK | Equivalent | udiCarrier / identifier | Unique device identification or business identifiers. |
| Type | R | Equivalent | type | Device type (coded). |
| Status | RK | Equivalent | status | Active/inactive/entered-in-error etc. |
| Manufactured/lot | O | Equivalent | lotNumber / manufacturer | Lot/batch and manufacturer. |
| Implantation / explantation | O | Equivalent | note / extension | Dates/notes where recorded (implementation-specific). |

### EU Patient Summary (EHDS Model) → ISO 27269 — Medical Devices and Implants

| | | | |
| :--- | :--- | :--- | :--- |
| Element | Relation | Element | Notes |
| **section.emptyReason** | Equivalent | **Medical Devices content status** | Indicates why no devices are present. |
| **Device** | Equivalent | **Device** | Core entry alignment. |
| **udiCarrier / identifier** | Equivalent | **Identifier / UDI** | Identifiers. |
| **type** | Equivalent | **Type** | Device type. |
| **status** | Equivalent | **Status** | Lifecycle status. |
| **lotNumber / manufacturer** | Equivalent | **Manufactured/lot** | Manufacturing details. |

