# IPS to EPS Advance Directives Comparison - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **IPS to EPS Advance Directives Comparison**

## IPS to EPS Advance Directives Comparison

# ISO 27269 — EU Patient Summary — Advance Directives Mapping

### ISO 27269 → EU Patient Summary — Advance Directives

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Element | Conf. | Relation | Element | Notes |
| **Advance Directives content status** | C | Equivalent | **section.emptyReason** | Same purpose; EU PS follows the IPS FHIR representation with`emptyReason`. |
| **Advance Directives** | C | Equivalent | **advanceDirectives (list)** | Represents the list of advance directive statements. |
| **Directive** | M | Equivalent | **Consent** | Advance directive typically represented as a Consent resource. |
| Status | R | Equivalent | status | Current state of the directive (active, inactive, etc.). |
| Scope / category | R | Equivalent | scope / category | General scope and classification. |
| Directive code | RK | Equivalent | provision.code | Codes indicating types of directives (e.g., resuscitation preferences). |
| Decision/conditions | O | Equivalent | provision.type / provision.period / provision.actor | Allow/deny, applicable period, actors covered. |
| Supporting document | O | Equivalent | sourceAttachment / sourceReference | Attached document or reference to the directive document. |

### EU Patient Summary (EHDS Model) → ISO 27269 — Advance Directives

| | | | |
| :--- | :--- | :--- | :--- |
| Element | Relation | Element | Notes |
| **section.emptyReason** | Equivalent | **Advance Directives content status** | Indicates why no advance directives are present. |
| **Consent** | Equivalent | **Directive** | Core entry alignment. |
| **status** | Equivalent | **Status** | Lifecycle state. |
| **scope / category** | Equivalent | **Scope / category** | Classification. |
| **provision.code** | Equivalent | **Directive code** | Directive type. |
| **provision.type / period / actor** | Equivalent | **Decision/conditions** | Allow/deny, period, actors. |
| **sourceAttachment / sourceReference** | Equivalent | **Supporting document** | Document or reference. |

