# Artifacts Summary - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### European Patient Summary 

European Patient Summary entry profiles.

| | |
| :--- | :--- |
| [Bundle (EPS)](StructureDefinition-bundle-eu-eps.md) | Clinical document used to represent a Patient Summary for the scope of this project. |
| [Composition (EPS)](StructureDefinition-composition-eu-eps.md) | Clinical document used to represent a Patient Summary for the scope of this project. |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Consent (Advance Directives EPS)](StructureDefinition-consent-eu-eps.md) | This profile constrains the Consent resource for the purpose representing Advance Directives for the scope of this guide. |
| [Device (EPS)](StructureDefinition-device-eu-eps.md) | This profile represents the constraints applied to the Device resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. |
| [DeviceUseStatement (EPS)](StructureDefinition-deviceUseStatement-eu-eps.md) | This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. |
| [MedicationAdministration (EPS)](StructureDefinition-medicationAdministration-eu-eps.md) | This profile constrains the MedicationAdministration resource for the purpose of this guide, adapted from the MPD work. |
| [MedicationDispense (EPS)](StructureDefinition-medicationDispense-eu-eps.md) | This profile constrains the MedicationDispense resource for the purpose of this guide, adapted from the MPD work. |
| [MedicationRequest (EPS)](StructureDefinition-medicationRequest-eu-eps.md) | This profile constrains the MedicationRequest resource for the purpose of this guide, adapted from the MPD work. |
| [Observation: country visited (EPS)](StructureDefinition-observation-travel-eu-eps.md) | This profile sets minimum expectations for the Observation resource to record, search, and fetch travel history. |
| [Patient (EPS)](StructureDefinition-patient-eu-eps.md) | This profile defines how to represent a human Patient in HL7 FHIR for the purpose of this guide. |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Condition Status Reason](StructureDefinition-condition-statusReason.md) | This extension describe the reasons for the condition status, e.g. how this condition has been resolved |
| [Immunization AdministeredProduct](StructureDefinition-immunization-administeredProduct.md) | This extension references the Medication administered during the vaccination. It simulates the beahviour of the reference part of the administeredProduct R5 element |
| [Supporting Information](StructureDefinition-supportingInformation.md) | This extension refers other resources from the patient record that may be relevant to the event. The information from these resources was either used to create the instance or is provided to help with its interpretation. This extension should not be used if more specific inline elements or extensions are available. |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [Severity](ValueSet-eHDSISeverity.md) | The Value Set is used for all Problems and Allergies in the Patient Summary to indicate the severity of the problem (or Allergy) |

