# DeviceUseStatement (EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **DeviceUseStatement (EPS)**

## Resource Profile: DeviceUseStatement (EPS) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/deviceUseStatement-eu-eps | *Version*:1.0.0-ci-build |
| Draft as of 2025-12-26 | *Computable Name*:DeviceUseStatementEuEps |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | |

 
This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. 

**Usages:**

* Use this Profile: [Bundle (EPS)](StructureDefinition-bundle-eu-eps.md)
* Refer to this Profile: [Composition (EPS)](StructureDefinition-composition-eu-eps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/deviceUseStatement-eu-eps)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-deviceUseStatement-eu-eps.csv), [Excel](StructureDefinition-deviceUseStatement-eu-eps.xlsx), [Schematron](StructureDefinition-deviceUseStatement-eu-eps.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "deviceUseStatement-eu-eps",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/DeviceUseStatement-uv-ips"
    }
  ],
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/deviceUseStatement-eu-eps",
  "version" : "1.0.0-ci-build",
  "name" : "DeviceUseStatementEuEps",
  "title" : "DeviceUseStatement (EPS)",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the DeviceUseStatement resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "DeviceUseStatement",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "DeviceUseStatement.text",
        "path" : "DeviceUseStatement.text",
        "short" : "Device usage description"
      },
      {
        "id" : "DeviceUseStatement.subject",
        "path" : "DeviceUseStatement.subject",
        "definition" : "The patient using the device.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps"]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.subject.reference",
        "path" : "DeviceUseStatement.subject.reference",
        "min" : 1
      },
      {
        "id" : "DeviceUseStatement.timing[x]",
        "path" : "DeviceUseStatement.timing[x]",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "$this"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "min" : 1,
        "type" : [
          {
            "code" : "Period"
          },
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.timing[x]:timingDateTime",
        "path" : "DeviceUseStatement.timing[x]",
        "sliceName" : "timingDateTime",
        "short" : "When device is used (dateTime)",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "dateTime"
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.device",
        "path" : "DeviceUseStatement.device",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps"]
          }
        ]
      },
      {
        "id" : "DeviceUseStatement.reasonCode",
        "path" : "DeviceUseStatement.reasonCode",
        "short" : "Why is used (code)"
      },
      {
        "id" : "DeviceUseStatement.reasonReference",
        "path" : "DeviceUseStatement.reasonReference",
        "short" : "Why is used (details)"
      },
      {
        "id" : "DeviceUseStatement.bodySite",
        "path" : "DeviceUseStatement.bodySite",
        "binding" : {
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/ValueSet/body-site"
        }
      }
    ]
  }
}

```
