# Condition Status Reason - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Condition Status Reason**

## Extension: Condition Status Reason 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/condition-statusReason | *Version*:1.0.0-ci-build |
| Draft as of 2025-12-26 | *Computable Name*:ConditionStatusReason |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | |

This extension describe the reasons for the condition status, e.g. how this condition has been resolved

**Context of Use**

**Usage info**

**Usages:**

* This Extension is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/condition-statusReason)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-condition-statusReason.csv), [Excel](StructureDefinition-condition-statusReason.xlsx), [Schematron](StructureDefinition-condition-statusReason.sch) 

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "condition-statusReason",
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/condition-statusReason",
  "version" : "1.0.0-ci-build",
  "name" : "ConditionStatusReason",
  "title" : "Condition Status Reason",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This extension describe the reasons for the condition status, e.g. how this condition has been resolved",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "Condition"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension",
        "short" : "Condition Status Reason",
        "definition" : "This extension describe the reasons for the condition status, e.g. how this condition has been resolved"
      },
      {
        "id" : "Extension.extension:concept",
        "path" : "Extension.extension",
        "sliceName" : "concept",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:concept.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:concept.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "concept"
      },
      {
        "id" : "Extension.extension:concept.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "Extension.extension:reference",
        "path" : "Extension.extension",
        "sliceName" : "reference",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Extension.extension:reference.extension",
        "path" : "Extension.extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.extension:reference.url",
        "path" : "Extension.extension.url",
        "fixedUri" : "reference"
      },
      {
        "id" : "Extension.extension:reference.value[x]",
        "path" : "Extension.extension.value[x]",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
              "http://hl7.org/fhir/StructureDefinition/CarePlan",
              "http://hl7.org/fhir/StructureDefinition/MedicationAdministration"
            ]
          }
        ]
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "http://hl7.eu/fhir/eps/StructureDefinition/condition-statusReason"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "max" : "0"
      }
    ]
  }
}

```
