# Composition (EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Composition (EPS)**

## Resource Profile: Composition (EPS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:CompositionEuEps |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | | |

 
Clinical document used to represent a Patient Summary for the scope of this project. 

**Usages:**

* Use this Profile: [Bundle (EPS)](StructureDefinition-bundle-eu-eps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/composition-eu-eps)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-composition-eu-eps.csv), [Excel](StructureDefinition-composition-eu-eps.xlsx), [Schematron](StructureDefinition-composition-eu-eps.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "composition-eu-eps",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Composition-uv-ips"
    }
  ],
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps",
  "version" : "1.0.0-ci-build",
  "name" : "CompositionEuEps",
  "title" : "Composition (EPS)",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Patient Summary for the scope of this project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "fhirdocumentreference",
      "uri" : "http://hl7.org/fhir/documentreference",
      "name" : "FHIR DocumentReference"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Composition",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Composition",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Composition",
        "path" : "Composition",
        "short" : "Patient Summary composition",
        "definition" : "Patient Summary composition. \r\nA composition is a set of healthcare-related information that is assembled together into a single logical document that provides a single coherent statement of meaning, establishes its own context and that has clinical attestation with regard to who is making the statement. \r\nWhile a Composition defines the structure, it does not actually contain the content: rather the full content of a document is contained in a Bundle, of which the Composition is the first resource contained."
      },
      {
        "id" : "Composition.extension",
        "path" : "Composition.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.extension:version",
        "path" : "Composition.extension",
        "sliceName" : "version",
        "short" : "Business version",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/5.0/StructureDefinition/extension-Composition.version"
            ]
          }
        ]
      },
      {
        "id" : "Composition.identifier",
        "path" : "Composition.identifier",
        "short" : "PS business identifier"
      },
      {
        "id" : "Composition.status",
        "path" : "Composition.status",
        "short" : "PS status"
      },
      {
        "id" : "Composition.type",
        "path" : "Composition.type",
        "short" : "Kind of composition (\"Patient Summary\")",
        "definition" : "Specifies that this composition refer to a Patient Summary",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Composition.subject",
        "path" : "Composition.subject",
        "definition" : "Who or what the composition is about. \r\nIn general a composition can be about a person, (patient or healthcare practitioner), a device (e.g. a machine) or even a group of subjects (such as a document about a herd of livestock, or a set of patients that share a common exposure).\r\nFor the PS the subject is always the patient.",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps"]
          }
        ]
      },
      {
        "id" : "Composition.date",
        "path" : "Composition.date",
        "short" : "PS date"
      },
      {
        "id" : "Composition.author",
        "path" : "Composition.author",
        "short" : "Who and/or what authored the Patient Summary",
        "definition" : "Identifies who is responsible for the information in the Patient Summary, not necessarily who typed it in.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Composition.title",
        "path" : "Composition.title",
        "short" : "Patient Summary",
        "definition" : "Official human-readable label for the composition.\r\n\r\nFor this document should be \"Patient Summary\" or any equivalent translation"
      },
      {
        "id" : "Composition.attester.mode",
        "path" : "Composition.attester.mode",
        "short" : "The type of attestation"
      },
      {
        "id" : "Composition.attester.party",
        "path" : "Composition.attester.party",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core",
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core",
              "http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps",
              "http://hl7.org/fhir/StructureDefinition/RelatedPerson"
            ]
          }
        ]
      },
      {
        "id" : "Composition.custodian",
        "path" : "Composition.custodian",
        "short" : "Custodian of the Patient Summary",
        "definition" : "Identifies the organization that is responsible for ongoing maintenance of the Patient Summary, and ensures that it remains available for access by other parties.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/organization-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section",
        "path" : "Composition.section",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "code"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Sections composing the IPS",
        "definition" : "The root of the sections that make up the IPS composition.",
        "min" : 3
      },
      {
        "id" : "Composition.section.extension",
        "path" : "Composition.section.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        }
      },
      {
        "id" : "Composition.section.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section.title",
        "path" : "Composition.section.title",
        "min" : 1
      },
      {
        "id" : "Composition.section.code",
        "path" : "Composition.section.code",
        "min" : 1
      },
      {
        "id" : "Composition.section.text",
        "path" : "Composition.section.text",
        "min" : 1
      },
      {
        "id" : "Composition.section.section",
        "path" : "Composition.section.section",
        "max" : "0"
      },
      {
        "id" : "Composition.section:sectionProblems",
        "path" : "Composition.section",
        "sliceName" : "sectionProblems",
        "short" : "EPS Problems Section",
        "definition" : "The EPS problem section lists and describes clinical problems or conditions currently being monitored for the patient.",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProblems.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProblems.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11450-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionProblems.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Clinical problems or conditions currently being monitored for the patient.",
        "definition" : "It lists and describes clinical problems or conditions currently being monitored for the patient. This entry shall be used to document that no information about problems is available, or that no relevant problems are known.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProblems.entry:problem",
        "path" : "Composition.section.entry",
        "sliceName" : "problem",
        "definition" : "It lists and describes clinical problems or conditions currently being monitored for the patient.  This entry shall be used to document that no information about problems is available, or that no relevant problems are known.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/condition-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies",
        "path" : "Composition.section",
        "sliceName" : "sectionAllergies",
        "short" : "EPS Allergies and Intolerances Section",
        "definition" : "This section documents the relevant allergies or intolerances for that patient, describing the kind of reaction - e.g. rash, anaphylaxis,.. - preferably the agents that cause it; and optionally the criticality and the certainty of the allergy. At a minimum, it should list currently active and any relevant historical allergies and adverse reactions. If no information about allergies is available, or if no allergies are known this should be clearly documented in the section.",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "48765-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAllergies.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "allergyOrIntolerance",
        "definition" : "allergyOrIntolerance",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAllergies.entry:allergyOrIntolerance",
        "path" : "Composition.section.entry",
        "sliceName" : "allergyOrIntolerance",
        "short" : "Relevant allergies or intolerances for that patient.",
        "definition" : "It lists the relevant allergies or intolerances for that patient, describing the kind of reaction - e.g. rash, anaphylaxis,.. - preferably the agents that cause it; and optionally the criticality and the certainty of the allergy. At a minimum, it should list currently active and any relevant historical allergies and adverse reactions. If no information about allergies is available, or if no allergies are known this should be clearly documented in the section.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/allergyIntolerance-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedications",
        "path" : "Composition.section",
        "sliceName" : "sectionMedications",
        "short" : "EPS Medication Summary Section",
        "definition" : "The medication summary section contains a description of the patient's medications relevant for the scope of the patient summary. The actual content could depend on the jurisdiction, it could report:\n        * the currently active medications;\n        * the current and past medications considered relevant by the authoring GP;\n        * the patient prescriptions or dispensations automatically extracted by a regional or a national EHR.\n      In those cases medications are documented in the Patient Summary as medication statements or medication requests. This section requires either an entry indicating the subject is known not to be on any relevant medication; either an entry indicating that no information is available about medications; or entries summarizing the subject's relevant medications.",
        "min" : 1,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedications.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedications.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10160-0"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionMedications.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "medicationStatementOrRequest",
        "definition" : "medicationStatementOrRequest",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/medicationStatement-eu-core",
              "http://hl7.eu/fhir/eps/StructureDefinition/medicationRequest-eu-eps",
              "http://hl7.eu/fhir/eps/StructureDefinition/medicationAdministration-eu-eps",
              "http://hl7.eu/fhir/eps/StructureDefinition/medicationDispense-eu-eps"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedications.entry:medicationStatementOrRequest",
        "path" : "Composition.section.entry",
        "sliceName" : "medicationStatementOrRequest",
        "short" : "Medications relevant for the scope of the patient summary",
        "definition" : "This list the medications relevant for the scope of the patient summary or it is used to indicate that the subject is known not to be on any relevant medication; either that no information is available about medications.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/medicationStatement-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionImmunizations",
        "path" : "Composition.section",
        "sliceName" : "sectionImmunizations",
        "short" : "EPS Immunizations Section",
        "definition" : "The Immunizations Section defines a patient's current immunization status and pertinent immunization history. The primary use case for the Immunization Section is to enable communication of a patient's immunization status. The section includes the current immunization status, and may contain the entire immunization history that is relevant to the period of time being summarized.",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionImmunizations.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionImmunizations.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11369-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionImmunizations.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Patient's immunization status and pertinent history.",
        "definition" : "It defines the patient's current immunization status and pertinent immunization history.\r\nThe primary use case for the Immunization Section is to enable communication of a patient's immunization status.\r\nIt may contain the entire immunization history that is relevant to the period of time being summarized. This entry shall be used to document that no information about immunizations is available, or that no immunizations are known.",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Immunization",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionImmunizations.entry:immunization",
        "path" : "Composition.section.entry",
        "sliceName" : "immunization",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/immunization-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionResults",
        "path" : "Composition.section",
        "sliceName" : "sectionResults",
        "short" : "EPS Results Section",
        "definition" : "his section assembles relevant observation results collected on the patient or produced on in-vitro biologic specimens collected from the patient. Some of these results may be laboratory results, others may be anatomic pathology results, others, radiology results, and others, clinical results.",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionResults.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionResults.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "30954-2"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionResults.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "EPS Results entry",
        "definition" : "EPS Results entry slice",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/DiagnosticReport",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionResults.entry:results-observation-laboratory-pathology",
        "path" : "Composition.section.entry",
        "sliceName" : "results-observation-laboratory-pathology",
        "short" : "Laboratory and pathology results",
        "definition" : "Laboratory or pathology in vitro diagnostic test or panel/study. In case of a panel or multiple-observation study, the results of the panel or study appear as sub-observations. In this case this top-level Observation acts as a grouper of all the observations belonging to the panel or study.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-laboratory-pathology-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionResults.entry:results-observation-radiology",
        "path" : "Composition.section.entry",
        "sliceName" : "results-observation-radiology",
        "short" : "Radiology results",
        "definition" : "This observation may represent the conclusions of a diagnostic procedure such a Chest RX, or it may group the set of results produced by that single or multi-modality procedure.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-results-radiology-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionResults.entry:results-diagnosticReport",
        "path" : "Composition.section.entry",
        "sliceName" : "results-diagnosticReport",
        "short" : "EPS DiagnosticReport",
        "definition" : "DiagnosticReport resource to represent diagnostic test and procedure reports in a patient summary",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/diagnosticReport-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProceduresHx",
        "path" : "Composition.section",
        "sliceName" : "sectionProceduresHx",
        "short" : "EPS History of Procedures Section",
        "definition" : "The History of Procedures Section contains a description of the patient past procedures that are pertinent to the scope of this document. Procedures may refer for example to:\r\n\n      1. Invasive Diagnostic procedure:e.g. Cardiac catheterization; (the results of these procedure are documented in the results section)\r\n\n      2. Therapeutic procedure: e.g. dialysis;\r\n\n      3. Surgical procedure: e.g. appendectomy\r\n",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProceduresHx.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProceduresHx.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47519-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionProceduresHx.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Slice on procedure",
        "definition" : "Slice on procedure",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionProceduresHx.entry:procedure",
        "path" : "Composition.section.entry",
        "sliceName" : "procedure",
        "short" : "Patient past procedures pertinent to the scope of this document.",
        "definition" : "It lists the patient past procedures that are pertinent to the scope of this document. Procedures may refer for example to:\r\n\n      1. Invasive Diagnostic procedure:e.g. Cardiac catheterization; (the results of these procedure are documented in the results section)\r\n\n      2. Therapeutic procedure: e.g. dialysis;\r\n\n      3. Surgical procedure: e.g. appendectomy\r\n",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/procedure-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedicalDevices",
        "path" : "Composition.section",
        "sliceName" : "sectionMedicalDevices",
        "short" : "EPS Medical Devices Section",
        "definition" : "The medical devices section contains narrative text and coded entries describing the patient history of medical device use.",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "46264-8"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "EPS Medical Device entry",
        "definition" : "EPS Medical Devices entry slice",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/DeviceUseStatement",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionMedicalDevices.entry:deviceStatement",
        "path" : "Composition.section.entry",
        "sliceName" : "deviceStatement",
        "short" : "Patient history of medical device use",
        "definition" : "It describes the patient history of medical device use. This entry shall be used to document that no information about medical device use is available, or that no relevant medical device use is known.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/eps/StructureDefinition/deviceUseStatement-eu-eps"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives",
        "path" : "Composition.section",
        "sliceName" : "sectionAdvanceDirectives",
        "short" : "Advance Directives Section",
        "definition" : "The advance directives section contains a narrative description of patient's advance directive.",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "42348-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAdvanceDirectives.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/eps/StructureDefinition/consent-eu-eps",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert",
        "path" : "Composition.section",
        "sliceName" : "sectionAlert",
        "short" : "EPS Alerts Section",
        "definition" : "The alerts section flags potential concerns and/or dangers to/from the patient and may also include obstacles to care.",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "104605-1"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionAlert.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "EPS Alerts entry",
        "definition" : "EPS Alerts entry slice",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Flag",
              "http://hl7.org/fhir/StructureDefinition/DocumentReference"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionAlert.entry:flag",
        "path" : "Composition.section.entry",
        "sliceName" : "flag",
        "short" : "Alert information",
        "definition" : "Contains alert information to be communicated. May optionally reference other resources in IPS.lags",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.eu/fhir/base/StructureDefinition/flag-eu-core"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus",
        "path" : "Composition.section",
        "sliceName" : "sectionFunctionalStatus",
        "short" : "Functional Status",
        "definition" : "The functional status section contains a narrative description of the patient's functional status. It includes entries for functional status  as described in related profiles",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "47420-5"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Functional Status short",
        "definition" : "Functional Status Description"
      },
      {
        "id" : "Composition.section:sectionFunctionalStatus.entry:functionalStatus",
        "path" : "Composition.section.entry",
        "sliceName" : "functionalStatus",
        "short" : "SHORT functionalStatus",
        "definition" : "DESCR functionalStatus",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/condition-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPastProblems",
        "path" : "Composition.section",
        "sliceName" : "sectionPastProblems",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPregnancyHx",
        "path" : "Composition.section",
        "sliceName" : "sectionPregnancyHx",
        "short" : "Pregnancy History",
        "definition" : "The pregnancy history section contains a narrative description of the patient's pregnancy history. It includes entries for pregnancy history as described in related profiles",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPregnancyHx.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPregnancyHx.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10162-6"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionPregnancyHx.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Pregnancy History short",
        "definition" : "Pregnancy History Description"
      },
      {
        "id" : "Composition.section:sectionPregnancyHx.entry:pregnancyStatus",
        "path" : "Composition.section.entry",
        "sliceName" : "pregnancyStatus",
        "short" : "Pregnancy status",
        "definition" : "DESCR Pregnancy status",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-status-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPregnancyHx.entry:pregnancyOutcome",
        "path" : "Composition.section.entry",
        "sliceName" : "pregnancyOutcome",
        "short" : "Pregnancy outcome",
        "definition" : "DESCR Pregnancy outcome",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/Observation-pregnancy-outcome-uv-ips"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientStory",
        "path" : "Composition.section",
        "sliceName" : "sectionPatientStory",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionPlanOfCare",
        "path" : "Composition.section",
        "sliceName" : "sectionPlanOfCare",
        "short" : "Health Maintenance Care Plan",
        "definition" : "The health maintenance care plan section contains a description of the expectations for wellness care including proposals, goals, and order requests for monitoring, tracking, or improving the lifetime condition of the patient with goals of educating the patient on how to reduce the modifiable risks of the patient\\’s genetic, behavioral, and environmental pre-conditions and otherwise optimizing lifetime outcomes.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionSocialHistory",
        "path" : "Composition.section",
        "sliceName" : "sectionSocialHistory",
        "short" : "Social History",
        "definition" : "The social history section contains a narrative description of the person\\’s beliefs, home life, community life, work life, hobbies, and risky habits. It includes Social History Observations.",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "Composition.section:sectionVitalSigns",
        "path" : "Composition.section",
        "sliceName" : "sectionVitalSigns",
        "short" : "Vital Signs",
        "definition" : "The vital signs section contains a narrative description of the patient's vital signs. It includes entries for vital sign measurements as described in related profiles",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionVitalSigns.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionVitalSigns.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "8716-3"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionVitalSigns.entry",
        "path" : "Composition.section.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resolve()"
            }
          ],
          "ordered" : false,
          "rules" : "open"
        },
        "short" : "Vital Signs short",
        "definition" : "Vital Signs Description"
      },
      {
        "id" : "Composition.section:sectionVitalSigns.entry:vitalSign",
        "path" : "Composition.section.entry",
        "sliceName" : "vitalSign",
        "short" : "SHORT vitalSign",
        "definition" : "DESCR vitalSign",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/vitalsigns"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionTravelHx",
        "path" : "Composition.section",
        "sliceName" : "sectionTravelHx",
        "short" : "Travel History Section",
        "definition" : "This Section describes the travel history relevant for the Patient Summary, e.g.recent travel in a region of high prevalence of a specific infectious disease like Malaria",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionTravelHx.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionTravelHx.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "10182-4"
            }
          ]
        }
      },
      {
        "id" : "Composition.section:sectionTravelHx.entry",
        "path" : "Composition.section.entry",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/hdr/StructureDefinition/observation-travel-eu-hdr"
            ]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx",
        "path" : "Composition.section",
        "sliceName" : "sectionPatientHx",
        "short" : "Patient History Section",
        "definition" : "This section may provide both synthetic anamnesis ,e.g. description of phases of the pathology as a chronological summary of clustered clinical information, and anecdotal evidence that clinicians can collect from the patient, and can read in a narrative form.",
        "min" : 0,
        "max" : "1",
        "constraint" : [
          {
            "key" : "ips-comp-1",
            "severity" : "error",
            "human" : "Either section.entry or emptyReason are present",
            "expression" : "(entry.reference.exists() or emptyReason.exists())",
            "xpath" : "(/f:entry.reference and not /f:emptyReason) or (not(/f:emptyReason) and /f:entry.reference)",
            "source" : "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.extension:section-note",
        "path" : "Composition.section.extension",
        "sliceName" : "section-note",
        "short" : "Additional notes that apply to the section (but not to specific resource).",
        "definition" : "Additional notes that apply to the section (but not to specific resource).",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : ["http://hl7.org/fhir/StructureDefinition/note"]
          }
        ]
      },
      {
        "id" : "Composition.section:sectionPatientHx.code",
        "path" : "Composition.section.code",
        "type" : [
          {
            "code" : "CodeableConcept",
            "profile" : [
              "http://hl7.org/fhir/uv/ips/StructureDefinition/CodeableConcept-uv-ips"
            ]
          }
        ],
        "patternCodeableConcept" : {
          "coding" : [
            {
              "system" : "http://loinc.org",
              "code" : "11329-0"
            }
          ]
        }
      }
    ]
  }
}

```
