# EHDSPatientSummary to Composition (EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **EHDSPatientSummary to Composition (EPS)**

## EHDSPatientSummary to Composition (EPS)

# EHDSPatientSummary → Composition (EPS)

**Ongoing alignment:**The Xt-EHR logical models are under active revision and continuous refinement. Updates from Xt-EHR will be progressively incorporated into this Implementation Guide to maintain alignment with the evolving EHDS specifications.

### EHDSPatientSummary → Composition (EPS)

 This page explains how conceptual elements from the EHDSPatientSummary logical model are expressed in the corresponding FHIR CompositionEuEps profile used by this Implementation Guide. 

**Mapping Context**
*  **Source logical model:** [EHDSPatientSummary](https://www.xt-ehr.eu/fhir/models/StructureDefinition-EHDSPatientSummary.html) 
*  **Target FHIR profile:** [CompositionEuEps](StructureDefinition-composition-eu-eps.md) 

| | | | | | | |
| :--- | :--- | :--- | :--- | :--- | :--- | :--- |
| Element | Description | Relation | Resource | Element | Description | Notes |
| header | Document header elements. | related-to | Composition | . | Composition-level metadata. | CompositionEuEps constrains cardinalities and section slices for Patient Summary. |
| header.subject | Patient/subject information. | equivalent | Composition | subject | Who or what the composition is about. | Reference to PatientEuEps. |
| header.identifier | Unique identifier of the document. | equivalent | Composition | identifier | Version-independent identifier for the Patient Summary. | Multiple identifiers allowed through profiling; Composition R4 is 0..1. |
| header.identifier | Unique identifier of the document. | equivalent | Bundle | identifier | Persistent identifier for the Patient Summary document bundle. | Represents a specific rendition/version of the document. |
| header.authorship | Resource authoring details. | related-to | Composition | author | Authors of the Patient Summary. | Composition.date captures the authoring timestamp. |
| header.authorship.author[x] | Author(s) by whom the resource was/were authored. | equivalent | Composition | author | Logical authors list. | Reference to Practitioner / PractitionerRole / Organization / Device per profile. |
| header.authorship.datetime | Date and time of authoring/issuing. | equivalent | Composition | date | Composition creation time. |  |
| header.lastUpdate | Date and time of the last update to the resource. | equivalent | Composition | meta.lastUpdated | System-level modification time. | Only applicable when representing the system update instant (YYYY-MM-DDThh:mm:ss.sss+zz:zz). |
| header.status | Status of the resource or document. | equivalent | Composition | status | The workflow/clinical status of this composition. |  |
| header.statusReason[x] | Reason for the current status of the resource. | no-map | Composition |  |  | No native element. |
| header.language | Language of the resource (IETF BCP-47). | equivalent | Composition | language | Language of the narrative. |  |
| header.documentType | Type of document at hand (e.g., LOINC 60591-5 Patient summary document). | equivalent | Composition | type | Kind of composition. |  |
| header.documentTitle | Human readable document title. | equivalent | Composition | title | Official human-readable label. |  |
| header.period | Time of service that is being documented. | related-to | Composition | event.period | Period covered by the composition content. | Map to the primary Composition.event entry. |
| header.version | Business version of the document. | related-to | Composition | extension:version | Document business version. | Use composition.version (R5) or the pre-adopted extension for R4. |
| header.attestation | Document attestation details. | related-to | Composition | attester | Participants responsible for attesting the composition. | Use attester.mode to distinguish assertions. |
| header.attestation.attester | Attester who validated the document. | equivalent | Composition | attester.party | Who attested the composition. |  |
| header.attestation.datetime | Date and time of the approval of the document by Attester. | equivalent | Composition | attester.time | When the composition was attested. | Set attester.mode as appropriate (e.g., professional). |
| header.legalAuthentication | Document legal authentication details. | related-to | Composition | attester | Legal authenticator. | Use attester.mode = "legal". |
| header.legalAuthentication.legalAuthenticator | The person taking responsibility for the medical content of the document. | related-to | Composition | attester.party | Legal authenticator party. | Use attester.mode = "legal". |
| header.legalAuthentication.datetime | Date and time when the document was authorised. | equivalent | Composition | attester.time | When the composition was attested. | Use attester.mode = "legal". |
| header.eventType | Categorisation of the event covered by the document. | related-to | Composition | event.code | Codes describing the event(s) related to the composition. | Clarify whether codes reflect event tags or document classification. |
| header.serviceSpecialty | Additional details about where the content was created (e.g. clinical specialty). | source-is-narrower-than-target | Composition | category | Categorizes the composition. | Service Speciality is out of scope for a Patient Summary. Give feedback to Xt-EHR. |
| header.custodian | Organisation that is in charge of maintaining the document/report. | equivalent | Composition | custodian | Organization responsible for maintenance. | Reference to Organization. |
| header.confidentiality | Level of confidentiality of the document. | equivalent | Composition | confidentiality | As defined by confidentiality codes. | Implicit value is normal. |
| presentedForm | A narrative easy-to-read representation of the full data set (e.g. PDF). | related-to | DocumentReference | content.attachment | Embedded or referenced rendition of the Patient Summary. | Include a DocumentReference in the bundle linked from Composition via event/relatesTo if provided. |
| alerts | Section: Alerts. | equivalent | Composition | section:sectionAlerts | Alert section | Use LOINC 104605-1 |
| alerts.narrative | Narrative content of the section. | equivalent | Composition | section:sectionAlerts.text | Narrative for Alerts section. |  |
| alerts.emptyReason | Reason for absence of data. | equivalent | Composition | section:sectionAlerts.emptyReason | Why no alerts are present. |  |
| alerts.medicalAlert | Description of medical alerts. | equivalent | Composition | section:sectionAlert.entry:flag | Alert entries. | Reference to`FlagEuCore.` |
| allergiesAndIntolerances | Section: Allergies and intolerances. | equivalent | Composition | section:sectionAllergies | Allergy and intolerance section. | Mandatory slice in CompositionEuEps. |
| allergiesAndIntolerances.narrative | Text summary of the content in section. | equivalent | Composition | section:sectionAllergies.text | Narrative for Allergies section. |  |
| allergiesAndIntolerances.allergyIntolerance | List of structured allergies and intolerances. | equivalent | Composition | section:sectionAllergies.entry:allergyOrIntolerance | Allergy intolerance entries. | Reference to AllergyIntoleranceEuCore. |
| allergiesAndIntolerances.emptyReason | Use if no Allergies are listed. | equivalent | Composition | section:sectionAllergies.emptyReason | Reason for missing allergy data. |  |
| problems | Medical problems. | equivalent | Composition | section:sectionProblems | Active problems section. | Use LOINC 11450-4 |
| problems.narrative | Text summary of the content in the section. | equivalent | Composition | section:sectionProblems.text | Narrative for Problems section. |  |
| problems.emptyReason | Reason for absence of data. | equivalent | Composition | section:sectionProblems.emptyReason | Why no problems are listed. |  |
| problems.problems | Health conditions affecting the patient. | equivalent | Composition | section:sectionProblems.entry:problem | Problem entries. | Reference to ConditionEuCore. |
| medicationSummary | Section: Medication Summary. | equivalent | Composition | section:sectionMedications | Medication summary section. | Use LOINC 10160-0 |
| medicationSummary.narrative | Text summary of the content in the section. | equivalent | Composition | section:sectionMedications.text | Narrative for Medication section. |  |
| medicationSummary.emptyReason | Use if no medicines are listed. | equivalent | Composition | section:sectionMedications.emptyReason | Reason for missing medication data. |  |
| medicationSummary.medicationTreatment | Medication treatment/prescription relevant for this patient summary. | equivalent | Composition | section:sectionMedications.entry:medicationStatementOrRequest | Medication entries. | Reference to MedicationStatementEuCore (or MedicationRequest/Administration/Dispense per profile). |
| medicalDevicesAndImplants | Section: Medical devices and implants. | equivalent | Composition | section:sectionMedicalDevices | Medical devices section. | Use LOINC 46264-8 |
| medicalDevicesAndImplants.narrative | Narrative content of the section. | equivalent | Composition | section.text | Narrative for devices and implants. |  |
| medicalDevicesAndImplants.emptyReason | Reason for absence of data. | equivalent | Composition | section.emptyReason | Why no devices are listed. |  |
| medicalDevicesAndImplants.medicalDevice | Implanted and external medical devices. | equivalent | Composition | section:sectionMedicalDevices.entry:deviceStatement | Device use entries. | Reference to DeviceUseStatementEuEps. |
| procedures | Section: Procedures. | equivalent | Composition | section:sectionProceduresHx | Procedures section. | Use LOINC 47519-4 |
| procedures.narrative | Narrative content of the section. | equivalent | Composition | section.text | Narrative for Procedures section. |  |
| procedures.emptyReason | Reason for absence of data. | equivalent | Composition | section.emptyReason | Why no procedures are listed. |  |
| procedures.procedure | List of procedures. | equivalent | Composition | section:sectionProceduresHx.entry:procedure | Procedure entries. | Reference to ProcedureEuCore. |
| vaccination | Section: Vaccination/prophylaxis. | equivalent | Composition | section:sectionImmunizations | Immunizations section. | Use LOINC 11369-6 |
| vaccination.narrative | Narrative content of the section. | equivalent | Composition | section.text | Narrative for Immunizations section. |  |
| vaccination.vaccination | Immunisations given to the patient and their status. | equivalent | Composition | section:sectionImmunizations.entry:immunization | Immunization entries. | Reference to ImmunizationEuCore. |
| functionalStatus | Section: Functional status. | equivalent | Composition | section:sectionFunctionalStatus | Functional status section. | Use LOINC 47420-5 |
| functionalStatus.narrative | Narrative content of the section. | equivalent | Composition | section.text | Narrative for Functional Status section. |  |
| functionalStatus.functionalStatusAssessment | Functional status assessments. | equivalent | Composition | section:sectionFunctionalStatus.entry:functionalStatus | Functional status entries. | Reference to Observation/Condition representing functional status (per profile guidance). |
| socialHistory | Section: Social history. | equivalent | Composition | section:sectionSocialHistory | Social history section. | Uses slice defined in CompositionEuEps. |
| socialHistory.narrative | Narrative content of the section. | equivalent | Composition | section.text | Narrative for Social History section. |  |
| socialHistory.socialHistoryObservation | Social history observations related to health. | equivalent | Composition | section:sectionSocialHistory.entry | Social history entries. | check the target profiles to be used. |
| pregnancyHistory | Section: Pregnancy history. | equivalent | Composition | section:sectionPregnancyHx | Pregnancy history section. | Use LOINC 10162-6 |
| pregnancyHistory.generatedNarrative | Generated text summary of the section. | equivalent | Composition | section.text | Narrative for Pregnancy section. |  |
| pregnancyHistory.currentPregnancyStatus | Current pregnancy status. | equivalent | Composition | section:sectionPregnancyHx.entry:pregnancyStatus | Pregnancy status entry. | Reference to ObservationPregnancyStatusUvIps. |
| pregnancyHistory.previousPregnanciesStatus | Overall status of previous pregnancies. | related-to | Composition | section:sectionPregnancyHx.entry:pregnancyOutcome | Summary of prior pregnancies. | Check target profiles. Use ObservationPregnancyOutcomeUvIps or equivalent summary observation. |
| pregnancyHistory.previousPregnancies | History of previous pregnancies. | equivalent | Composition | section:sectionPregnancyHx.entry:pregnancyOutcome | Pregnancy outcome entries. | Check target profiles. Reference to ObservationPregnancyOutcomeUvIps. |
| travelHistory | Relevant information about the patient's recent travel history. | equivalent | Composition | section:sectionTravelHx | Travel history section. | Uses LOINC 10182-4. MISSING to be added |
| travelHistory.narrative | Text summary of the content in the section. | equivalent | Composition | section.text | Narrative for Travel History section. MISSING to be added |  |
| travelHistory.travelHistory | Travel history for one country. | equivalent | Composition | section:sectionTravelHx.entry | Travel history entries. | Reference to ObservationTravelEuHdr. MISSING to be added |
| patientStory | What the patient believes to be important for the attending clinician to know. | equivalent | Composition | section:sectionPatientHx | Patient story section. | Uses slice defined in CompositionEuEps. check if the propoer loinc code is used and the patient history section is added. |
| patientStory.narrative | Text summary of the content in the section. | equivalent | Composition | section.text | Narrative for Patient Story section. |  |
| advanceDirectives | Section: Advance Directives. | equivalent | Composition | section:sectionAdvanceDirectives | Advance directives section. | Use LOINC 42348-3 |
| advanceDirectives.narrative | Narrative content of the section. | equivalent | Composition | section.text | Narrative for Advance Directives section. |  |
| advanceDirectives.advanceDirective | Provision for healthcare decisions. | equivalent | Composition | section:sectionAdvanceDirectives.entry | Advance directive entries. | Reference to ConsentEuEps or DocumentReference. |
| results | Section: Observation results. | source-is-broader-than-target | Composition | section:sectionResults | Results section. | Slice defined for coded results. CHECK IF THIS MAPS TO BOTH DIANGOSTIC RESULTS AND VITAL SIGNS. Section to be refined |
| results | Section: Observation results. | source-is-broader-than-target | Composition | section:sectionVitalSigns | Vital Signs section. | Slice defined for coded results. CHECK IF THIS MAPS TO BOTH DIANGOSTIC RESULTS AND VITAL SIGNS. Section to be refined |
| results.narrative | Narrative content of the section. | equivalent | Composition | section.text | Narrative for Results section. |  |
| results.resultObservation[x] | Observation results pertaining to the subject of care. | equivalent | Composition | section:sectionResults.entry | Result observation entries. | Reference to Observation. Target profiles to be defined. |
| results.resultObservation[x] | Observation results pertaining to the subject of care. | equivalent | Composition | section:sectionVitalSigns.entry | Result observation entries. | Reference to Observation. Target profiles to be defined. |
| carePlan | Section: Care plans. | equivalent | Composition | section:sectionPlanOfCare | Care plan section. | Slice for plan of care in CompositionEuEps. |
| carePlan.narrative | Narrative containing the plan including proposals, goals, and order requests. | equivalent | Composition | section.text | Narrative for Care Plan section. |  |
| carePlan.carePlanEntry | Describes the intention of how care will be delivered. | equivalent | Composition | section:sectionPlanOfCare.entry | Care plan entries. | taget profile to be defined |

 Return to overview: [EHDS Logical Models → FHIR Profiles](modelmap.md) 

