# IPS to EPS Immunization Comparison - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **IPS to EPS Immunization Comparison**

## IPS to EPS Immunization Comparison

# ISO 27269 — EU Patient Summary — Immunizations Mapping

### ISO 27269 → EU Patient Summary — Immunizations

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Element | Conf. | Relation | Element | Notes |
| **Immunizations content status** | C | Equivalent | **section.emptyReason** | Same purpose; EU PS follows the IPS FHIR representation with`emptyReason`. |
| **Immunizations** | C | Equivalent | **EHDSImmunisation (list)** | List of immunization entries. |
| **Immunization** | R | Equivalent | **EHDSImmunisation** | Label concept of an immunization entry. |
| Vaccine for type of disease | R | Equivalent | vaccine | Type of vaccine |
| Target diseases | O | Equivalent | diseaseOrAgentTargeted (list) | Disease or agent targeted |
| Target disease | R | Equivalent | diseaseOrAgentTargeted | Disease or agent targeted |
| Date of immunization | R | Equivalent | dateTimeOfVaccination | Date/time vaccine administered. |
| Number in a series of doses | O | Equivalent | doseNumber | Number in a series of vaccinations / doses |
| Product administered | O | Equivalent | administeredProduct | Administered medicinal product |
| Brand name | RK | source-is-narrower-than-target | administeredProduct | Administered medicinal product |
| Vaccine/prophylaxis or its component | RK | source-is-narrower-than-target | administeredProduct | Administered medicinal product |
| Product administration process | O | source-is-narrower-than-target | vaccineAdministrator | "Administrator of vaccine |
| Performer | O | Equivalent | vaccineAdministrator | "Administrator of vaccine |
| Route of administration | RK | Not represented | — |  |

### EU Patient Summary (EHDS Model) → ISO 27269 — Immunizations

| | | | |
| :--- | :--- | :--- | :--- |
| Element | Relation | Element | Notes |
| **EHDSImmunisation** | Equivalent | **Immunization** | Core entry concept is aligned. |
| **header** | Not represented | — | Administrative header (subject, authorship, status, etc.) not part of ISO 27269 clinical section content. |
| header.subject | Not represented | — | Patient identification handled elsewhere in ISO Document Header. |
| header.identifier | Not represented | — |  |
| header.authorship / author[x] / datetime | Not represented | — | Authorship metadata; ISO 27269 section does not define this. |
| header.lastUpdate | Not represented | — | Technical metadata. |
| header.status / statusReason | Not represented | — |  |
| header.language | Not represented | — | Resource-level attributes not defined in ISO section. |
| **diseaseOrAgentTargeted** | Equivalent | **Target disease** | Target condition. |
| **vaccine** | Equivalent | **Vaccine for type of disease** |  |
| **administeredProduct** | Equivalent | **Product administered** |  |
| **doseNumber** | Equivalent | **Number in a series of doses** | A Quantity in the ISO IPS, an integer in the model, a string in FHIR R5 |
| **dateTimeOfVaccination** | Equivalent | **Date of immunization** | When the vaccination was administered. |
| **administeringCentre** | Not represented | — |  |
| **vaccineAdministrator** | Equivalent | **Performer** | Health professional who administered the vaccine. |
| **nextVaccinationDate** | Not represented | — | Next planned vaccination date not present in ISO Immunizations. |

