# MedicationAdministration (EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **MedicationAdministration (EPS)**

## Resource Profile: MedicationAdministration (EPS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/medicationAdministration-eu-eps | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:MedicationAdministrationEuEps |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | | |

 
This profile constrains the MedicationAdministration resource for the purpose of this guide, adapted from the MPD work. 

**Usages:**

* Refer to this Profile: [Composition (EPS)](StructureDefinition-composition-eu-eps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/medicationAdministration-eu-eps)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-medicationAdministration-eu-eps.csv), [Excel](StructureDefinition-medicationAdministration-eu-eps.xlsx), [Schematron](StructureDefinition-medicationAdministration-eu-eps.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "medicationAdministration-eu-eps",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    }
  ],
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/medicationAdministration-eu-eps",
  "version" : "1.0.0-ci-build",
  "name" : "MedicationAdministrationEuEps",
  "title" : "MedicationAdministration (EPS)",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile constrains the MedicationAdministration resource for the purpose of this guide, adapted from the MPD work.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "w3c.prov",
      "uri" : "http://www.w3.org/ns/prov",
      "name" : "W3C PROV"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "MedicationAdministration",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/MedicationAdministration",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "MedicationAdministration",
        "path" : "MedicationAdministration"
      },
      {
        "id" : "MedicationAdministration.identifier",
        "path" : "MedicationAdministration.identifier",
        "short" : "Medication Administration Identifier"
      },
      {
        "id" : "MedicationAdministration.medication[x]",
        "path" : "MedicationAdministration.medication[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/medication-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "MedicationAdministration.subject",
        "path" : "MedicationAdministration.subject",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/patient-eu-core"
            ]
          }
        ]
      }
    ]
  }
}

```
