# Device (EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Device (EPS)**

## Resource Profile: Device (EPS) 

| | |
| :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps | *Version*:1.0.0-ci-build |
| Draft as of 2025-12-26 | *Computable Name*:DeviceEuEps |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | |

 
This profile represents the constraints applied to the Device resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile. 

**Usages:**

* Use this Profile: [Bundle (EPS)](StructureDefinition-bundle-eu-eps.md)
* Refer to this Profile: [DeviceUseStatement (EPS)](StructureDefinition-deviceUseStatement-eu-eps.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/device-eu-eps)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-device-eu-eps.csv), [Excel](StructureDefinition-device-eu-eps.xlsx), [Schematron](StructureDefinition-device-eu-eps.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "device-eu-eps",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Device-uv-ips"
    }
  ],
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps",
  "version" : "1.0.0-ci-build",
  "name" : "DeviceEuEps",
  "title" : "Device (EPS)",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "This profile represents the constraints applied to the Device resource for the purpose of this guide. A device used by or implanted on the patient is described in the hospital discharge report as an instance of a Device resource constrained by this profile.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "udi",
      "uri" : "http://fda.gov/UDI",
      "name" : "UDI Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Device",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Device",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Device.identifier",
        "path" : "Device.identifier",
        "short" : "Device Identifier"
      },
      {
        "id" : "Device.udiCarrier",
        "path" : "Device.udiCarrier",
        "short" : "Unique Device Identifier (UDI)"
      },
      {
        "id" : "Device.type",
        "path" : "Device.type",
        "short" : "Type of device.\r\nPreferably valued by using SNOMED CT.\r\nThe absence of information, or of devices relevant for purpose of this IPS, shall be explicitly stated by using the codes included in the absent-or-unknown-devices-uv-ips value set.",
        "binding" : {
          "extension" : [
            {
              "extension" : [
                {
                  "url" : "purpose",
                  "valueCode" : "candidate"
                },
                {
                  "url" : "valueSet",
                  "valueCanonical" : "http://terminology.ehdsi.eu/ValueSet/eHDSIMedicalDevice"
                },
                {
                  "url" : "documentation",
                  "valueMarkdown" : "Codes for medical devices from MyHealth@EU"
                }
              ],
              "url" : "http://hl7.org/fhir/tools/StructureDefinition/additional-binding"
            }
          ],
          "strength" : "preferred",
          "valueSet" : "http://hl7.org/fhir/uv/ips/ValueSet/medical-devices-uv-ips"
        }
      }
    ]
  }
}

```
