# Bundle (EPS) - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Bundle (EPS)**

## Resource Profile: Bundle (EPS) 

| | | |
| :--- | :--- | :--- |
| *Official URL*:http://hl7.eu/fhir/eps/StructureDefinition/bundle-eu-eps | *Version*:1.0.0-ci-build | |
| *Standards status:*[Draft](http://hl7.org/fhir/R4/versions.html#std-process) | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BundleEuEps |
| **Copyright/Legal**: Used by permission of HL7 Europe, all rights reserved Creative Commons License | | |

 
Clinical document used to represent a Patient Summary for the scope of this project. 

**Usages:**

* This Profile is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.eu.eps|current/StructureDefinition/bundle-eu-eps)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-bundle-eu-eps.csv), [Excel](StructureDefinition-bundle-eu-eps.xlsx), [Schematron](StructureDefinition-bundle-eu-eps.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "bundle-eu-eps",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-standards-status",
      "valueCode" : "draft"
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-imposeProfile",
      "valueCanonical" : "http://hl7.org/fhir/uv/ips/StructureDefinition/Bundle-uv-ips"
    }
  ],
  "url" : "http://hl7.eu/fhir/eps/StructureDefinition/bundle-eu-eps",
  "version" : "1.0.0-ci-build",
  "name" : "BundleEuEps",
  "title" : "Bundle (EPS)",
  "status" : "draft",
  "date" : "2025-12-26T09:07:46+00:00",
  "publisher" : "HL7 Europe",
  "contact" : [
    {
      "name" : "HL7 Europe",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7.eu"
        }
      ]
    }
  ],
  "description" : "Clinical document used to represent a Patient Summary for the scope of this project.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "http://unstats.un.org/unsd/methods/m49/m49.htm",
          "code" : "150",
          "display" : "Europe"
        }
      ]
    }
  ],
  "copyright" : "Used by permission of HL7 Europe, all rights reserved Creative Commons License",
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "cda",
      "uri" : "http://hl7.org/v3/cda",
      "name" : "CDA (R2)"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Bundle",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Bundle",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Bundle",
        "path" : "Bundle",
        "short" : "Patient Summary bundle",
        "definition" : "Patient Summary bundle."
      },
      {
        "id" : "Bundle.entry",
        "path" : "Bundle.entry",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "type",
              "path" : "resource"
            },
            {
              "type" : "profile",
              "path" : "resource"
            }
          ],
          "rules" : "open"
        },
        "short" : "Entry resource in the patient summary bundle",
        "definition" : "An entry resource included in the patient summary document bundle resource.",
        "comment" : "Must contain the IPS Composition as the first entry (only a single Composition resource instance may be included) and a Patient resource.  Additional constraints are specified in the IPS Composition profile.",
        "min" : 2
      },
      {
        "id" : "Bundle.entry.fullUrl",
        "path" : "Bundle.entry.fullUrl",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.resource",
        "path" : "Bundle.entry.resource",
        "min" : 1
      },
      {
        "id" : "Bundle.entry.search",
        "path" : "Bundle.entry.search",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.request",
        "path" : "Bundle.entry.request",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry.response",
        "path" : "Bundle.entry.response",
        "max" : "0"
      },
      {
        "id" : "Bundle.entry:composition",
        "path" : "Bundle.entry",
        "sliceName" : "composition",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:composition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Composition",
            "profile" : [
              "http://hl7.eu/fhir/eps/StructureDefinition/composition-eu-eps"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:patient",
        "path" : "Bundle.entry",
        "sliceName" : "patient",
        "min" : 1,
        "max" : "1"
      },
      {
        "id" : "Bundle.entry:patient.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Patient",
            "profile" : ["http://hl7.eu/fhir/eps/StructureDefinition/patient-eu-eps"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:allergyintolerance",
        "path" : "Bundle.entry",
        "sliceName" : "allergyintolerance",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:allergyintolerance.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "AllergyIntolerance",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/allergyIntolerance-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:careplan",
        "path" : "Bundle.entry",
        "sliceName" : "careplan",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:clinicalimpression",
        "path" : "Bundle.entry",
        "sliceName" : "clinicalimpression",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:condition",
        "path" : "Bundle.entry",
        "sliceName" : "condition",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:condition.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Condition",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/condition-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:consent",
        "path" : "Bundle.entry",
        "sliceName" : "consent",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:device",
        "path" : "Bundle.entry",
        "sliceName" : "device",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:device.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Device",
            "profile" : ["http://hl7.eu/fhir/eps/StructureDefinition/device-eu-eps"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:deviceusestatement",
        "path" : "Bundle.entry",
        "sliceName" : "deviceusestatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:deviceusestatement.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "DeviceUseStatement",
            "profile" : [
              "http://hl7.eu/fhir/eps/StructureDefinition/deviceUseStatement-eu-eps"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:diagnosticreport",
        "path" : "Bundle.entry",
        "sliceName" : "diagnosticreport",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:documentreference",
        "path" : "Bundle.entry",
        "sliceName" : "documentreference",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:flag",
        "path" : "Bundle.entry",
        "sliceName" : "flag",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:flag.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Flag",
            "profile" : ["http://hl7.eu/fhir/base/StructureDefinition/flag-eu-core"]
          }
        ]
      },
      {
        "id" : "Bundle.entry:imagingstudy",
        "path" : "Bundle.entry",
        "sliceName" : "imagingstudy",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:immunization",
        "path" : "Bundle.entry",
        "sliceName" : "immunization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:immunization.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Immunization",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/immunization-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:immunizationrecommendation",
        "path" : "Bundle.entry",
        "sliceName" : "immunizationrecommendation",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medication",
        "path" : "Bundle.entry",
        "sliceName" : "medication",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medication.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Medication",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/medication-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationrequest",
        "path" : "Bundle.entry",
        "sliceName" : "medicationrequest",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationrequest.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationRequest",
            "profile" : [
              "http://hl7.eu/fhir/eps/StructureDefinition/medicationRequest-eu-eps"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:medicationstatement",
        "path" : "Bundle.entry",
        "sliceName" : "medicationstatement",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:medicationstatement.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "MedicationStatement",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/medicationStatement-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitioner",
        "path" : "Bundle.entry",
        "sliceName" : "practitioner",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitioner.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Practitioner",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitioner-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:practitionerrole",
        "path" : "Bundle.entry",
        "sliceName" : "practitionerrole",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:practitionerrole.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "PractitionerRole",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/practitionerRole-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:procedure",
        "path" : "Bundle.entry",
        "sliceName" : "procedure",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:procedure.resource",
        "path" : "Bundle.entry.resource",
        "type" : [
          {
            "code" : "Procedure",
            "profile" : [
              "http://hl7.eu/fhir/base/StructureDefinition/procedure-eu-core"
            ]
          }
        ]
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-edd",
        "path" : "Bundle.entry",
        "sliceName" : "observation-pregnancy-edd",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-outcome",
        "path" : "Bundle.entry",
        "sliceName" : "observation-pregnancy-outcome",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-pregnancy-status",
        "path" : "Bundle.entry",
        "sliceName" : "observation-pregnancy-status",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-alcohol-use",
        "path" : "Bundle.entry",
        "sliceName" : "observation-alcohol-use",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-tobacco-use",
        "path" : "Bundle.entry",
        "sliceName" : "observation-tobacco-use",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-results-laboratory-pathology",
        "path" : "Bundle.entry",
        "sliceName" : "observation-results-laboratory-pathology",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-results-radiology",
        "path" : "Bundle.entry",
        "sliceName" : "observation-results-radiology",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:observation-vital-signs",
        "path" : "Bundle.entry",
        "sliceName" : "observation-vital-signs",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:organization",
        "path" : "Bundle.entry",
        "sliceName" : "organization",
        "min" : 0,
        "max" : "*"
      },
      {
        "id" : "Bundle.entry:specimen",
        "path" : "Bundle.entry",
        "sliceName" : "specimen",
        "min" : 0,
        "max" : "*"
      }
    ]
  }
}

```
