# hl7.fhir.eu.eps#1.0.0-ci-build: HL7 Europe Patient Summary

## Pages

* [Home](index.md)
* [IPS to EPS Results Comparison](ips-eps-results.md)
* [eHN guideline data set](logicalModel.md)
* [IPS to EPS Alert Comparison](ips-eps-alert.md)
* [Handling Missing Data](missing-data.md)
* [IPS to EPS Section Comparison](ips-eps-section-comparison.md)
* [Known Issues](knownIssues.md)
* [Cross-version Analysis](crossversionanalysis.md)
* [Dependencies](dependencies.md)
* [IPS - EU Core Differences](ips-diff.md)
* [Authors and contributors](contributors.md)
* [IPS to EPS Patient Story Comparison](ips-eps-patient-story.md)
* [Copyright](copyright.md)
* [IPS to EPS Procedure Comparison](ips-eps-procedure.md)
* [IPS to EPS Social History Comparison](ips-eps-social-history.md)
* [Introduction](introduction.md)
* [EHDSPatientSummary to Composition (EPS)](map-ehdspatientsummary.md)
* [IPS to EPS Immunization Comparison](ips-eps-immunization.md)
* [IPS to EPS Care Plan Comparison](ips-eps-care-plan.md)
* [IPS to EPS Advance Directives Comparison](ips-eps-advance-directives.md)
* [IPS to EPS Problem Comparison](ips-eps-problem.md)
* [IPS to EPS Medication Comparison](ips-eps-medication.md)
* [IPS to EPS Medical Devices Comparison](ips-eps-medical-devices.md)
* [IPS to EPS Vital Signs Comparison](ips-eps-vital-signs.md)
* [ISO ↔ EU PS Mapping Overview](mappings.md)
* [IPS to EPS Allergy Comparison](ips-eps-allergy.md)
* [IPS to EPS History of Pregnancy Comparison](ips-eps-pregnancy.md)
* [Artifacts Summary](artifacts.md)
* [Downloads](downloads.md)
* [IPS to EPS Functional Status Comparison](ips-eps-functional-status.md)
* [Obligations](obligations.md)

## Resources

### ValueSets

* [Severity](ValueSet-eHDSISeverity.md)

### Resource Profiles

* [Bundle (EPS)](StructureDefinition-bundle-eu-eps.md)
* [Composition (EPS)](StructureDefinition-composition-eu-eps.md)
* [Consent (Advance Directives EPS)](StructureDefinition-consent-eu-eps.md)
* [Device (EPS)](StructureDefinition-device-eu-eps.md)
* [DeviceUseStatement (EPS)](StructureDefinition-deviceUseStatement-eu-eps.md)
* [MedicationAdministration (EPS)](StructureDefinition-medicationAdministration-eu-eps.md)
* [MedicationDispense (EPS)](StructureDefinition-medicationDispense-eu-eps.md)
* [MedicationRequest (EPS)](StructureDefinition-medicationRequest-eu-eps.md)
* [Observation: country visited (EPS)](StructureDefinition-observation-travel-eu-eps.md)
* [Patient (EPS)](StructureDefinition-patient-eu-eps.md)

### Extensions

* [Condition Status Reason](StructureDefinition-condition-statusReason.md)
* [Immunization AdministeredProduct](StructureDefinition-immunization-administeredProduct.md)
* [Supporting Information](StructureDefinition-supportingInformation.md)

### ImplementationGuides

* [HL7 Europe Patient Summary](index.md)
