# IPS to EPS Procedure Comparison - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **IPS to EPS Procedure Comparison**

## IPS to EPS Procedure Comparison

# ISO 27269 — EU Patient Summary — History of Procedures Mapping

### ISO 27269 → EU Patient Summary — History of Procedures

| | | | | |
| :--- | :--- | :--- | :--- | :--- |
| Element | Conf. | Relation | Element | Notes |
| **Procedures content status** | C | Equivalent | **section.emptyReason** | Same purpose; EU PS follows the IPS FHIR representation with`emptyReason`. |
| **Procedures** | C | Equivalent | **EHDSProcedure (list)** | Represents the list of procedure entries. |
| **Procedure** | M | Equivalent | **EHDSProcedure** | Core entry element; identical concept. |
| Procedure code | R | Equivalent | code | Identification of the procedure; EU PS uses SNOMED CT or relevant code systems. |
| Procedure description | RK | TBD | note | The model includes only the notes as additional info. Available in the EU core FHIR Procedure |
| Body site | O | Equivalent | bodySite | Anatomical location of the procedure. |
| Procedure date | R | Equivalent | date[x] | Optional in the model |

### EU Patient Summary (EHDS Model) → ISO 27269 — History of Procedures

| | | | |
| :--- | :--- | :--- | :--- |
| Element | Relation | Element | Notes |
| **EHDSProcedure** | Equivalent | **Procedure** | Core entry concept is aligned. |
| **header** | Not represented | — | Administrative header (subject, authorship, status, etc.) not part of ISO 27269 clinical section content. |
| header.subject | Not represented | — | Patient identification handled elsewhere in ISO Document Header. |
| header.identifier | Not represented | — |  |
| header.authorship / author[x] / datetime | Not represented | — | Authorship metadata; ISO 27269 section does not define this. |
| header.lastUpdate | Not represented | — | Technical metadata. |
| **code** | Equivalent | **Procedure code** | Coded procedure type. |
| **date[x]** | Equivalent | **Procedure date** |  |
| **performer** | Not represented | — | Present in the EU FHIR Core |
| **bodySite** | Equivalent | **Body site** | Anatomical focus. |
| **reason[x]** | Not represented | — | Present in the EU FHIR Core |
| **outcome** | Not represented | — | Present in the EU FHIR Core |
| **complication** | Not represented | — | Present in the EU FHIR Core |
| **deviceUsed** | Not represented | — | Present in the EU FHIR Core |
| **focalDevice** | Not represented | — | Present in the EU FHIR Core |
| **note** | source-is-narrower-than-target | **description** | description is not limited to Additional information. |

