# Introduction - HL7 Europe Patient Summary v1.0.0-ci-build

* [**Table of Contents**](toc.md)
* **Introduction**

## Introduction

### Introduction

The **European Patient Summary (EPS)** is a standardized, cross-border health data set intended to support safe and effective healthcare delivery, particularly in unplanned care scenarios. It enables healthcare professionals to access essential clinical information about a patient, regardless of where the data was originally recorded.

This **FHIR Implementation Guide (IG)** defines the European Patient Summary using **HL7® FHIR®**, providing a computable and interoperable specification aligned with European and international standards and initiatives.

### Policy and Semantic Foundations

This guide is based on and aligned with the [**eHealth Network (eHN) Guideline on the Patient Summary**](https://health.ec.europa.eu/publications/ehn-guideline-patient-summary_en), which define the scope, purpose, and semantic content of the European Patient Summary in the context of cross-border healthcare within the European Union.

Guideline that has been further refined by the [**Xt-EHR Joint Action**](https://www.xt-ehr.eu/), action contributing to the development of implementing acts under EHDS.

### European and International Standards Alignment

The HL7 FHIR European Patient Summary aims **conformance with the HL7 FHIR International Patient Summary (IPS) Implementation Guide, version 2.0.0**, and with the HL7 FHIR EU Core profiles. Through the conformance with the HL7 FHIR IPS, this guide claims also compliance with the **ISO/EN 27269 – International Patient Summary (IPS)** standard, ensuring consistency with internationally recognized requirements for patient summary content and structure.

### Purpose of This Guide

This guide provides:

* A FHIR-based representation of the European Patient Summary
* European-specific constraints and guidance where required
* Alignment with EU policy, international standards, and global FHIR specifications

It is intended to support national and regional implementations, cross-border health information exchange, and alignment with the European Health Data Space (EHDS), supporting the implementation of the European Electronic Health Record Exchange Format (EEHRxF).

### Audience

This Implementation Guide is intended for:

* System architects and developers
* Standards organizations and national authorities
* Vendors implementing EPS-compatible systems
* Cross-border and European interoperability initiatives

