# BeVSRequestedServicesNurse - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeVSRequestedServicesNurse**

## ValueSet: BeVSRequestedServicesNurse 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-requested-services-nurse | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeVSRequestedServicesNurse |

 
Codes indicating the requests that can be asked from a nurse. 

 **References** 

* [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT Belgian Edition edition 15-Nov 2023
* [codesystem BeTempRequestedService v1.0.0 (CodeSystem)](CodeSystem-be-cs-temp-requested-service.md)

This value set contains 62 concepts

**Additional Designations and Language Displays**

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "be-vs-requested-services-nurse",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-requested-services-nurse",
  "version" : "1.0.0",
  "name" : "BeVSRequestedServicesNurse",
  "title" : "BeVSRequestedServicesNurse",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Codes indicating the requests that can be asked from a nurse.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000172109",
        "concept" : [
          {
            "code" : "103713001"
          },
          {
            "code" : "103715008"
          },
          {
            "code" : "113154008"
          },
          {
            "code" : "127606004"
          },
          {
            "code" : "166900001"
          },
          {
            "code" : "173765009"
          },
          {
            "code" : "174297001"
          },
          {
            "code" : "175852005"
          },
          {
            "code" : "17636008"
          },
          {
            "code" : "18011004"
          },
          {
            "code" : "182777000"
          },
          {
            "code" : "183232006"
          },
          {
            "code" : "18629005"
          },
          {
            "code" : "225230008"
          },
          {
            "code" : "225268005"
          },
          {
            "code" : "225358003"
          },
          {
            "code" : "225420001"
          },
          {
            "code" : "225964003"
          },
          {
            "code" : "2267008"
          },
          {
            "code" : "233520008"
          },
          {
            "code" : "276737004"
          },
          {
            "code" : "28177007"
          },
          {
            "code" : "385796006"
          },
          {
            "code" : "385805005"
          },
          {
            "code" : "385966005"
          },
          {
            "code" : "386225006"
          },
          {
            "code" : "397958003"
          },
          {
            "code" : "41351007"
          },
          {
            "code" : "413899004"
          },
          {
            "code" : "427391006"
          },
          {
            "code" : "429723008"
          },
          {
            "code" : "445191009"
          },
          {
            "code" : "48817005"
          },
          {
            "code" : "56993006"
          },
          {
            "code" : "57485005"
          },
          {
            "code" : "6125005"
          },
          {
            "code" : "75325006"
          },
          {
            "code" : "762238003"
          },
          {
            "code" : "79165006"
          },
          {
            "code" : "81011003"
          },
          {
            "code" : "87750000"
          },
          {
            "code" : "89826002"
          },
          {
            "code" : "90838004"
          }
        ]
      },
      {
        "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-temp-requested-service"
      }
    ]
  }
}

```
