# BeReferralPrescription - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeReferralPrescription**

## Resource Profile: BeReferralPrescription 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription | *Version*:1.0.0 |
| Draft as of 2021-07-15 | *Computable Name*:BeReferralPrescription |

 
The common structure for referral prescription. 

**Usages:**

* Derived from this Profile: [BeLabPrescription](StructureDefinition-be-lab-prescription.md), [BeReferralPrescriptionDiagnosticImaging](StructureDefinition-be-referralprescription-diagnosticimaging.md) and [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md)
* Refer to this Profile: [BeReferralPrescriptionRequestGroup](StructureDefinition-be-referralprescription-request-group.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-referralprescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-referralprescription.csv), [Excel](StructureDefinition-be-referralprescription.xlsx), [Schematron](StructureDefinition-be-referralprescription.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-referralprescription",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription",
  "version" : "1.0.0",
  "name" : "BeReferralPrescription",
  "status" : "draft",
  "date" : "2021-07-15T08:52:50+00:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "The common structure for referral prescription.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "quick",
      "uri" : "http://siframework.org/cqf",
      "name" : "Quality Improvement and Clinical Knowledge (QUICK)"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "ServiceRequest",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/ServiceRequest",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "ServiceRequest",
        "path" : "ServiceRequest"
      },
      {
        "id" : "ServiceRequest.extension",
        "path" : "ServiceRequest.extension",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "url"
            }
          ],
          "rules" : "open"
        },
        "min" : 2
      },
      {
        "id" : "ServiceRequest.extension:statusReason",
        "path" : "ServiceRequest.extension",
        "sliceName" : "statusReason",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "http://hl7.org/fhir/StructureDefinition/request-statusReason"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:statusReason.value[x]",
        "path" : "ServiceRequest.extension.value[x]",
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-prescription-status-reason"
        }
      },
      {
        "id" : "ServiceRequest.extension:feedback",
        "path" : "ServiceRequest.extension",
        "sliceName" : "feedback",
        "short" : "Give feedback to the prescriber",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:coprescriber",
        "path" : "ServiceRequest.extension",
        "sliceName" : "coprescriber",
        "short" : "Info about the other parties that have to take part in the prescription.",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber-info"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:validity",
        "path" : "ServiceRequest.extension",
        "sliceName" : "validity",
        "short" : "Validity period of the prescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:latest",
        "path" : "ServiceRequest.extension",
        "sliceName" : "latest",
        "short" : "Request must be executed before",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-latest-end-date"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:latestDraft",
        "path" : "ServiceRequest.extension",
        "sliceName" : "latestDraft",
        "short" : "The prescription must have left the draft status befor this moment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-latest-draft-date"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:proposalType",
        "path" : "ServiceRequest.extension",
        "sliceName" : "proposalType",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-proposal-type"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:pss",
        "path" : "ServiceRequest.extension",
        "sliceName" : "pss",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-pss-info"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:recorder",
        "path" : "ServiceRequest.extension",
        "sliceName" : "recorder",
        "short" : "The person responsable for this information, not necessarily the person who recorded the information",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-ext-recorder"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.extension:performerType",
        "path" : "ServiceRequest.extension",
        "sliceName" : "performerType",
        "short" : "Discipline of provider. Replaces .performerType because of wrong cardinality",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.identifier",
        "path" : "ServiceRequest.identifier",
        "slicing" : {
          "discriminator" : [
            {
              "type" : "value",
              "path" : "system"
            }
          ],
          "rules" : "open"
        },
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.identifier:UHMEP",
        "path" : "ServiceRequest.identifier",
        "sliceName" : "UHMEP",
        "short" : "Reference ID of the UHMEP once available there",
        "min" : 0,
        "max" : "1"
      },
      {
        "id" : "ServiceRequest.identifier:UHMEP.system",
        "path" : "ServiceRequest.identifier.system",
        "min" : 1,
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/NamingSystem/uhmep"
      },
      {
        "id" : "ServiceRequest.identifier:UHMEP.value",
        "path" : "ServiceRequest.identifier.value",
        "min" : 1
      },
      {
        "id" : "ServiceRequest.basedOn",
        "path" : "ServiceRequest.basedOn",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.requisition",
        "path" : "ServiceRequest.requisition",
        "short" : "If needed to have a common identifier among different prescriptions.",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.status",
        "path" : "ServiceRequest.status",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.intent",
        "path" : "ServiceRequest.intent",
        "mustSupport" : true,
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-request-intent"
        }
      },
      {
        "id" : "ServiceRequest.category",
        "path" : "ServiceRequest.category",
        "min" : 1,
        "max" : "1",
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-referral-category"
        }
      },
      {
        "id" : "ServiceRequest.code",
        "path" : "ServiceRequest.code",
        "mustSupport" : true,
        "binding" : {
          "extension" : [
            {
              "url" : "http://hl7.org/fhir/StructureDefinition/elementdefinition-bindingName",
              "valueString" : "ServiceRequestCode"
            }
          ],
          "strength" : "example",
          "description" : "Codes for tests or services that can be carried out by a designated individual, organization or healthcare service.",
          "valueSet" : "http://hl7.org/fhir/ValueSet/procedure-code"
        }
      },
      {
        "id" : "ServiceRequest.orderDetail",
        "path" : "ServiceRequest.orderDetail",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.subject",
        "path" : "ServiceRequest.subject",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-contained-or-logical-reference"
            ],
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-patient"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.occurrence[x]",
        "path" : "ServiceRequest.occurrence[x]",
        "short" : "When service shall occur - once this is past, this prescription is no longer valid and the status shall reflect this.",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.authoredOn",
        "path" : "ServiceRequest.authoredOn",
        "min" : 1,
        "constraint" : [
          {
            "key" : "be-inv-long-date",
            "severity" : "error",
            "human" : "date SHALL contain a long date (YYYY-MM-DDThh:mm:ss+zz:zz)",
            "expression" : "empty() or toString().length()=25",
            "source" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription"
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.requester",
        "path" : "ServiceRequest.requester",
        "short" : "Prescriber of the requested service",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-contained-or-logical-reference"
            ],
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.performerType",
        "path" : "ServiceRequest.performerType",
        "max" : "0",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.performer",
        "path" : "ServiceRequest.performer",
        "short" : "Requested performer - typically reference to practitionerroles",
        "type" : [
          {
            "code" : "Reference",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-contained-or-logical-reference"
            ],
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.reasonCode",
        "path" : "ServiceRequest.reasonCode",
        "max" : "1",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.supportingInfo",
        "path" : "ServiceRequest.supportingInfo",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.bodySite",
        "path" : "ServiceRequest.bodySite",
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.bodySite.extension:bodyLaterality",
        "path" : "ServiceRequest.bodySite.extension",
        "sliceName" : "bodyLaterality",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "Extension",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core-clinical/StructureDefinition/be-ext-laterality"
            ]
          }
        ]
      },
      {
        "id" : "ServiceRequest.note",
        "path" : "ServiceRequest.note",
        "type" : [
          {
            "code" : "Annotation",
            "profile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-coded-annotation"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "ServiceRequest.note.extension:code",
        "path" : "ServiceRequest.note.extension",
        "sliceName" : "code"
      },
      {
        "id" : "ServiceRequest.note.extension:code.value[x]",
        "path" : "ServiceRequest.note.extension.value[x]",
        "binding" : {
          "strength" : "required",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-request-note-type"
        }
      },
      {
        "id" : "ServiceRequest.patientInstruction",
        "path" : "ServiceRequest.patientInstruction",
        "mustSupport" : true
      }
    ]
  }
}

```
