# BeOrganizationTask - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeOrganizationTask**

## Resource Profile: BeOrganizationTask 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-organization-task | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeOrganizationTask |

 
Subtask to assign the referral task and prescription to one or more members of this organisation 

**Usages:**

* Examples for this Profile: [Task/ucgh222p12-1-2-1](Task-ucgh222p12-1-2-1.md) and [Task/ucgh222p12-2-2-1](Task-ucgh222p12-2-2-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-organization-task)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-organization-task.csv), [Excel](StructureDefinition-be-organization-task.xlsx), [Schematron](StructureDefinition-be-organization-task.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-organization-task",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-organization-task",
  "version" : "1.0.0",
  "name" : "BeOrganizationTask",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Subtask to assign the referral task and prescription to one or more members of this organisation",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "workflow",
      "uri" : "http://hl7.org/fhir/workflow",
      "name" : "Workflow Pattern"
    },
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    },
    {
      "identity" : "w5",
      "uri" : "http://hl7.org/fhir/fivews",
      "name" : "FiveWs Pattern Mapping"
    },
    {
      "identity" : "v2",
      "uri" : "http://hl7.org/v2",
      "name" : "HL7 v2 Mapping"
    }
  ],
  "kind" : "resource",
  "abstract" : false,
  "type" : "Task",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Task",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Task",
        "path" : "Task"
      },
      {
        "id" : "Task.partOf",
        "path" : "Task.partOf",
        "short" : "Reference to the BeReferral task linked to the prescription",
        "min" : 1,
        "max" : "1",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referral-task"
            ]
          }
        ],
        "mustSupport" : true
      },
      {
        "id" : "Task.status",
        "path" : "Task.status",
        "mustSupport" : true
      },
      {
        "id" : "Task.focus",
        "path" : "Task.focus",
        "mustSupport" : true
      },
      {
        "id" : "Task.owner",
        "path" : "Task.owner",
        "short" : "Reference to the organisation that will assign performers to this referral task",
        "min" : 1,
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-organization"
            ]
          }
        ],
        "mustSupport" : true
      }
    ]
  }
}

```
