# BePerformerType - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BePerformerType**

## Extension: BePerformerType 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BePerformerType |

Types of performers that can execute this request

**Context of Use**

**Usage info**

**Usages:**

* Use this Extension: [BeReferralPrescription](StructureDefinition-be-referralprescription.md)
* Examples for this Extension: [ServiceRequest/uc2a-1](ServiceRequest-uc2a-1.md), [ServiceRequest/uc2a-2](ServiceRequest-uc2a-2.md), [ServiceRequest/uc2a-3](ServiceRequest-uc2a-3.md), [ServiceRequest/uc5a-1](ServiceRequest-uc5a-1.md)...Show 13 more,[ServiceRequest/ucgh211-1](ServiceRequest-ucgh211-1.md),[ServiceRequest/ucgh222p12-1](ServiceRequest-ucgh222p12-1.md),[ServiceRequest/ucgh222p12-2](ServiceRequest-ucgh222p12-2.md),[ServiceRequest/ucgh222p12-3](ServiceRequest-ucgh222p12-3.md),[ServiceRequest/ucgh222p13-1](ServiceRequest-ucgh222p13-1.md),[ServiceRequest/ucgh222p13-2](ServiceRequest-ucgh222p13-2.md),[ServiceRequest/ucgh241p110-1](ServiceRequest-ucgh241p110-1.md),[ServiceRequest/ucgh241p111-1](ServiceRequest-ucgh241p111-1.md),[ServiceRequest/ucgh241p15-1](ServiceRequest-ucgh241p15-1.md),[ServiceRequest/ucgh241p16-1](ServiceRequest-ucgh241p16-1.md),[ServiceRequest/ucgh241p17-1](ServiceRequest-ucgh241p17-1.md),[ServiceRequest/ucgh241p18-1](ServiceRequest-ucgh241p18-1.md)and[ServiceRequest/ucgh241p19-1](ServiceRequest-ucgh241p19-1.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-ext-performer-type)

### Formal Views of Extension Content

 [Description of Profiles, Differentials, Snapshots, and how the XML and JSON presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-ext-performer-type.csv), [Excel](StructureDefinition-be-ext-performer-type.xlsx), [Schematron](StructureDefinition-be-ext-performer-type.sch) 

#### Terminology Bindings

#### Constraints



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-ext-performer-type",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type",
  "version" : "1.0.0",
  "name" : "BePerformerType",
  "title" : "BePerformerType",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Types of performers that can execute this request",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "context" : [
    {
      "type" : "element",
      "expression" : "ServiceRequest"
    }
  ],
  "type" : "Extension",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Extension",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Extension",
        "path" : "Extension"
      },
      {
        "id" : "Extension.extension",
        "path" : "Extension.extension",
        "max" : "0"
      },
      {
        "id" : "Extension.url",
        "path" : "Extension.url",
        "fixedUri" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type"
      },
      {
        "id" : "Extension.value[x]",
        "path" : "Extension.value[x]",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ],
        "mustSupport" : true,
        "binding" : {
          "strength" : "extensible",
          "valueSet" : "https://www.ehealth.fgov.be/standards/fhir/core/ValueSet/be-vs-cd-hcparty"
        }
      }
    ]
  }
}

```
