# BeContainedOrLogicalReference - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeContainedOrLogicalReference**

## Data Type Profile: BeContainedOrLogicalReference 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-contained-or-logical-reference | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeContainedOrLogicalReference |

 
A reference limited to contained resources or resources with a logical identifier. 

**Usages:**

* Use this DataType Profile: [BeReferralPrescription](StructureDefinition-be-referralprescription.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-contained-or-logical-reference)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-contained-or-logical-reference.csv), [Excel](StructureDefinition-be-contained-or-logical-reference.xlsx), [Schematron](StructureDefinition-be-contained-or-logical-reference.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-contained-or-logical-reference",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-contained-or-logical-reference",
  "version" : "1.0.0",
  "name" : "BeContainedOrLogicalReference",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "A reference limited to contained resources or resources with a logical identifier.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "mapping" : [
    {
      "identity" : "rim",
      "uri" : "http://hl7.org/v3",
      "name" : "RIM Mapping"
    }
  ],
  "kind" : "complex-type",
  "abstract" : false,
  "type" : "Reference",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/Reference",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "Reference",
        "path" : "Reference",
        "constraint" : [
          {
            "key" : "be-inv-contained-or-logical-reference",
            "severity" : "error",
            "human" : "A reference must refer to a contained resource or have a logical identifier",
            "expression" : "reference.empty().not() or identifier.empty().not()",
            "source" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-contained-or-logical-reference"
          }
        ]
      },
      {
        "id" : "Reference.reference",
        "path" : "Reference.reference",
        "mustSupport" : true
      },
      {
        "id" : "Reference.identifier",
        "path" : "Reference.identifier",
        "mustSupport" : true
      }
    ]
  }
}

```
