# BeModelNursingPrescription - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeModelNursingPrescription**

## Logical Model: BeModelNursingPrescription 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelNursingPrescription | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeModelNursingPrescription |

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/BeModelNursingPrescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BeModelNursingPrescription.csv), [Excel](StructureDefinition-BeModelNursingPrescription.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BeModelNursingPrescription",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelNursingPrescription",
  "version" : "1.0.0",
  "name" : "BeModelNursingPrescription",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelNursingPrescription",
  "baseDefinition" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralPrescription",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BeModelNursingPrescription",
        "path" : "BeModelNursingPrescription",
        "short" : "BeModelNursingPrescription",
        "definition" : "BeModelNursingPrescription"
      },
      {
        "id" : "BeModelNursingPrescription.serviceRequestNumber",
        "path" : "BeModelNursingPrescription.serviceRequestNumber",
        "short" : "number of sessions prescribed",
        "definition" : "number of sessions prescribed",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "positiveInt"
          }
        ]
      },
      {
        "id" : "BeModelNursingPrescription.serviceRequestFrequency",
        "path" : "BeModelNursingPrescription.serviceRequestFrequency",
        "short" : "frequency of the treatment",
        "definition" : "frequency of the treatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelNursingPrescription.serviceRequestDayPeriod",
        "path" : "BeModelNursingPrescription.serviceRequestDayPeriod",
        "short" : "period of the day on which the treatment must take place",
        "definition" : "period of the day on which the treatment must take place",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeModelNursingPrescription.route",
        "path" : "BeModelNursingPrescription.route",
        "short" : "administration route of the treatment",
        "definition" : "administration route of the treatment",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      }
    ]
  }
}

```
