# BeDiagnosticImagingPrescription - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeDiagnosticImagingPrescription**

## Logical Model: BeDiagnosticImagingPrescription 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeDiagnosticImagingPrescription | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeDiagnosticImagingPrescription |

 
Logical model describing the model for the diagnostic imaging prescription. This draft is used in the HL7 Belgian workgroup for referral. 

**Usages:**

* This Logical Model is not used by any profiles in this Implementation Guide

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/BeDiagnosticImagingPrescription)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-BeDiagnosticImagingPrescription.csv), [Excel](StructureDefinition-BeDiagnosticImagingPrescription.xlsx) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "BeDiagnosticImagingPrescription",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeDiagnosticImagingPrescription",
  "version" : "1.0.0",
  "name" : "BeDiagnosticImagingPrescription",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Logical model describing the model for the diagnostic imaging prescription. This draft is used in the HL7 Belgian workgroup for referral.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "logical",
  "abstract" : false,
  "type" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeDiagnosticImagingPrescription",
  "baseDefinition" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/BeModelReferralPrescription",
  "derivation" : "specialization",
  "differential" : {
    "element" : [
      {
        "id" : "BeDiagnosticImagingPrescription",
        "path" : "BeDiagnosticImagingPrescription",
        "short" : "BeDiagnosticImagingPrescription",
        "definition" : "Logical model describing the model for the diagnostic imaging prescription. This draft is used in the HL7 Belgian workgroup for referral."
      },
      {
        "id" : "BeDiagnosticImagingPrescription.relevantClinicalInformation[x]",
        "path" : "BeDiagnosticImagingPrescription.relevantClinicalInformation[x]",
        "short" : "Relevant information in the context of this prescription concerning for example allergies, kidney function, diabetic. When detailed information can be given, it is RECOMMENDED to express it as structured as possible.",
        "definition" : "e.g. stomach ache during 10 days, echo suspected damage kidneys, complaints of patients, allergies,...",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Annotation"
          },
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Procedure",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance",
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement"
            ]
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.diagnosticQuestion[x]",
        "path" : "BeDiagnosticImagingPrescription.diagnosticQuestion[x]",
        "short" : "Either in text or in a coded format. At the discretion of the prescribing party.",
        "definition" : "e.g. Cyste? Metastasis?",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Annotation"
          },
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.contraIndication[x]",
        "path" : "BeDiagnosticImagingPrescription.contraIndication[x]",
        "short" : "Relevant information in the context of this prescription concerning possible contra indication. For example presence of devices or (suspected) pregnancy. When detailed information can be given, it is RECOMMENDED to express it as structured as possible. If prescriber has no knowledge of contra indication, this SHALL be expressed with a 'ASKU' nullFlavor ( = Information was sought but not found  ) in codeableConcept.",
        "definition" : "e.g.pregnancy, devices, kidney functioning",
        "min" : 1,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          },
          {
            "code" : "Annotation"
          },
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/Device",
              "http://hl7.org/fhir/StructureDefinition/Condition",
              "http://hl7.org/fhir/StructureDefinition/Observation",
              "http://hl7.org/fhir/StructureDefinition/MedicationStatement",
              "http://hl7.org/fhir/StructureDefinition/AllergyIntolerance"
            ]
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.supportingInformation[x]",
        "path" : "BeDiagnosticImagingPrescription.supportingInformation[x]",
        "short" : "test",
        "definition" : "test",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "BackboneElement"
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.supportingInformation[x].questionnaireResponse",
        "path" : "BeDiagnosticImagingPrescription.supportingInformation[x].questionnaireResponse",
        "short" : "Questionnaire responses",
        "definition" : "Questionnaire responses",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : [
              "http://hl7.org/fhir/StructureDefinition/QuestionnaireResponse"
            ]
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.supportingInformation[x].document",
        "path" : "BeDiagnosticImagingPrescription.supportingInformation[x].document",
        "short" : "Any document added as extra information",
        "definition" : "Any document added as extra information",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/DocumentReference"]
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.supportingInformation[x].imagingStudy",
        "path" : "BeDiagnosticImagingPrescription.supportingInformation[x].imagingStudy",
        "short" : "If vital to this request, references may be given to previous diagnostic imaging",
        "definition" : "If vital to this request, references may be given to previous diagnostic imaging",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "Reference",
            "targetProfile" : ["http://hl7.org/fhir/StructureDefinition/ImagingStudy"]
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.bodySite",
        "path" : "BeDiagnosticImagingPrescription.bodySite",
        "short" : "bodySite, e.g. using a SNOMED-CT code",
        "definition" : "bodySite, e.g. using a SNOMED-CT code",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.proposedInvestigation",
        "path" : "BeDiagnosticImagingPrescription.proposedInvestigation",
        "short" : "What to do - coded or as text within the codeableConcept",
        "definition" : "What to do - coded or as text within the codeableConcept",
        "min" : 0,
        "max" : "*",
        "type" : [
          {
            "code" : "CodeableConcept"
          }
        ]
      },
      {
        "id" : "BeDiagnosticImagingPrescription.contrastFluid",
        "path" : "BeDiagnosticImagingPrescription.contrastFluid",
        "short" : "ifNecessary|notPermitted",
        "definition" : "ifNecessary|notPermitted",
        "min" : 0,
        "max" : "1",
        "type" : [
          {
            "code" : "code"
          }
        ]
      }
    ]
  }
}

```
