# ucgh241p15-1 - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ucgh241p15-1**

## Example ServiceRequest: ucgh241p15-1



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "ucgh241p15-1",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-nursing"
    ]
  },
  "contained" : [
    {
      "resourceType" : "PractitionerRole",
      "id" : "ucgh241p15-1-1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "practitioner" : {
        "identifier" : {
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/nihdi",
          "value" : "10829059004"
        }
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persphysician"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber",
      "valueBoolean" : false
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period",
      "valuePeriod" : {
        "start" : "2022-10-03",
        "end" : "2023-04-03"
      }
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
            "code" : "persnurse"
          }
        ]
      }
    }
  ],
  "status" : "draft",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "9632001"
        }
      ]
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-temp-requested-service",
        "code" : "tmp-prep-rsed-5"
      }
    ],
    "text" : "(of $sct#385796006)? zie XLS"
  },
  "subject" : {
    "identifier" : {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/ssin",
      "value" : "38012699993"
    }
  },
  "authoredOn" : "2022-10-03T00:00:00+01:00",
  "requester" : {
    "reference" : "#ucgh241p15-1-1"
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "display" : "Diabetes type 1"
        }
      ]
    }
  ],
  "note" : [
    {
      "extension" : [
        {
          "url" : "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-ext-codeableconcept",
          "valueCodeableConcept" : {
            "coding" : [
              {
                "system" : "http://snomed.info/sct",
                "version" : "http://snomed.info/sct/11000172109",
                "code" : "410666004"
              }
            ]
          }
        }
      ],
      "text" : "geen medische reden voor terugbetaling"
    }
  ]
}

```
