# ucgh211-1 - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **ucgh211-1**

## Example ServiceRequest: ucgh211-1



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "ucgh211-1",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-nursing"
    ]
  },
  "contained" : [
    {
      "resourceType" : "PractitionerRole",
      "id" : "ucgh211-1-1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "active" : true,
      "practitioner" : {
        "identifier" : {
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/nihdi",
          "value" : "52104044521"
        }
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persphysiotherapist"
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "ucgh211-1-2",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "active" : true,
      "practitioner" : {
        "identifier" : {
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/nihdi",
          "value" : "65258234650"
        }
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persoccupationaltherapist"
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "ucgh211-1-3",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "active" : true,
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persnurse"
            }
          ]
        }
      ]
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "ucgh211-1-4",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "active" : true,
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persgeneralphysician"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber",
      "valueBoolean" : true
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period",
      "valuePeriod" : {
        "start" : "2022-10-03",
        "end" : "2023-04-03"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/request-statusReason",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason",
            "code" : "inProgress",
            "display" : "In progress"
          }
        ]
      }
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
            "code" : "persorthotist"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "coprescriberNumber",
          "valuePositiveInt" : 2
        },
        {
          "extension" : [
            {
              "url" : "coprescriber",
              "valueReference" : {
                "reference" : "#ucgh211-1-1"
              }
            },
            {
              "url" : "coprescriptionStatus",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/task-status",
                    "code" : "requested"
                  }
                ]
              }
            },
            {
              "url" : "required",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-co-prescriber-choice",
                    "code" : "one-of-mandatory"
                  }
                ]
              }
            }
          ],
          "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber"
        },
        {
          "extension" : [
            {
              "url" : "coprescriber",
              "valueReference" : {
                "reference" : "#ucgh211-1-2"
              }
            },
            {
              "url" : "coprescriptionStatus",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/task-status",
                    "code" : "requested"
                  }
                ]
              }
            },
            {
              "url" : "required",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-co-prescriber-choice",
                    "code" : "one-of-mandatory"
                  }
                ]
              }
            }
          ],
          "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber"
        },
        {
          "extension" : [
            {
              "url" : "coprescriber",
              "valueReference" : {
                "reference" : "#ucgh211-1-3"
              }
            },
            {
              "url" : "coprescriptionStatus",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/task-status",
                    "code" : "requested"
                  }
                ]
              }
            },
            {
              "url" : "required",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-co-prescriber-choice",
                    "code" : "one-of-mandatory"
                  }
                ]
              }
            }
          ],
          "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber"
        },
        {
          "extension" : [
            {
              "url" : "coprescriber",
              "valueReference" : {
                "reference" : "#ucgh211-1-4"
              }
            },
            {
              "url" : "coprescriptionStatus",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/task-status",
                    "code" : "requested"
                  }
                ]
              }
            },
            {
              "url" : "required",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-co-prescriber-choice",
                    "code" : "one-of-mandatory"
                  }
                ]
              }
            }
          ],
          "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber"
        }
      ],
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-co-prescriber-info"
    }
  ],
  "status" : "active",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "9632001"
        }
      ]
    }
  ],
  "priority" : "routine",
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000172109",
        "code" : "761894009"
      }
    ]
  },
  "subject" : {
    "identifier" : {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/ssin",
      "value" : "38012699993"
    }
  },
  "authoredOn" : "2022-10-03T00:00:00+01:00",
  "requester" : {
    "identifier" : {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/nihdi",
      "value" : "10829059004"
    }
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "298382003"
        }
      ]
    }
  ]
}

```
