# uc2a-3 - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **uc2a-3**

## Example ServiceRequest: uc2a-3

Profile: [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md)

**BeFeedbackToPrescriber**: true

**BeValidityPeriod**: 2023-01-26 --> 2023-07-26

**Request status reason**: In progress

**BePerformerType**: nurse

**status**: Draft

**intent**: Order

**category**: Nursing procedure

**code**: 225420001

**subject**: Identifier: BeSSINNamingSystem/38012699993

**occurrence**: Once

**authoredOn**: 2023-01-26 00:00:00+0100

**requester**: Identifier: BeNIHDINamingSystem/10829059004

**reasonCode**: 44653001



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "uc2a-3",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription-nursing"
    ]
  },
  "extension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber",
      "valueBoolean" : true
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period",
      "valuePeriod" : {
        "start" : "2023-01-26",
        "end" : "2023-07-26"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/request-statusReason",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason",
            "code" : "inProgress",
            "display" : "In progress"
          }
        ]
      }
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-performer-type",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
            "code" : "persnurse"
          }
        ]
      }
    }
  ],
  "status" : "draft",
  "intent" : "order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "9632001"
        }
      ],
      "text" : "Nursing procedure"
    }
  ],
  "code" : {
    "coding" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000172109",
        "code" : "225420001"
      }
    ]
  },
  "subject" : {
    "identifier" : {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/ssin",
      "value" : "38012699993"
    }
  },
  "occurrenceTiming" : {
    "repeat" : {
      "boundsDuration" : {
        "value" : 3,
        "unit" : "mo"
      }
    }
  },
  "authoredOn" : "2023-01-26T00:00:00+01:00",
  "requester" : {
    "identifier" : {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/nihdi",
      "value" : "10829059004"
    }
  },
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "44653001"
        }
      ]
    }
  ]
}

```
