# laboratory-order-example1 - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **laboratory-order-example1**

## Example ServiceRequest: laboratory-order-example1



## Resource Content

```json
{
  "resourceType" : "ServiceRequest",
  "id" : "laboratory-order-example1",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-lab-prescription"
    ]
  },
  "contained" : [
    {
      "resourceType" : "Patient",
      "id" : "patient1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-patient"
        ]
      },
      "identifier" : [
        {
          "use" : "official",
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/ssin",
          "value" : "99999999991"
        }
      ],
      "name" : [
        {
          "family" : "Doe",
          "given" : ["Jane"]
        }
      ],
      "telecom" : [
        {
          "system" : "phone",
          "value" : "322672299",
          "use" : "home"
        }
      ],
      "gender" : "female",
      "birthDate" : "1956-05-27",
      "address" : [
        {
          "use" : "home",
          "type" : "both",
          "text" : "Labradorstraat 26, 1000 Brussel",
          "line" : ["Labradorstraat 26"],
          "city" : "Brussel",
          "postalCode" : "1000",
          "country" : "BE"
        }
      ]
    },
    {
      "resourceType" : "Observation",
      "id" : "observation1",
      "status" : "final",
      "category" : [
        {
          "coding" : [
            {
              "system" : "http://terminology.hl7.org/CodeSystem/observation-category",
              "code" : "vital-signs",
              "display" : "Vital Signs"
            }
          ],
          "text" : "Vital Signs"
        }
      ],
      "code" : {
        "coding" : [
          {
            "system" : "http://loinc.org",
            "code" : "8867-4",
            "display" : "Heart rate"
          },
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/11000172109",
            "code" : "364075005",
            "display" : "Heart rate (observable entity)"
          }
        ],
        "text" : "Heart rate"
      },
      "subject" : {
        "reference" : "#patient1"
      },
      "effectiveDateTime" : "1999-07-02",
      "performer" : [
        {
          "reference" : "#Requester1"
        }
      ],
      "valueQuantity" : {
        "value" : 51,
        "unit" : "beats/minute",
        "system" : "http://unitsofmeasure.org",
        "code" : "/min"
      }
    },
    {
      "resourceType" : "Condition",
      "id" : "condition1",
      "clinicalStatus" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-clinical",
            "code" : "active"
          }
        ]
      },
      "verificationStatus" : {
        "coding" : [
          {
            "system" : "http://terminology.hl7.org/CodeSystem/condition-ver-status",
            "code" : "provisional"
          }
        ]
      },
      "code" : {
        "text" : "bradycardie"
      },
      "subject" : {
        "reference" : "#patient1"
      },
      "note" : [
        {
          "text" : "This is a suspicion"
        }
      ]
    },
    {
      "resourceType" : "DocumentReference",
      "id" : "media1",
      "status" : "current",
      "content" : [
        {
          "attachment" : {
            "contentType" : "image/gif",
            "data" : "iVBORw0KGgoAAAANSUhEUgAAA+MAAACnCAYAAAB6pY03AAAAAXNSR0IArs4c6QAAAARnQU1BAACx jwv8YQUAAAAJcEhZcwAAEnMAABJzAYwiuQcAADBZSURBVHhe7d09rty218fxrOFfZj/ZQHZgwEiZ gg=="
          }
        }
      ]
    },
    {
      "resourceType" : "Practitioner",
      "id" : "Requester1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitioner"
        ]
      },
      "identifier" : [
        {
          "use" : "official",
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/NamingSystem/nihdi",
          "value" : "88888888881"
        }
      ],
      "name" : [
        {
          "use" : "official",
          "family" : "Seven",
          "given" : ["Henry"]
        }
      ],
      "telecom" : [
        {
          "system" : "phone",
          "value" : "322882299",
          "use" : "home"
        }
      ],
      "address" : [
        {
          "use" : "work",
          "type" : "both",
          "text" : "Werkstraat 26, 1000 Brussel",
          "line" : ["Werkstraat 26"],
          "city" : "Brussel",
          "postalCode" : "1000",
          "country" : "BE"
        }
      ]
    },
    {
      "resourceType" : "Specimen",
      "id" : "specimen1",
      "identifier" : [
        {
          "system" : "https://www.GTL-LABO.be/",
          "value" : "1"
        }
      ],
      "type" : {
        "coding" : [
          {
            "system" : "http://snomed.info/sct",
            "version" : "http://snomed.info/sct/11000172109",
            "code" : "119297000",
            "display" : "Blood specimen"
          }
        ],
        "text" : "A string can be added to nuance or explain."
      },
      "collection" : {
        "collectedDateTime" : "2015-11-03",
        "method" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/11000172109",
              "code" : "28520004",
              "display" : "Venipuncture for blood test (procedure)"
            }
          ]
        },
        "bodySite" : {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/11000172109",
              "code" : "368208006",
              "display" : "Left upper arm structure (body structure)"
            }
          ]
        }
      },
      "note" : [
        {
          "text" : "Some extra relevant information concerning the specimen"
        }
      ]
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "practitionerrole1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "identifier" : [
        {
          "system" : "http://www.acme.org/practitioners",
          "value" : "23"
        }
      ],
      "active" : true,
      "period" : {
        "start" : "2019-08-01T00:00:00.000Z",
        "end" : "2019-12-01T00:00:00.000Z"
      },
      "practitioner" : {
        "reference" : "Practitioner/Performer1",
        "display" : "Dr Katherine Pulaski"
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persphysician",
              "display" : "physician"
            }
          ]
        }
      ],
      "specialty" : [
        {
          "coding" : [
            {
              "system" : "http://snomed.info/sct",
              "version" : "http://snomed.info/sct/11000172109",
              "code" : "419772000",
              "display" : "Family practice"
            }
          ]
        }
      ],
      "availableTime" : [
        {
          "daysOfWeek" : ["mon", "tue", "wed"],
          "availableStartTime" : "09:00:00",
          "availableEndTime" : "16:30:00"
        },
        {
          "daysOfWeek" : ["thu", "fri"],
          "availableStartTime" : "09:00:00",
          "availableEndTime" : "12:00:00"
        }
      ],
      "notAvailable" : [
        {
          "description" : "Katherine will be on extended leave during August 2020",
          "during" : {
            "start" : "2020-08-01T00:00:00.000Z",
            "end" : "2020-08-20T00:00:00.000Z"
          }
        }
      ],
      "availabilityExceptions" : "Katherine is generally unavailable on public holidays and during the Christmas/New Year break"
    },
    {
      "resourceType" : "PractitionerRole",
      "id" : "requesterrole1",
      "meta" : {
        "profile" : [
          "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
        ]
      },
      "practitioner" : {
        "reference" : "#Requester1"
      },
      "code" : [
        {
          "coding" : [
            {
              "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
              "code" : "persphysician",
              "display" : "physician"
            }
          ]
        }
      ]
    }
  ],
  "extension" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-feedback-to-prescriber",
      "valueBoolean" : true
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-validity-period",
      "valuePeriod" : {
        "start" : "2021-10-10"
      }
    },
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/request-statusReason",
      "valueCodeableConcept" : {
        "coding" : [
          {
            "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason",
            "code" : "inProgress",
            "display" : "In progress"
          }
        ]
      }
    },
    {
      "extension" : [
        {
          "url" : "party",
          "valueReference" : {
            "reference" : "#Requester1"
          }
        },
        {
          "url" : "instructions",
          "valueString" : "Send the requester an email, when the test is done."
        },
        {
          "extension" : [
            {
              "url" : "contactSystem",
              "valueCodeableConcept" : {
                "coding" : [
                  {
                    "system" : "http://hl7.org/fhir/contact-point-system",
                    "code" : "email",
                    "display" : "email"
                  }
                ]
              }
            },
            {
              "url" : "contactSystemValue",
              "valueString" : "doctor@mycabinet.be"
            }
          ],
          "url" : "contactway"
        }
      ],
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-urgent-communication"
    }
  ],
  "identifier" : [
    {
      "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/NamingSystem/uhmep",
      "value" : "XXXXXX"
    }
  ],
  "status" : "active",
  "intent" : "original-order",
  "category" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "15220000",
          "display" : "Laboratory test"
        }
      ]
    }
  ],
  "priority" : "stat",
  "code" : {
    "coding" : [
      {
        "system" : "http://loinc.org",
        "code" : "18723-7",
        "display" : "Hematology studies (set)"
      }
    ]
  },
  "orderDetail" : [
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "30341-2",
          "display" : "Erythrocyte sedimentation rate"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "789-8",
          "display" : "Erythrocytes [#/volume] in Blood by Automated count"
        }
      ]
    },
    {
      "coding" : [
        {
          "system" : "http://loinc.org",
          "code" : "20563-3",
          "display" : "Carboxyhemoglobin/Hemoglobin.total in Blood"
        }
      ]
    },
    {
      "text" : "Test described in text only"
    }
  ],
  "subject" : {
    "reference" : "#patient1"
  },
  "authoredOn" : "2015-11-01T00:00:00+01:00",
  "requester" : {
    "reference" : "#requesterrole1"
  },
  "performer" : [
    {
      "reference" : "#practitionerrole1"
    }
  ],
  "reasonCode" : [
    {
      "coding" : [
        {
          "system" : "https://www.SOME_NOMENCLATURE_SYSTEM.be/",
          "code" : "123",
          "display" : "TheJustification"
        }
      ]
    }
  ],
  "supportingInfo" : [
    {
      "reference" : "#observation1"
    },
    {
      "reference" : "#condition1"
    },
    {
      "reference" : "#media1"
    }
  ],
  "specimen" : [
    {
      "reference" : "#specimen1"
    }
  ],
  "note" : [
    {
      "text" : "Some free text explaining about these tests that are ordered."
    }
  ]
}

```
