# practitionerrole1 - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **practitionerrole1**

## Example PractitionerRole: practitionerrole1

Profile: [BePractitionerRole](https://build.fhir.org/ig/hl7-be/core/StructureDefinition-be-practitionerrole.html)

**identifier**: `http://www.acme.org/practitioners`/23

**active**: true

**period**: 2019-08-01 00:00:00+0000 --> 2019-12-01 00:00:00+0000

**practitioner**: [Dr Katherine Pulaski](Practitioner-Performer1.md)

**code**: physician

**specialty**: Family practice

> **availableTime****daysOfWeek**: Monday, Tuesday, Wednesday**availableStartTime**: 09:00:00**availableEndTime**: 16:30:00

> **availableTime****daysOfWeek**: Thursday, Friday**availableStartTime**: 09:00:00**availableEndTime**: 12:00:00

### NotAvailables

| | | |
| :--- | :--- | :--- |
| - | **Description** | **During** |
| * | Katherine will be on extended leave during August 2020 | 2020-08-01 00:00:00+0000 --> 2020-08-20 00:00:00+0000 |

**availabilityExceptions**: Katherine is generally unavailable on public holidays and during the Christmas/New Year break



## Resource Content

```json
{
  "resourceType" : "PractitionerRole",
  "id" : "practitionerrole1",
  "meta" : {
    "profile" : [
      "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-practitionerrole"
    ]
  },
  "identifier" : [
    {
      "system" : "http://www.acme.org/practitioners",
      "value" : "23"
    }
  ],
  "active" : true,
  "period" : {
    "start" : "2019-08-01T00:00:00.000Z",
    "end" : "2019-12-01T00:00:00.000Z"
  },
  "practitioner" : {
    "reference" : "Practitioner/Performer1",
    "display" : "Dr Katherine Pulaski"
  },
  "code" : [
    {
      "coding" : [
        {
          "system" : "https://www.ehealth.fgov.be/standards/fhir/core/CodeSystem/cd-hcparty",
          "code" : "persphysician",
          "display" : "physician"
        }
      ]
    }
  ],
  "specialty" : [
    {
      "coding" : [
        {
          "system" : "http://snomed.info/sct",
          "version" : "http://snomed.info/sct/11000172109",
          "code" : "419772000",
          "display" : "Family practice"
        }
      ]
    }
  ],
  "availableTime" : [
    {
      "daysOfWeek" : ["mon", "tue", "wed"],
      "availableStartTime" : "09:00:00",
      "availableEndTime" : "16:30:00"
    },
    {
      "daysOfWeek" : ["thu", "fri"],
      "availableStartTime" : "09:00:00",
      "availableEndTime" : "12:00:00"
    }
  ],
  "notAvailable" : [
    {
      "description" : "Katherine will be on extended leave during August 2020",
      "during" : {
        "start" : "2020-08-01T00:00:00.000Z",
        "end" : "2020-08-20T00:00:00.000Z"
      }
    }
  ],
  "availabilityExceptions" : "Katherine is generally unavailable on public holidays and during the Christmas/New Year break"
}

```
