# BeContrastFluidUse - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeContrastFluidUse**

## CodeSystem: BeContrastFluidUse 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-vs-contrastfluid-use | *Version*:1.0.0 |
| Draft as of 2022-05-03 | *Computable Name*:BeContrastFluidUse |

 
Whether use of contrast fluid should be considered. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BeContrastFluidUse](ValueSet-be-vs-contrastfluid-use.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "be-vs-contrastfluid-use",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-vs-contrastfluid-use",
  "version" : "1.0.0",
  "name" : "BeContrastFluidUse",
  "title" : "BeContrastFluidUse",
  "status" : "draft",
  "experimental" : false,
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Whether use of contrast fluid should be considered.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 2,
  "concept" : [
    {
      "code" : "if-necessary",
      "display" : "if-necessary",
      "designation" : [
        {
          "language" : "en",
          "value" : "If necessary."
        }
      ]
    },
    {
      "code" : "not-permitted",
      "display" : "not-permitted",
      "designation" : [
        {
          "language" : "en",
          "value" : "Not permitted."
        }
      ]
    }
  ]
}

```
