# BePrescriptionStatusReason - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BePrescriptionStatusReason**

## CodeSystem: BePrescriptionStatusReason 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BePrescriptionStatusReason |

 
Status reason for the prescription. Initially defined as supporting CodeSystem for the referral prescription. 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BeVSPrescriptionStatusReason](ValueSet-be-vs-prescription-status-reason.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "be-prescription-status-reason",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-status-reason",
  "version" : "1.0.0",
  "name" : "BePrescriptionStatusReason",
  "title" : "BePrescriptionStatusReason",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Status reason for the prescription. Initially defined as supporting CodeSystem for the referral prescription.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 11,
  "concept" : [
    {
      "code" : "blackListed",
      "display" : "Blacklisted prescriber"
    },
    {
      "code" : "multipleSteps",
      "display" : "Multiple steps"
    },
    {
      "code" : "coSign",
      "display" : "Co-sign"
    },
    {
      "code" : "cancelledDraft",
      "display" : "Cancelled draft"
    },
    {
      "code" : "expiredDraft",
      "display" : "Expired draft"
    },
    {
      "code" : "pending",
      "display" : "Pending"
    },
    {
      "code" : "ready",
      "display" : "Ready"
    },
    {
      "code" : "inProgress",
      "display" : "In progress"
    },
    {
      "code" : "inactive",
      "display" : "Inactive"
    },
    {
      "code" : "cancelingReason",
      "display" : "Canceling reason"
    },
    {
      "code" : "expired",
      "display" : "Expired"
    }
  ]
}

```
