# BeCSCoPrescriberChoice - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeCSCoPrescriberChoice**

## CodeSystem: BeCSCoPrescriberChoice 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-co-prescriber-choice | *Version*:1.0.0 |
| Draft as of 2022-05-03 | *Computable Name*:BeCSCoPrescriberChoice |

 
Type of intended performer choice 

 This Code system is referenced in the content logical definition of the following value sets: 

* [BeVsCoPrescriberChoice](ValueSet-be-vs-co-prescriber-choice.md)



## Resource Content

```json
{
  "resourceType" : "CodeSystem",
  "id" : "be-cs-co-prescriber-choice",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-co-prescriber-choice",
  "version" : "1.0.0",
  "name" : "BeCSCoPrescriberChoice",
  "title" : "BeCSCoPrescriberChoice",
  "status" : "draft",
  "experimental" : false,
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "Type of intended performer choice",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "caseSensitive" : false,
  "content" : "complete",
  "count" : 3,
  "concept" : [
    {
      "code" : "mandatory",
      "display" : "The co-prescriber must sign"
    },
    {
      "code" : "one-of-mandatory",
      "display" : "The signature of the co-prescriber counts in the number of required signatures, but not blocking"
    },
    {
      "code" : "recommended",
      "display" : "The signature of the co-prescriber is recommended, but not blocking"
    }
  ]
}

```
