# hl7.fhir.be.referral#1.0.0: Referral Prescription

## Pages

* [Home](index.md)
* [Downloads](downloads.md)
* [Mapping](mapping.md)
* [Artifacts Summary](artifacts.md)
* [Guidance](guidance.md)
* [Changes](changes.md)

## Resources

### CodeSystems

* [BeCommunicationCode](CodeSystem-be-communication-code.md)
* [BeCSCoPrescriberChoice](CodeSystem-be-cs-co-prescriber-choice.md)
* [BeTempRequestedServiceDetail](CodeSystem-be-cs-temp-requested-service-detail.md)
* [BeTempRequestedService](CodeSystem-be-cs-temp-requested-service.md)
* [BePrescriptionProposalType](CodeSystem-be-prescription-proposal-type.md)
* [BePrescriptionStatusReason](CodeSystem-be-prescription-status-reason.md)
* [BeTreatmentStatusReason](CodeSystem-be-treatment-status-reason.md)
* [BeContrastFluidUse](CodeSystem-be-vs-contrastfluid-use.md)

### ValueSets

* [Body Site](ValueSet-be-vs-bodysite-nursing.md)
* [BeVsCoPrescriberChoice](ValueSet-be-vs-co-prescriber-choice.md)
* [BeCoPrescriptionStatus](ValueSet-be-vs-co-prescription-status.md)
* [BeCommunicationMethod](ValueSet-be-vs-communication-method.md)
* [BeContrastFluidUse](ValueSet-be-vs-contrastfluid-use.md)
* [BeVSPerformerTaskStatusReason](ValueSet-be-vs-performer-task-status-reason.md)
* [BeVSPrescriptionStatusReason](ValueSet-be-vs-prescription-status-reason.md)
* [BeVsProposalType](ValueSet-be-vs-proposal-type.md)
* [BeReferralCategory](ValueSet-be-vs-referral-category.md)
* [BeVsRequestIntent](ValueSet-be-vs-request-intent.md)
* [BeVSRequestNoteType](ValueSet-be-vs-request-note-type.md)
* [BeVSRequestedServicesNurseDetail](ValueSet-be-vs-requested-services-nurse-detail.md)
* [BeVSRequestedServicesNurse](ValueSet-be-vs-requested-services-nurse.md)
* [BeVSTreatmentStatusReason](ValueSet-be-vs-treatment-status-reason.md)

### Logicals

* [BeDiagnosticImagingPrescription](StructureDefinition-BeDiagnosticImagingPrescription.md)
* [BeLaboratoryPrescription](StructureDefinition-BeLaboratoryPrescription.md)
* [BeModelNursingPrescription](StructureDefinition-BeModelNursingPrescription.md)
* [BeModelReferralPrescription](StructureDefinition-BeModelReferralPrescription.md)
* [BeModelReferralRequestGroup](StructureDefinition-BeModelReferralRequestGroup.md)
* [BePhysiotherapyPrescription](StructureDefinition-BePhysiotherapyPrescription.md)

### Complex-type Profiles

* [BeContainedOrLogicalReference](StructureDefinition-be-contained-or-logical-reference.md)

### Primitive-type Profiles

* [BeYearMonthDay](StructureDefinition-be-year-month-day.md)

### Resource Profiles

* [BeLabPrescription](StructureDefinition-be-lab-prescription.md)
* [BeOrganizationTask](StructureDefinition-be-organization-task.md)
* [BePerformerTask](StructureDefinition-be-performer-task.md)
* [BeReferralTask](StructureDefinition-be-referral-task.md)
* [BeReferralPrescriptionDiagnosticImaging](StructureDefinition-be-referralprescription-diagnosticimaging.md)
* [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md)
* [BeReferralPrescriptionRequestGroup](StructureDefinition-be-referralprescription-request-group.md)
* [BeReferralPrescription](StructureDefinition-be-referralprescription.md)

### Extensions

* [BeCoPrescriberInfo](StructureDefinition-be-co-prescriber-info.md)
* [BeCoPrescriber](StructureDefinition-be-co-prescriber.md)
* [BeContraindication](StructureDefinition-be-ext-contraindication.md)
* [BeContrastFluidUse](StructureDefinition-be-ext-contrastfluiduse.md)
* [BeFeedbackToPrescriber](StructureDefinition-be-ext-feedback-to-prescriber.md)
* [BeInformParty](StructureDefinition-be-ext-inform-party.md)
* [BeLatestDraftDate](StructureDefinition-be-ext-latest-draft-date.md)
* [BeLatestEndDate](StructureDefinition-be-ext-latest-end-date.md)
* [BePerformerType](StructureDefinition-be-ext-performer-type.md)
* [BeProposalType](StructureDefinition-be-ext-proposal-type.md)
* [BePSSInfo](StructureDefinition-be-ext-pss-info.md)
* [BeSupportingInfo](StructureDefinition-be-ext-supporting-info.md)
* [BeUrgentCommunication](StructureDefinition-be-ext-urgent-communication.md)
* [BeValidityPeriod](StructureDefinition-be-ext-validity-period.md)

### ImplementationGuides

* [Referral Prescription](index.md)

### NamingSystems

* [BeNSCoronalertcode](NamingSystem-be-ns-coronalertcode.md)
* [BeNSSpecimen](NamingSystem-be-ns-specimen.md)
* [BeUnadressedHealthMessageExchangePlatform](NamingSystem-be-ns-uhmep.md)

### OperationDefinitions

* [Cancel Referral Prescription or Proposal](OperationDefinition-be-op-cancel.md)

### SearchParameters

* [statusReason](SearchParameter-be-sp-serviceRequest-statusReason.md)
* [statusProfile](SearchParameter-be-sp-task-status-profile.md)

### StructureMaps

* [be-map-model-referral-prescription](StructureMap-be-map-model-referral-prescription.md)

### Examples

* [gpvisit (CarePlan)](CarePlan-gpvisit.md)
* [condition1 (Condition)](Condition-condition1.md)
* [terminology-expansion (Parameters)](Parameters-terminology-expansion.md)
* [patient1 (Patient)](Patient-patient1.md)
* [Performer1 (Practitioner)](Practitioner-Performer1.md)
* [Requester1 (Practitioner)](Practitioner-Requester1.md)
* [practitioner1 (Practitioner)](Practitioner-practitioner1.md)
* [practitioner2 (Practitioner)](Practitioner-practitioner2.md)
* [practitionerrole1 (PractitionerRole)](PractitionerRole-practitionerrole1.md)
* [requesterrole1 (PractitionerRole)](PractitionerRole-requesterrole1.md)
* [ucgh222p12-1-1 (PractitionerRole)](PractitionerRole-ucgh222p12-1-1.md)
* [ucgh222p12-2-2-2-1 (PractitionerRole)](PractitionerRole-ucgh222p12-2-2-2-1.md)
* [ucgh222p13-1-1 (PractitionerRole)](PractitionerRole-ucgh222p13-1-1.md)
* [ucgh241p110-1-1 (PractitionerRole)](PractitionerRole-ucgh241p110-1-1.md)
* [ucgh241p111-1-1 (PractitionerRole)](PractitionerRole-ucgh241p111-1-1.md)
* [ucgh241p15-1-1 (PractitionerRole)](PractitionerRole-ucgh241p15-1-1.md)
* [ucgh241p16-1-1 (PractitionerRole)](PractitionerRole-ucgh241p16-1-1.md)
* [ucgh241p17-1-1 (PractitionerRole)](PractitionerRole-ucgh241p17-1-1.md)
* [ucgh241p18-1-1 (PractitionerRole)](PractitionerRole-ucgh241p18-1-1.md)
* [ucgh241p19-1-1 (PractitionerRole)](PractitionerRole-ucgh241p19-1-1.md)
* [uc2a (RequestGroup)](RequestGroup-uc2a.md)
* [ucgh222p13 (RequestGroup)](RequestGroup-ucgh222p13.md)
* [diagnostic-imaging-basic-example-concreteWithDetails (ServiceRequest)](ServiceRequest-diagnostic-imaging-basic-example-concreteWithDetails.md)
* [diagnostic-imaging-basic-example-concreteWithText (ServiceRequest)](ServiceRequest-diagnostic-imaging-basic-example-concreteWithText.md)
* [diagnostic-imaging-basic-example-everything-contained (ServiceRequest)](ServiceRequest-diagnostic-imaging-basic-example-everything-contained.md)
* [diagnostic-imaging-basic-example-useOfModality (ServiceRequest)](ServiceRequest-diagnostic-imaging-basic-example-useOfModality.md)
* [example01-care02-colon-cleansing (ServiceRequest)](ServiceRequest-example01-care02-colon-cleansing.md)
* [example02-referralprescription-nursing-digestive-system-care (ServiceRequest)](ServiceRequest-example02-referralprescription-nursing-digestive-system-care.md)
* [example03-referralprescription-nursing-compressiontherapy (ServiceRequest)](ServiceRequest-example03-referralprescription-nursing-compressiontherapy.md)
* [example04-referralprescription-nursing-bladder-care (ServiceRequest)](ServiceRequest-example04-referralprescription-nursing-bladder-care.md)
* [example05-referralprescription-nursing-digestive-system-care (ServiceRequest)](ServiceRequest-example05-referralprescription-nursing-digestive-system-care.md)
* [example06-referralprescription-nursing-compression-therapy (ServiceRequest)](ServiceRequest-example06-referralprescription-nursing-compression-therapy.md)
* [example09-referralprescription-nursing-woundcare (ServiceRequest)](ServiceRequest-example09-referralprescription-nursing-woundcare.md)
* [example12-referralprescription-nursing-annex81 (ServiceRequest)](ServiceRequest-example12-referralprescription-nursing-annex81.md)
* [example16-referralprescription-nursing-bladder-care (ServiceRequest)](ServiceRequest-example16-referralprescription-nursing-bladder-care.md)
* [example24-referralprescription-nursing-non-reimbursable (ServiceRequest)](ServiceRequest-example24-referralprescription-nursing-non-reimbursable.md)
* [example26-referralprescription-nursing-other (ServiceRequest)](ServiceRequest-example26-referralprescription-nursing-other.md)
* [example32-referralprescription-nursing-chronical-psychiatric (ServiceRequest)](ServiceRequest-example32-referralprescription-nursing-chronical-psychiatric.md)
* [laboratory-order-example1 (ServiceRequest)](ServiceRequest-laboratory-order-example1.md)
* [referralprescription-nursing-example2-digestive-system-care (ServiceRequest)](ServiceRequest-referralprescription-nursing-example2-digestive-system-care.md)
* [referralprescription-nursing-example3-compression-therapy (ServiceRequest)](ServiceRequest-referralprescription-nursing-example3-compression-therapy.md)
* [referralprescription-nursing-example5-digestive-system-care (ServiceRequest)](ServiceRequest-referralprescription-nursing-example5-digestive-system-care.md)
* [referralprescription-nursing-example6-compression-therapy (ServiceRequest)](ServiceRequest-referralprescription-nursing-example6-compression-therapy.md)
* [uc2a-1 (ServiceRequest)](ServiceRequest-uc2a-1.md)
* [uc2a-2 (ServiceRequest)](ServiceRequest-uc2a-2.md)
* [uc2a-3 (ServiceRequest)](ServiceRequest-uc2a-3.md)
* [uc5a-1 (ServiceRequest)](ServiceRequest-uc5a-1.md)
* [ucgh211-1 (ServiceRequest)](ServiceRequest-ucgh211-1.md)
* [ucgh222p12-1 (ServiceRequest)](ServiceRequest-ucgh222p12-1.md)
* [ucgh222p12-2 (ServiceRequest)](ServiceRequest-ucgh222p12-2.md)
* [ucgh222p12-3 (ServiceRequest)](ServiceRequest-ucgh222p12-3.md)
* [ucgh222p13-1 (ServiceRequest)](ServiceRequest-ucgh222p13-1.md)
* [ucgh222p13-2 (ServiceRequest)](ServiceRequest-ucgh222p13-2.md)
* [ucgh241p110-1 (ServiceRequest)](ServiceRequest-ucgh241p110-1.md)
* [ucgh241p111-1 (ServiceRequest)](ServiceRequest-ucgh241p111-1.md)
* [ucgh241p15-1 (ServiceRequest)](ServiceRequest-ucgh241p15-1.md)
* [ucgh241p16-1 (ServiceRequest)](ServiceRequest-ucgh241p16-1.md)
* [ucgh241p17-1 (ServiceRequest)](ServiceRequest-ucgh241p17-1.md)
* [ucgh241p18-1 (ServiceRequest)](ServiceRequest-ucgh241p18-1.md)
* [ucgh241p19-1 (ServiceRequest)](ServiceRequest-ucgh241p19-1.md)
* [example01-care02-colon-cleansing-performer-task (Task)](Task-example01-care02-colon-cleansing-performer-task.md)
* [example01-care02-colon-cleansing-referral-task (Task)](Task-example01-care02-colon-cleansing-referral-task.md)
* [performer-task-1-uc2a-1 (Task)](Task-performer-task-1-uc2a-1.md)
* [performer-task-1-uc5a-1 (Task)](Task-performer-task-1-uc5a-1.md)
* [performer-task-2-uc2a-1 (Task)](Task-performer-task-2-uc2a-1.md)
* [performer-task (Task)](Task-performer-task.md)
* [referral-task-uc2a-1 (Task)](Task-referral-task-uc2a-1.md)
* [referral-task-uc5a-1 (Task)](Task-referral-task-uc5a-1.md)
* [referral-task (Task)](Task-referral-task.md)
* [ucgh222p12-1-2-1 (Task)](Task-ucgh222p12-1-2-1.md)
* [ucgh222p12-1-2 (Task)](Task-ucgh222p12-1-2.md)
* [ucgh222p12-2-2-1 (Task)](Task-ucgh222p12-2-2-1.md)
* [ucgh222p12-2-2-2 (Task)](Task-ucgh222p12-2-2-2.md)
* [ucgh222p12-2-2 (Task)](Task-ucgh222p12-2-2.md)
