# Artifacts Summary - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* **Artifacts Summary**

## Artifacts Summary

This page provides a list of the FHIR artifacts defined as part of this implementation guide.

### Behavior: Operation Definitions 

These are custom operations that can be supported by and/or invoked by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [be-op-cancel](OperationDefinition-be-op-cancel.md) | Cancel Referral Prescription or Proposal |

### Behavior: Search Parameters 

These define the properties by which a RESTful server can be searched. They can also be used for sorting and including related resources.

| | |
| :--- | :--- |
| [BeSPServiceRequestStatusReason](SearchParameter-be-sp-serviceRequest-statusReason.md) | This SearchParameter enables query of ServiceRequests by the statusReason extension. |
| [BeSPTaskStatusProfile](SearchParameter-be-sp-task-status-profile.md) | This SearchParameter enables query of Tasks on the combination of status and profile |

### Structures: Logical Models 

These define data models that represent the domain covered by this implementation guide in more business-friendly terms than the underlying FHIR resources.

| | |
| :--- | :--- |
| [BeDiagnosticImagingPrescription](StructureDefinition-BeDiagnosticImagingPrescription.md) | Logical model describing the model for the diagnostic imaging prescription. This draft is used in the HL7 Belgian workgroup for referral. |
| [BeLaboratoryPrescription](StructureDefinition-BeLaboratoryPrescription.md) | Logical model describing the model for the prescription laboratory. This draft is used in the HL7 Belgian workgroup for laboratory. |
| [BeModelNursingPrescription](StructureDefinition-BeModelNursingPrescription.md) |  |
| [BeModelReferralPrescription](StructureDefinition-BeModelReferralPrescription.md) | Logical model describing the model for the prescription referral. This draft is used in the HL7 Belgian workgroup for referral. |
| [BeModelReferralRequestGroup](StructureDefinition-BeModelReferralRequestGroup.md) | Logical model describing the model for a group of referral prescriptions. This draft is used in the HL7 Belgian workgroup for referral. |
| [BePhysiotherapyPrescription](StructureDefinition-BePhysiotherapyPrescription.md) |  |

### Structures: Resource Profiles 

These define constraints on FHIR resources for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BeLabPrescription](StructureDefinition-be-lab-prescription.md) | This is the Belgian profile for a laboratory order. |
| [BeOrganizationTask](StructureDefinition-be-organization-task.md) | Subtask to assign the referral task and prescription to one or more members of this organisation |
| [BePerformerTask](StructureDefinition-be-performer-task.md) | Subtask performed by one performer |
| [BeReferralPrescription](StructureDefinition-be-referralprescription.md) | The common structure for referral prescription. |
| [BeReferralPrescriptionDiagnosticImaging](StructureDefinition-be-referralprescription-diagnosticimaging.md) | Referral prescription for a generic diagnostic imaging. Please note in .orderDetail, a specific slicing is available to give guidance how to express acquisition modalities if needed. In future iterations of this profile, more slicing might provide additional guidance. |
| [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md) | The nursing profile, generic version. Please note the nursing referral for medication does NOT depend on this generic version but is a FHIR prodfile on a different FHIR resource (MedicationRequest) |
| [BeReferralPrescriptionRequestGroup](StructureDefinition-be-referralprescription-request-group.md) | Envelope that allows different referralprescriptions to have an order |
| [BeReferralTask](StructureDefinition-be-referral-task.md) | The task that is referred to in the referral prescription (this is the common task for the execution of the prescription). The subtasks per performer can be found in BePerformerTask |

### Structures: Data Type Profiles 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BeContainedOrLogicalReference](StructureDefinition-be-contained-or-logical-reference.md) | A reference limited to contained resources or resources with a logical identifier. |
| [BeYearMonthDay](StructureDefinition-be-year-month-day.md) | a datetime of length 10 or empty |

### Structures: Extension Definitions 

These define constraints on FHIR data types for systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BeCoPrescriber](StructureDefinition-be-co-prescriber.md) | Other practitioners that must take part in this prescripiton |
| [BeCoPrescriberInfo](StructureDefinition-be-co-prescriber-info.md) | Info about the other practitioners that must take part in this prescripiton |
| [BeContraindication](StructureDefinition-be-ext-contraindication.md) | Contra indication in a prescription referral for diagnostic imaging. |
| [BeContrastFluidUse](StructureDefinition-be-ext-contrastfluiduse.md) | Whether the use of contrast fluid in diagnostic imaging can be defined as ‘If necessary’ or ‘Not permitted.’ |
| [BeFeedbackToPrescriber](StructureDefinition-be-ext-feedback-to-prescriber.md) | Does the prescriber request feedback? |
| [BeInformParty](StructureDefinition-be-ext-inform-party.md) | Extra parties that need to be informed of the outcome, besides the prescriber. |
| [BeLatestDraftDate](StructureDefinition-be-ext-latest-draft-date.md) | Request must leave draft status before |
| [BeLatestEndDate](StructureDefinition-be-ext-latest-end-date.md) | Request must be performed before |
| [BePSSInfo](StructureDefinition-be-ext-pss-info.md) | Information regarding the Prescription Search Support |
| [BePerformerType](StructureDefinition-be-ext-performer-type.md) | Types of performers that can execute this request |
| [BeProposalType](StructureDefinition-be-ext-proposal-type.md) | Type of proposal |
| [BeSupportingInfo](StructureDefinition-be-ext-supporting-info.md) | Relevant clinical information in the context of this prescription concerning for example allergies, kidney function, diabetic. This extension allows the use of an Annotation or codeableConcept but when more detailed information can be given, it is RECOMMENDED to express it as structured as possible using the appropriate elements. |
| [BeUrgentCommunication](StructureDefinition-be-ext-urgent-communication.md) | When there is a need to urgently communicate results of an order. |
| [BeValidityPeriod](StructureDefinition-be-ext-validity-period.md) | Begin and enddate of the validity of the request |

### Terminology: Value Sets 

These define sets of codes used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BeCoPrescriptionStatus](ValueSet-be-vs-co-prescription-status.md) | This is the status of the prescription for the coprescriber |
| [BeCommunicationMethod](ValueSet-be-vs-communication-method.md) | Codes to define a communication method. |
| [BeContrastFluidUse](ValueSet-be-vs-contrastfluid-use.md) | Codes to define the use of contrast fluid. |
| [BeReferralCategory](ValueSet-be-vs-referral-category.md) | Codes to define the high level category for a referral prescription. SNOMED-CT codes in this valueset are just a draft proposal to give a general idea - pending an official valueset. |
| [BeVSPerformerTaskStatusReason](ValueSet-be-vs-performer-task-status-reason.md) | Codes to explain the current status of a referral prescription. |
| [BeVSPrescriptionStatusReason](ValueSet-be-vs-prescription-status-reason.md) | This is the status reason of the prescription |
| [BeVSRequestNoteType](ValueSet-be-vs-request-note-type.md) | Types of notes used in a referral prescription |
| [BeVSRequestedServicesNurse](ValueSet-be-vs-requested-services-nurse.md) | Codes indicating the requests that can be asked from a nurse. |
| [BeVSRequestedServicesNurseDetail](ValueSet-be-vs-requested-services-nurse-detail.md) | Codes indicating the request details that can be asked from a nurse. |
| [BeVSTreatmentStatusReason](ValueSet-be-vs-treatment-status-reason.md) | Codes to explain the current status of a treatment in a referral prescription. |
| [BeVsCoPrescriberChoice](ValueSet-be-vs-co-prescriber-choice.md) | Type of intended performer choice |
| [BeVsProposalType](ValueSet-be-vs-proposal-type.md) | If the status of the request is proposal, this valueset indicates the different types of proposal |
| [BeVsRequestIntent](ValueSet-be-vs-request-intent.md) | The allowed intent codes in the context of referral prescription |
| [Body Site](ValueSet-be-vs-bodysite-nursing.md) | Body Site |

### Terminology: Code Systems 

These define new code systems used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BeCSCoPrescriberChoice](CodeSystem-be-cs-co-prescriber-choice.md) | Type of intended performer choice |
| [BeCommunicationCode](CodeSystem-be-communication-code.md) | Communication codes in Belgium. To define a specific method of communicating. Initially defined as supporting CodeSystem for the referral prescription. |
| [BeContrastFluidUse](CodeSystem-be-vs-contrastfluid-use.md) | Whether use of contrast fluid should be considered. |
| [BePrescriptionProposalType](CodeSystem-be-prescription-proposal-type.md) | Prescription Proposal Type. Indicates the type of proposal (new or prolongation) as from the uses cases by NIHDI |
| [BePrescriptionStatusReason](CodeSystem-be-prescription-status-reason.md) | Status reason for the prescription. Initially defined as supporting CodeSystem for the referral prescription. |
| [BeTempRequestedService](CodeSystem-be-cs-temp-requested-service.md) | Temporary codes for indicating services that can be requested from a Nurse |
| [BeTempRequestedServiceDetail](CodeSystem-be-cs-temp-requested-service-detail.md) | Temporary codes for indicating service details that can be requested from a Nurse |
| [BeTreatmentStatusReason](CodeSystem-be-treatment-status-reason.md) | Status reason for the treatment. Initially defined as supporting CodeSystem for the referral prescription. |

### Terminology: Naming Systems 

These define identifier and/or code system identities used by systems conforming to this implementation guide.

| | |
| :--- | :--- |
| [BeNSCoronalertcode](NamingSystem-be-ns-coronalertcode.md) | Code as generated by the Coronalert app. |
| [BeNSSpecimen](NamingSystem-be-ns-specimen.md) | National identifier for a specimen when needed. |
| [BeUnadressedHealthMessageExchangePlatform](NamingSystem-be-ns-uhmep.md) | UHMEP naming system |

### Terminology: Structure Maps 

These define transformations to convert between data structures used by systems conforming to this implementation guide.

| |
| :--- |
| [be-map-model-referral-prescription](StructureMap-be-map-model-referral-prescription.md) |

### Example: Example Instances 

These are example instances that show what data produced and consumed by systems conforming with this implementation guide might look like.

| |
| :--- |
| [Performer1](Practitioner-Performer1.md) |
| [Requester1](Practitioner-Requester1.md) |
| [condition1](Condition-condition1.md) |
| [diagnostic-imaging-basic-example-concreteWithDetails](ServiceRequest-diagnostic-imaging-basic-example-concreteWithDetails.md) |
| [diagnostic-imaging-basic-example-concreteWithText](ServiceRequest-diagnostic-imaging-basic-example-concreteWithText.md) |
| [diagnostic-imaging-basic-example-everything-contained](ServiceRequest-diagnostic-imaging-basic-example-everything-contained.md) |
| [diagnostic-imaging-basic-example-useOfModality](ServiceRequest-diagnostic-imaging-basic-example-useOfModality.md) |
| [example01-care02-colon-cleansing](ServiceRequest-example01-care02-colon-cleansing.md) |
| [example01-care02-colon-cleansing-performer-task](Task-example01-care02-colon-cleansing-performer-task.md) |
| [example01-care02-colon-cleansing-referral-task](Task-example01-care02-colon-cleansing-referral-task.md) |
| [example02-referralprescription-nursing-digestive-system-care](ServiceRequest-example02-referralprescription-nursing-digestive-system-care.md) |
| [example03-referralprescription-nursing-compressiontherapy](ServiceRequest-example03-referralprescription-nursing-compressiontherapy.md) |
| [example04-referralprescription-nursing-bladder-care](ServiceRequest-example04-referralprescription-nursing-bladder-care.md) |
| [example05-referralprescription-nursing-digestive-system-care](ServiceRequest-example05-referralprescription-nursing-digestive-system-care.md) |
| [example06-referralprescription-nursing-compression-therapy](ServiceRequest-example06-referralprescription-nursing-compression-therapy.md) |
| [example09-referralprescription-nursing-woundcare](ServiceRequest-example09-referralprescription-nursing-woundcare.md) |
| [example12-referralprescription-nursing-annex81](ServiceRequest-example12-referralprescription-nursing-annex81.md) |
| [example16-referralprescription-nursing-bladder-care](ServiceRequest-example16-referralprescription-nursing-bladder-care.md) |
| [example24-referralprescription-nursing-non-reimbursable](ServiceRequest-example24-referralprescription-nursing-non-reimbursable.md) |
| [example26-referralprescription-nursing-other](ServiceRequest-example26-referralprescription-nursing-other.md) |
| [example32-referralprescription-nursing-chronical-psychiatric](ServiceRequest-example32-referralprescription-nursing-chronical-psychiatric.md) |
| [gpvisit](CarePlan-gpvisit.md) |
| [laboratory-order-example1](ServiceRequest-laboratory-order-example1.md) |
| [patient1](Patient-patient1.md) |
| [performer-task](Task-performer-task.md) |
| [performer-task-1-uc2a-1](Task-performer-task-1-uc2a-1.md) |
| [performer-task-1-uc5a-1](Task-performer-task-1-uc5a-1.md) |
| [performer-task-2-uc2a-1](Task-performer-task-2-uc2a-1.md) |
| [practitioner1](Practitioner-practitioner1.md) |
| [practitioner2](Practitioner-practitioner2.md) |
| [practitionerrole1](PractitionerRole-practitionerrole1.md) |
| [referral-task](Task-referral-task.md) |
| [referral-task-uc2a-1](Task-referral-task-uc2a-1.md) |
| [referral-task-uc5a-1](Task-referral-task-uc5a-1.md) |
| [referralprescription-nursing-example2-digestive-system-care](ServiceRequest-referralprescription-nursing-example2-digestive-system-care.md) |
| [referralprescription-nursing-example3-compression-therapy](ServiceRequest-referralprescription-nursing-example3-compression-therapy.md) |
| [referralprescription-nursing-example5-digestive-system-care](ServiceRequest-referralprescription-nursing-example5-digestive-system-care.md) |
| [referralprescription-nursing-example6-compression-therapy](ServiceRequest-referralprescription-nursing-example6-compression-therapy.md) |
| [requesterrole1](PractitionerRole-requesterrole1.md) |
| [terminology-expansion](Parameters-terminology-expansion.md) |
| [uc2a](RequestGroup-uc2a.md) |
| [uc2a-1](ServiceRequest-uc2a-1.md) |
| [uc2a-2](ServiceRequest-uc2a-2.md) |
| [uc2a-3](ServiceRequest-uc2a-3.md) |
| [uc5a-1](ServiceRequest-uc5a-1.md) |
| [ucgh211-1](ServiceRequest-ucgh211-1.md) |
| [ucgh222p12-1](ServiceRequest-ucgh222p12-1.md) |
| [ucgh222p12-1-1](PractitionerRole-ucgh222p12-1-1.md) |
| [ucgh222p12-1-2](Task-ucgh222p12-1-2.md) |
| [ucgh222p12-1-2-1](Task-ucgh222p12-1-2-1.md) |
| [ucgh222p12-2](ServiceRequest-ucgh222p12-2.md) |
| [ucgh222p12-2-2](Task-ucgh222p12-2-2.md) |
| [ucgh222p12-2-2-1](Task-ucgh222p12-2-2-1.md) |
| [ucgh222p12-2-2-2](Task-ucgh222p12-2-2-2.md) |
| [ucgh222p12-2-2-2-1](PractitionerRole-ucgh222p12-2-2-2-1.md) |
| [ucgh222p12-3](ServiceRequest-ucgh222p12-3.md) |
| [ucgh222p13](RequestGroup-ucgh222p13.md) |
| [ucgh222p13-1](ServiceRequest-ucgh222p13-1.md) |
| [ucgh222p13-1-1](PractitionerRole-ucgh222p13-1-1.md) |
| [ucgh222p13-2](ServiceRequest-ucgh222p13-2.md) |
| [ucgh241p110-1](ServiceRequest-ucgh241p110-1.md) |
| [ucgh241p110-1-1](PractitionerRole-ucgh241p110-1-1.md) |
| [ucgh241p111-1](ServiceRequest-ucgh241p111-1.md) |
| [ucgh241p111-1-1](PractitionerRole-ucgh241p111-1-1.md) |
| [ucgh241p15-1](ServiceRequest-ucgh241p15-1.md) |
| [ucgh241p15-1-1](PractitionerRole-ucgh241p15-1-1.md) |
| [ucgh241p16-1](ServiceRequest-ucgh241p16-1.md) |
| [ucgh241p16-1-1](PractitionerRole-ucgh241p16-1-1.md) |
| [ucgh241p17-1](ServiceRequest-ucgh241p17-1.md) |
| [ucgh241p17-1-1](PractitionerRole-ucgh241p17-1-1.md) |
| [ucgh241p18-1](ServiceRequest-ucgh241p18-1.md) |
| [ucgh241p18-1-1](PractitionerRole-ucgh241p18-1-1.md) |
| [ucgh241p19-1](ServiceRequest-ucgh241p19-1.md) |
| [ucgh241p19-1-1](PractitionerRole-ucgh241p19-1-1.md) |

