# BeVSRequestedServicesNurseDetail - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeVSRequestedServicesNurseDetail**

## ValueSet: BeVSRequestedServicesNurseDetail 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-requested-services-nurse-detail | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeVSRequestedServicesNurseDetail |

 
Codes indicating the request details that can be asked from a nurse. 

 **References** 

* [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md)

### Logical Definition (CLD)

 

### Expansion

Expansion from tx.fhir.org based on:

* SNOMED CT Belgian Edition edition 15-Nov 2023
* [codesystem BeTempRequestedServiceDetail v1.0.0 (CodeSystem)](CodeSystem-be-cs-temp-requested-service-detail.md)

This value set contains 86 concepts

**Additional Designations and Language Displays**

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "be-vs-requested-services-nurse-detail",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-requested-services-nurse-detail",
  "version" : "1.0.0",
  "name" : "BeVSRequestedServicesNurseDetail",
  "title" : "BeVSRequestedServicesNurseDetail",
  "status" : "draft",
  "experimental" : false,
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "Codes indicating the request details that can be asked from a nurse.",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-cs-temp-requested-service-detail"
      },
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000172109",
        "concept" : [
          {
            "code" : "118292001"
          },
          {
            "code" : "162098000"
          },
          {
            "code" : "163033001"
          },
          {
            "code" : "163034007"
          },
          {
            "code" : "173765009"
          },
          {
            "code" : "176192000"
          },
          {
            "code" : "182524008"
          },
          {
            "code" : "18949003"
          },
          {
            "code" : "225103006"
          },
          {
            "code" : "225150002"
          },
          {
            "code" : "225908003"
          },
          {
            "code" : "226007004"
          },
          {
            "code" : "2267008"
          },
          {
            "code" : "241025004"
          },
          {
            "code" : "246124003"
          },
          {
            "code" : "247450001"
          },
          {
            "code" : "248343001"
          },
          {
            "code" : "256897009"
          },
          {
            "code" : "262061000"
          },
          {
            "code" : "262068006"
          },
          {
            "code" : "30549001"
          },
          {
            "code" : "335353000"
          },
          {
            "code" : "35963001"
          },
          {
            "code" : "364632003"
          },
          {
            "code" : "364689004"
          },
          {
            "code" : "36777000"
          },
          {
            "code" : "370858005"
          },
          {
            "code" : "37318803"
          },
          {
            "code" : "3895009"
          },
          {
            "code" : "390951007"
          },
          {
            "code" : "39477002"
          },
          {
            "code" : "408342007"
          },
          {
            "code" : "410021007"
          },
          {
            "code" : "410379003"
          },
          {
            "code" : "410582009"
          },
          {
            "code" : "410619003"
          },
          {
            "code" : "41351007"
          },
          {
            "code" : "415882003"
          },
          {
            "code" : "431314004"
          },
          {
            "code" : "445606007"
          },
          {
            "code" : "450969007"
          },
          {
            "code" : "45710003"
          },
          {
            "code" : "467848007"
          },
          {
            "code" : "48817005"
          },
          {
            "code" : "55449009"
          },
          {
            "code" : "6125005"
          },
          {
            "code" : "698610002"
          },
          {
            "code" : "699826006"
          },
          {
            "code" : "75325006"
          },
          {
            "code" : "75367002"
          },
          {
            "code" : "762238003"
          },
          {
            "code" : "78014005"
          },
          {
            "code" : "791006"
          },
          {
            "code" : "79165006"
          },
          {
            "code" : "79710002"
          },
          {
            "code" : "81011003"
          },
          {
            "code" : "8499008"
          },
          {
            "code" : "86290005"
          },
          {
            "code" : "87612001"
          },
          {
            "code" : "87750000"
          },
          {
            "code" : "89826002"
          },
          {
            "code" : "90838004"
          },
          {
            "code" : "337414009"
          }
        ]
      }
    ]
  }
}

```
