# BeVsProposalType - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeVsProposalType**

## ValueSet: BeVsProposalType 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-proposal-type | *Version*:1.0.0 |
| Active as of 2022-05-03 | *Computable Name*:BeVsProposalType |

 
If the status of the request is proposal, this valueset indicates the different types of proposal 

 **References** 

* [BeProposalType](StructureDefinition-be-ext-proposal-type.md)

### Logical Definition (CLD)

* Include all codes defined in [`https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-proposal-type`](CodeSystem-be-prescription-proposal-type.md) version 📦1.0.0

 

### Expansion

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "be-vs-proposal-type",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-proposal-type",
  "version" : "1.0.0",
  "name" : "BeVsProposalType",
  "title" : "BeVsProposalType",
  "status" : "active",
  "experimental" : false,
  "date" : "2022-05-03T10:04:16+02:00",
  "contact" : [
    {
      "name" : "HL7 Belgium",
      "telecom" : [
        {
          "system" : "url",
          "value" : "http://hl7belgium.org"
        }
      ]
    },
    {
      "name" : "Message-Structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be",
          "use" : "work"
        }
      ]
    }
  ],
  "description" : "If the status of the request is proposal, this valueset indicates the different types of proposal",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "https://www.ehealth.fgov.be/standards/fhir/referral/CodeSystem/be-prescription-proposal-type"
      }
    ]
  }
}

```
