# Body Site - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **Body Site**

## ValueSet: Body Site 

| | | |
| :--- | :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-bodysite-nursing | *Version*:1.0.0 | |
| Active as of 2021-01-10 | [Maturity Level](http://hl7.org/fhir/versions.html#maturity): 1 | *Computable Name*:BeVSBodySiteNursing |

 
Body Site 

 **References** 

* [BeReferralPrescriptionNursing](StructureDefinition-be-referralprescription-nursing.md)

### Logical Definition (CLD)

 

### Expansion

No Expansion for this valueset (not supported by Publication Tooling)

-------

 Explanation of the columns that may appear on this page: 

| | |
| :--- | :--- |
| Level | A few code lists that FHIR defines are hierarchical - each code is assigned a level. In this scheme, some codes are under other codes, and imply that the code they are under also applies |
| System | The source of the definition of the code (when the value set draws in codes defined elsewhere) |
| Code | The code (used as the code in the resource instance) |
| Display | The display (used in the*display*element of a[Coding](http://hl7.org/fhir/R4/datatypes.html#Coding)). If there is no display, implementers should not simply display the code, but map the concept into their application |
| Definition | An explanation of the meaning of the concept |
| Comments | Additional notes about how to use the code |



## Resource Content

```json
{
  "resourceType" : "ValueSet",
  "id" : "be-vs-bodysite-nursing",
  "extension" : [
    {
      "url" : "http://hl7.org/fhir/StructureDefinition/structuredefinition-fmm",
      "valueInteger" : 1
    }
  ],
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/ValueSet/be-vs-bodysite-nursing",
  "version" : "1.0.0",
  "name" : "BeVSBodySiteNursing",
  "title" : "Body Site",
  "status" : "active",
  "experimental" : false,
  "date" : "2021-01-10T10:59:49+00:00",
  "contact" : [
    {
      "name" : "eHealth Platform",
      "telecom" : [
        {
          "system" : "url",
          "value" : "https://www.ehealth.fgov.be"
        }
      ]
    },
    {
      "name" : "Message structure",
      "telecom" : [
        {
          "system" : "email",
          "value" : "message-structure@ehealth.fgov.be"
        }
      ]
    }
  ],
  "description" : "Body Site",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "compose" : {
    "include" : [
      {
        "system" : "http://snomed.info/sct",
        "version" : "http://snomed.info/sct/11000172109",
        "concept" : [
          {
            "code" : "31640002"
          },
          {
            "code" : "789699009"
          },
          {
            "code" : "78277001"
          },
          {
            "code" : "117590005"
          },
          {
            "code" : "302549007"
          },
          {
            "code" : "81745001"
          },
          {
            "code" : "60819002"
          },
          {
            "code" : "48477009"
          },
          {
            "code" : "1797002"
          },
          {
            "code" : "45206002"
          },
          {
            "code" : "123851003"
          },
          {
            "code" : "727234005"
          },
          {
            "code" : "51185008"
          },
          {
            "code" : "113345001"
          },
          {
            "code" : "85710004"
          },
          {
            "code" : "302543008"
          },
          {
            "code" : "30547001"
          },
          {
            "code" : "182281004"
          },
          {
            "code" : "421235005"
          },
          {
            "code" : "87342007"
          },
          {
            "code" : "78234002"
          },
          {
            "code" : "72696002"
          },
          {
            "code" : "182034009"
          },
          {
            "code" : "731694000"
          },
          {
            "code" : "54735007"
          },
          {
            "code" : "53505006"
          },
          {
            "code" : "76784001"
          },
          {
            "code" : "18911002"
          },
          {
            "code" : "56459004"
          },
          {
            "code" : "344001"
          },
          {
            "code" : "360857004"
          },
          {
            "code" : "76853006"
          },
          {
            "code" : "78883009"
          },
          {
            "code" : "55078004"
          },
          {
            "code" : "78132007"
          },
          {
            "code" : "80349001"
          },
          {
            "code" : "39915008"
          },
          {
            "code" : "244187005"
          },
          {
            "code" : "16982005"
          },
          {
            "code" : "79601000"
          },
          {
            "code" : "53120007"
          },
          {
            "code" : "14975008"
          },
          {
            "code" : "127949000"
          },
          {
            "code" : "85562004"
          }
        ]
      }
    ]
  }
}

```
