# be-map-model-referral-prescription - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **be-map-model-referral-prescription**

## StructureMap: be-map-model-referral-prescription 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureMap/be-map-model-referral-prescription | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:be-map-model-referral-prescription |

```
map "https://www.ehealth.fgov.be/standards/fhir/referral/StructureMap/be-map-model-referral-prescription" = "be-map-model-referral-prescription"

uses "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-model-referralprescription" alias BeModelReferralPrescription as source
uses "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription" alias BeReferralPrescription as target



group Main(source model : BeModelReferralPrescription, target profile : BeReferralPrescription) {
    model.recordedDate as a -> profile.authoredOn = a;
    model.recorder as recorder -> profile.extension = create('Extension') as ext, 
        ext.url = "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-ext-recorder", 
        ext.value = recorder;
    model.prescriber as prescriber -> profile.requester = prescriber;
    model.'co-prescriberNr' as nr, model.'co-prescriber' as co -> profile.extension = create('Extension') as ext,
    ext.url = "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-co-prescriber-info", 
    ext.value = recorder'c0';
     
}




```



## Resource Content

```json
{
  "resourceType" : "StructureMap",
  "id" : "be-map-model-referral-prescription",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureMap/be-map-model-referral-prescription",
  "version" : "1.0.0",
  "name" : "be-map-model-referral-prescription",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "structure" : [
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-model-referralprescription",
      "mode" : "source",
      "alias" : "BeModelReferralPrescription"
    },
    {
      "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-referralprescription",
      "mode" : "target",
      "alias" : "BeReferralPrescription"
    }
  ],
  "group" : [
    {
      "name" : "Main",
      "typeMode" : "none",
      "input" : [
        {
          "name" : "model",
          "type" : "BeModelReferralPrescription",
          "mode" : "source"
        },
        {
          "name" : "profile",
          "type" : "BeReferralPrescription",
          "mode" : "target"
        }
      ],
      "rule" : [
        {
          "name" : "recordedDate",
          "source" : [
            {
              "context" : "model",
              "element" : "recordedDate",
              "variable" : "a"
            }
          ],
          "target" : [
            {
              "context" : "profile",
              "contextType" : "variable",
              "element" : "authoredOn",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "a"
                }
              ]
            }
          ]
        },
        {
          "name" : "recorder",
          "source" : [
            {
              "context" : "model",
              "element" : "recorder",
              "variable" : "recorder"
            }
          ],
          "target" : [
            {
              "context" : "profile",
              "contextType" : "variable",
              "element" : "extension",
              "variable" : "ext",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Extension"
                }
              ]
            },
            {
              "context" : "ext",
              "contextType" : "variable",
              "element" : "url",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "https://www.ehealth.fgov.be/standards/fhir/core/StructureDefinition/be-ext-recorder"
                }
              ]
            },
            {
              "context" : "ext",
              "contextType" : "variable",
              "element" : "value",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "recorder"
                }
              ]
            }
          ]
        },
        {
          "name" : "prescriber",
          "source" : [
            {
              "context" : "model",
              "element" : "prescriber",
              "variable" : "prescriber"
            }
          ],
          "target" : [
            {
              "context" : "profile",
              "contextType" : "variable",
              "element" : "requester",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "prescriber"
                }
              ]
            }
          ]
        },
        {
          "name" : "c0",
          "source" : [
            {
              "context" : "model",
              "element" : "'co-prescriberNr'",
              "variable" : "nr"
            },
            {
              "context" : "model",
              "element" : "'co-prescriber'",
              "variable" : "co"
            }
          ],
          "target" : [
            {
              "context" : "profile",
              "contextType" : "variable",
              "element" : "extension",
              "variable" : "ext",
              "transform" : "create",
              "parameter" : [
                {
                  "valueString" : "Extension"
                }
              ]
            },
            {
              "context" : "ext",
              "contextType" : "variable",
              "element" : "url",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueString" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-ext-co-prescriber-info"
                }
              ]
            },
            {
              "context" : "ext",
              "contextType" : "variable",
              "element" : "value",
              "transform" : "copy",
              "parameter" : [
                {
                  "valueId" : "recorder"
                }
              ]
            }
          ]
        }
      ]
    }
  ]
}

```
