# BeYearMonthDay - Referral Prescription v1.0.0

* [**Table of Contents**](toc.md)
* [**Artifacts Summary**](artifacts.md)
* **BeYearMonthDay**

## Data Type Profile: BeYearMonthDay 

| | |
| :--- | :--- |
| *Official URL*:https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-year-month-day | *Version*:1.0.0 |
| Draft as of 2025-10-10 | *Computable Name*:BeYearMonthDay |

 
a datetime of length 10 or empty 

**Usages:**

* Use this Primitive Type Profile: [BeLatestDraftDate](StructureDefinition-be-ext-latest-draft-date.md), [BeLatestEndDate](StructureDefinition-be-ext-latest-end-date.md), [BeValidityPeriod](StructureDefinition-be-ext-validity-period.md) and [BeReferralTask](StructureDefinition-be-referral-task.md)

You can also check for [usages in the FHIR IG Statistics](https://packages2.fhir.org/xig/hl7.fhir.be.referral|current/StructureDefinition/be-year-month-day)

### Formal Views of Profile Content

 [Description of Profiles, Differentials, Snapshots and how the different presentations work](http://build.fhir.org/ig/FHIR/ig-guidance/readingIgs.html#structure-definitions). 

 

Other representations of profile: [CSV](StructureDefinition-be-year-month-day.csv), [Excel](StructureDefinition-be-year-month-day.xlsx), [Schematron](StructureDefinition-be-year-month-day.sch) 



## Resource Content

```json
{
  "resourceType" : "StructureDefinition",
  "id" : "be-year-month-day",
  "url" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-year-month-day",
  "version" : "1.0.0",
  "name" : "BeYearMonthDay",
  "status" : "draft",
  "date" : "2025-10-10T11:53:35+00:00",
  "description" : "a datetime of length 10 or empty",
  "jurisdiction" : [
    {
      "coding" : [
        {
          "system" : "urn:iso:std:iso:3166",
          "code" : "BE",
          "display" : "Belgium"
        }
      ]
    }
  ],
  "fhirVersion" : "4.0.1",
  "kind" : "primitive-type",
  "abstract" : false,
  "type" : "dateTime",
  "baseDefinition" : "http://hl7.org/fhir/StructureDefinition/dateTime",
  "derivation" : "constraint",
  "differential" : {
    "element" : [
      {
        "id" : "dateTime",
        "path" : "dateTime",
        "constraint" : [
          {
            "key" : "be-inv-year-month-day",
            "severity" : "error",
            "human" : "date SHALL be of format YYYY-MM-DD",
            "expression" : "empty() or toString().length()=10",
            "source" : "https://www.ehealth.fgov.be/standards/fhir/referral/StructureDefinition/be-year-month-day"
          }
        ]
      }
    ]
  }
}

```
